package elazyrest.core.provider;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * @author kaz
 *
 */
public class SingletonProvider {
	private static SingletonProvider _instance = new SingletonProvider();
	
	private static Log log = LogFactory.getLog(SingletonProvider.class);

	protected Map<Class<?>, Object> instances = new HashMap<Class<?>, Object>();
	protected Map<String, Object> keyInstances = new HashMap<String, Object>();
	
	public static Object get(Class<?> cl) {
		return _instance.getInstance(cl);
	}

	public static Object get(String key) {
		return _instance.getKeyInstance(key);
	}

	public static boolean contains(Class<?> cl) {
		return _instance.instances.containsKey(cl);
	}

	public static boolean contains(String key) {
		return _instance.keyInstances.containsKey(key);
	}

	public static void set(Class<?> cl, Object instance) {
		synchronized (_instance.instances) {
			_instance.instances.put(cl, instance);
		}
	}
	
	public static void set(String key, Object instance) {
		synchronized (_instance.keyInstances) {
			_instance.keyInstances.put(key, instance);
		}
	}
	
	public Object getInstance(Class<?> cl) {
		Object targetInstance = null;
		try {
			synchronized (instances) {
				if (instances.containsKey(cl)) {
					targetInstance = instances.get(cl);
				}
			}
			if (targetInstance == null) {
				targetInstance = cl.newInstance();
				synchronized (instances) {
					if (instances.containsKey(cl)) {
						targetInstance = instances.get(cl);
					}
					else {
						instances.put(cl, targetInstance);
					}
				}
			}
			return targetInstance;
		}
		catch (InstantiationException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
		catch (IllegalAccessException e) {
			log.error(e.getMessage(), e);
			//e.printStackTrace();
			throw new RuntimeException(e);
		}
	}
	
	public Object getKeyInstance(String key) {
		return keyInstances.get(key);
	}
	
	public static void clear() {
		synchronized (_instance.instances) {
			_instance.instances.clear();
		}
		synchronized (_instance.keyInstances) {
			_instance.keyInstances.clear();
		}
	}
}
