/*
 * @(#)AppContext.java
 *
 * Copyright 2007 Infocity 
 */
package elazyrest.core.util;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import elazyrest.core.provider.PropertiesLoader;


/**
 * AvP[VNX
 * XbhZ[t
 * 
 * @author kaz
 * @version $Revision: 1.1 $ $Date: 2007/09/05 08:10:01 $
 */
public class AppContext {

	private static ThreadLocal<AppContext> appContext = new ThreadLocal<AppContext>();

	private static Log log = LogFactory.getLog(AppContext.class);
	
	/**
	 * NGXg
	 */
	private HttpServletRequest req = null;

	/**
	 * X|X
	 */
	private HttpServletResponse res = null;
	
	private boolean isMultiPart = false;

	private boolean isBinary = false;

	private List mixedList = null;

	private String msgLocale = "ja";
	/**
	 * CX^XԂ
	 * 
	 * @return AppContextIuWFNg
	 */
	public static AppContext getContext() {
		return appContext.get();
	}

	/**
	 * CX^XԂ
	 * XbhZ[t
	 * 
	 * @return AppContextIuWFNg
	 */
	public static void setCurrentContext(AppContext context) {
		appContext.set(context);
	}

	/**
	 * NGXg擾
	 * 
	 * @return ServletRequest NGXg
	 */
	public HttpServletRequest getRequest() {
		return req;
	}

	/**
	 * X|X擾
	 * 
	 * @return ServletResponse X|X
	 */
	public HttpServletResponse getResponse() {
		return res;
	}

	/**
	 * encoding擾
	 * 
	 * @return GR[h
	 */
	public String getRequestEncoding() {
		return req.getCharacterEncoding();
	}	

	/**
	 * 
	 * @param enc GR[h
	 */
	public void setResponseEncoding(String enc) {
		if (res.getCharacterEncoding() == null ||
				!res.getCharacterEncoding().equals(enc)) {
			res.setCharacterEncoding(enc);
		}
	}	

	/**
	 * encoding擾
	 * 
	 * @return GR[h
	 */
	public String getResponseEncoding() {
		return res.getCharacterEncoding();
	}	

	/**
	 * NGXgݒ
	 * 
	 * @param req NGXg
	 */
	public void setRequest(HttpServletRequest req) {
		this.req = req;
		if (ServletFileUpload.isMultipartContent(req)) {
			try {
				isMultiPart = true;
				ServletFileUpload fileUpload = new ServletFileUpload(new DiskFileItemFactory());
				fileUpload.setHeaderEncoding(getRequestEncoding());
				mixedList = fileUpload.parseRequest(req);
			}
			catch (FileUploadException e) {
				isMultiPart = false;
				log.error(e.getMessage(), e);
//				e.printStackTrace();
			}
		}
	}

	/**
	 * X|Xݒ
	 * 
	 * @param res X|X
	 */
	public void setResponse(HttpServletResponse res) {
		this.res = res;
	}

	/**
	 * multipartz
	 * @param key
	 * @return
	 */
	public String getParameter(String key) {
		String val = req.getParameter(key);
		if (!isMultiPart || val != null) {
			return val;
		}

		Iterator iterator = mixedList.iterator();
		while(iterator.hasNext()) {
	        FileItem fItem = (FileItem)iterator.next();
	        String name = fItem.getFieldName();
	        if (name == null || !name.equals(key)) {
	        	continue;
	        }
	        if (fItem.isFormField()) {
	        	try {
	        		return fItem.getString(getRequestEncoding());
	        	}
	        	catch (UnsupportedEncodingException e) {
					log.error(e.getMessage(), e);
//					e.printStackTrace();

	        		return fItem.getString();
	        	}
	        }
		}
		return null;
	}

	/**
	 * multipartz
	 * @param key
	 * @return
	 */
	public byte[] getBytes(String key) {
		if (!isMultiPart) {
			return null;
		}

		Iterator iterator = mixedList.iterator();
		while(iterator.hasNext()) {
	        FileItem fItem = (FileItem)iterator.next();
	        String name = fItem.getFieldName();
	        if (name == null || !name.equals(key)) {
	        	continue;
	        }
	        if ( !fItem.isFormField()) {
	        		return fItem.get();
	        }
		}
		return null;
	}

	/**
	 * multipartz
	 *
	 * @param key
	 * @return
	 */
	public String[] getParameters(String key) {
		String[] vals = req.getParameterValues(key);
		if (!isMultiPart || (vals != null && vals.length > 0)) {
			return vals;
		}
		
    	String[] returnObj = new String[1];

		Iterator iterator = mixedList.iterator();
		while(iterator.hasNext()) {
	        FileItem fItem = (FileItem)iterator.next();
	        String name = fItem.getFieldName();
	        if (name == null || !name.equals(key)) {
	        	continue;
	        }
	        if (fItem.isFormField()) {
	        	try {
	        		returnObj[0] = fItem.getString(getRequestEncoding());
	        	}
	        	catch (UnsupportedEncodingException e) {
					log.error(e.getMessage(), e);
//					e.printStackTrace();

	        		returnObj[0] = fItem.getString();
	        	}
	        	break;
	        }
		}
		return returnObj;
	}
	
	public boolean isMultipart() {
		return isMultiPart;
	}

	public void setIsBinary(boolean isBinary) {
		this.isBinary = isBinary;
	}

	public boolean isBinary() {
		return isBinary;
	}

	public void setContentType(String contentType) {
		res.setContentType(contentType);
	}
	
	public void setMsgLocale(String msgLocale) {
		this.msgLocale = msgLocale;
	}

	public String getMsgLocale() {
		return this.msgLocale;
	}
}
