/**
 * 
 */
package elazyrest.core.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

/**
 * t֘A
 * 
 * @author kaz
 *
 */
public class DateUtil {
	private static final ThreadLocal<DateFormat> rfc822Format = new ThreadLocal<DateFormat>() {
		@Override
		protected DateFormat initialValue() {
			return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
		}
	};
	public static String rfc822(Date date) {
		if (date == null) {
			return null;
		}
		return rfc822Format.get().format(date);
	}

	public static Date rfc822toDate(String date) throws ParseException {
		if (date == null) {
			return null;
		}
		return rfc822Format.get().parse(date);
	}
}