/**
 * 
 */
package elazyrest.core.util;


import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;



/**
 * @author kaz
 *
 */
public class JaxbUtil {
	private static Log log = LogFactory.getLog(JaxbUtil.class);
	private static HashMap<String,JAXBContext> mapJaxb = new HashMap<String,JAXBContext>(); 

	public static String object2Xml(Object obj) {
		return object2Xml(obj, null);
	}

	public static String object2Xml(Object obj, String enc) {
		try {
			if (enc == null) {
				AppContext appContext = AppContext.getContext();
				enc = appContext.getResponseEncoding();
			}

			JAXBContext jc = null;
			synchronized(mapJaxb) {
				if (mapJaxb.containsKey(obj.getClass().getName())) {
					jc = mapJaxb.get(obj.getClass().getName());
				}
			}
			if (jc == null) {
				jc = JAXBContext.newInstance(obj.getClass());
				synchronized(mapJaxb) {
					if (mapJaxb.containsKey(obj.getClass().getName())) {
						jc = mapJaxb.get(obj.getClass().getName());
					} else {
						mapJaxb.put(obj.getClass().getName(), jc);
					}
				}
				log.debug("newInstance. "+obj.getClass().getName());
			} else{
				log.debug("load from map. "+obj.getClass().getName());
			}
	        Marshaller m = jc.createMarshaller();
			m.setProperty(Marshaller.JAXB_ENCODING, enc);
	        m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
			StringWriter writer = new StringWriter();
			//XmlRootElement
			if (obj.getClass().isAnnotationPresent(XmlRootElement.class)) {
				m.marshal(obj, writer);
			}
			//ObjectFactory
			else {
//				m.marshal(new JAXBElement(
//						  new QName(xxx, "xxx"), obj.getClass(), obj), writer);
//				;

				Class cl = Class.forName(obj.getClass().getPackage().getName() +".ObjectFactory");
				Object objectFactory = cl.newInstance();
				
				Class targetClass = obj.getClass();
	
				Method createMethod = null;
				Method[] methods = cl.getMethods();
				String methodName = "";
				for (Method method : methods) {
					if (method.isAnnotationPresent(XmlElementDecl.class)) {
						methodName = method.getName();
						try {
							createMethod = cl.getMethod(methodName, obj.getClass());
							break;
						}
						catch (NoSuchMethodException e) {
							continue;
						}
					}
				}
				JAXBElement el = (JAXBElement)createMethod.invoke(objectFactory, obj);
				
//				JAXBContext jc = JAXBContext.newInstance(obj.getClass().getPackage().getName());
//				Marshaller m = jc.createMarshaller();
		
				m.setProperty(Marshaller.JAXB_ENCODING, enc);
				m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);

				m.marshal(el, writer);
			}
			return writer.toString();
		}
		catch (JAXBException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
		catch (ClassNotFoundException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
		catch (InstantiationException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
		catch (IllegalAccessException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
		catch (SecurityException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
		catch (IllegalArgumentException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
		catch (InvocationTargetException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
	}
	
	public static String object2Html(Object obj, String xslt, String enc) {
		try {
			String xmlStr = object2Xml(obj, enc);
		    
			// set up XSLT transformation
			TransformerFactory tf = TransformerFactory.newInstance();
			Transformer t;
			
			StringReader reader = new StringReader(xmlStr);
			StreamSource xmlSource = new StreamSource(reader);
			Thread currentThread = Thread.currentThread();
			StreamSource xslSource = new StreamSource(currentThread.getContextClassLoader().getResourceAsStream(xslt));
			StringWriter writer = new StringWriter();
			StreamResult sr = new StreamResult(writer);
			t = tf.newTransformer(xslSource);
			// run transformation
			t.transform(xmlSource, sr);

			return writer.toString();
		} catch (TransformerConfigurationException e) {
			//e.printStackTrace();
			log.error(e.getMessage(), e);
			return object2Xml(obj, enc);
		} catch (TransformerException e) {
			//e.printStackTrace();
			log.error(e.getMessage(), e);
			return object2Xml(obj, enc);
		} catch (SecurityException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		} catch (IllegalArgumentException e) {
			log.error(e.getMessage(), e);
			return object2Xml(ResponseGen.generateXML(ResponseGen.INTERNAL_SERVER_ERROR, "T[oG["));
		}
	}

}
