package generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;

import elazyrest.i18n.MessageResourceBundle;
import elazyrest.i18n.ResourceBundleEx;

import elazyrest.core.annotation.RestMethod;
import elazyrest.core.annotation.RestParam;
import elazyrest.core.annotation.SimpleXml;

public class ResourceGen {

	private StringBuffer resourceXML = null;
	private static String lineSep = System.getProperty("line.separator");
	private MessageResourceBundle paramResource;

	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		String packageName = ""; //rename
		String srcRoot = "src/main/resources/";
		
		ResourceGen self = new ResourceGen();
		try {
			self.generate(packageName, srcRoot);
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	public void generate(String packageName, String srcRoot) {
        try {
        	paramResource = new MessageResourceBundle(ResourceBundleEx.getBundle("resources/param_resource"));
        } catch (Exception e) {
        	//e.printStackTrace();
        	paramResource = null;
        }

//		this.packageName = packageName;
//		this.srcRoot = "webapp/WEB-INF/src/main/resources/";

		resourceXML = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" +lineSep);
		resourceXML.append("<RESOURCE>" +lineSep);

		try {
			URL serviceRoot = this.getClass().getClassLoader().getResource(packageName.replace('.', '/'));
			if (serviceRoot != null) {
				File dir = new File(serviceRoot.getPath());
				generate(dir, packageName);
			}
		}
		finally {
			try {
				resourceXML.append("</RESOURCE>");
				File resourceFile = new File(srcRoot +"param_resource.xml");
				if (!resourceFile.exists()) {
					resourceFile.createNewFile();
				}

				PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(resourceFile)));
				pw.write(resourceXML.toString());
				pw.flush();
				pw.close();

			}
			catch (Exception e) {
				//
			}
			
		}
				
	}
	
	private void generate(File file, String parentPackage) {
		String filename = file.getName();
		if (file.isDirectory()) {
			File[] flist = file.listFiles();
			String packname = null; 
			if (file.getName().equals("classes") ||
				(parentPackage != null && parentPackage.endsWith(file.getName()))) {
				packname = parentPackage;
			}
			else {
				packname = parentPackage.length() > 0? parentPackage +"." +file.getName(): file.getName();
			}
			if (flist != null && flist.length > 0) {
				for (File childFile : flist) { 
					generate(childFile, packname);
				}
			}
		}
		if (!file.getName().endsWith(".class")) {
			return;
		}
		String clname = null;
		
		if (parentPackage != null && parentPackage.length() > 0) {
			clname = parentPackage +"." +filename.substring(0, filename.lastIndexOf('.'));
		}
		else {
			clname = filename.substring(0, filename.lastIndexOf('.'));
		}
		this.generateForm(clname.replace('/', '.'));
	}

	private void generateForm(String clName) {
		try {
			Class cl = Class.forName(clName);
			
			String clFileName = cl.getName().substring(cl.getName().lastIndexOf('.') + 1);
			// Is SimpleXml?
			if (!cl.isAnnotationPresent(SimpleXml.class)) {
				return ;
			}
			Method[] methods = cl.getMethods();
			for(Method targetMethod : methods) {

				// Is RestMethod?
				if (!targetMethod.isAnnotationPresent(RestMethod.class)) {
					//log.debug(methodName +" is not RestMethod.");
					continue;
				}
				
				Annotation[][] paramAnnotation = targetMethod.getParameterAnnotations();
				
				// request parameter to rest method parameter
				for (int i = 0; i < paramAnnotation.length; i++) {
					if (i == 0) {
						resourceXML.append(lineSep +"<!-- " +clFileName +"." +targetMethod.getName() +"-->" +lineSep);
					}
					for (int j = 0; j < paramAnnotation[i].length; j++) {
						if (paramAnnotation[i][j].annotationType() == RestParam.class) {
							RestParam restParam = (RestParam)paramAnnotation[i][j];
							String key = restParam.name();
							String keyDescription = key;
							if (paramResource != null) {
								String description = paramResource.getString(clFileName +"." +targetMethod.getName() +"." +key);
								if (description != null && description.length() > 0) {
									keyDescription = description;
								}
							}

							resourceXML.append("<MSG id=\"" +clFileName +"." +targetMethod.getName() +"." +key +"\">" +keyDescription +"</MSG>" +lineSep);
						}
					}
				}
			}
		}
		catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
	}
}
