/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.plugin.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import javax.sip.address.SipURI;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.db.TupleSpaceAdapter;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.plugin.http.HttpHandlerExt;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.log4j.Logger;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

class AjaxHandler
extends AbstractHttpHandler
implements HttpHandlerExt {
    private static final long serialVersionUID = -3390140933419713641L;
    private static Logger logger = Logger.getLogger(AjaxHandler.class);
    public static String VALUE_PARAM = "value";
    public static String TARGET_PARAM = "target";
    public static String AJAX_REQUEST_PATH = "/event/ajax";
    static TupleSpaceAdapter dispatcher = TupleSpaceAdapter.getInstance();
    private Entity source;

    public void handle(String pathInContext, String pathParams, HttpRequest req, HttpResponse res) throws HttpException, IOException {
        if (!"GET".equals(req.getMethod()) && !"POST".equals(req.getMethod())) {
            return;
        }
        logger.info((Object)("Request to : " + pathInContext));
        String res_str = "YES";
        if (pathInContext.equals(AJAX_REQUEST_PATH)) {
            String target = req.getParameter(TARGET_PARAM);
            String value = req.getParameter(VALUE_PARAM);
            if (value != null) {
                logger.info((Object)("Receive value : " + value));
                res_str = this.dispatchEvent(target, value, req);
            } else {
                res_str = this.getResponseData(target, req);
            }
            if (res_str.equals("")) {
                res_str = "<data>NO DATA</data>";
            }
            BufferedOutputStream bos = new BufferedOutputStream(res.getOutputStream());
            res_str = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + res_str;
            byte[] b = res_str.getBytes("UTF-8");
            bos.write(b, 0, b.length);
            bos.flush();
        }
    }

    private String getResponseData(String target, HttpRequest req) {
        int count = 0;
        String res_str = "";
        String temp = req.getParameter("count");
        if (temp != null) {
            count = Integer.valueOf(temp);
        } else {
            res_str = dispatcher.getDataByXML(target);
            res_str.equals("");
        }
        return res_str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String dispatchEvent(String target, String value, HttpRequest req) {
        String longitude;
        String latitude;
        EntityEvent evt = null;
        Location location = null;
        String location_name = req.getParameter("location");
        if (location_name != null && (latitude = req.getParameter("latitude")) != null && (longitude = req.getParameter("longitude")) != null) {
            location = new Location(location_name, latitude, longitude);
            this.source.setLocation(location);
        }
        if (target != null) {
            SipURI target_uri = null;
            target_uri = (SipURI)SipCore.getInstance().createURI(target);
            if (target_uri == null) return "Invalid URI :" + target;
            EntityImpl e = new EntityImpl(target_uri);
            evt = new EntityEvent(value, (EntityListener)e, this.source, EntityEvent.EventType.MESSAGE);
        } else {
            evt = new EntityEvent(value, null, this.source);
            evt.setBroadcast(true);
        }
        if (evt == null) return "<data>YES</data>";
        if (evt.isBroadcast()) {
            logger.info((Object)"Dispatch Event by Broadcast.");
        } else {
            logger.info((Object)("Dispatch Event to " + target));
        }
        dispatcher.dispatchEvent(evt);
        return "<data>YES</data>";
    }

    public void setSourceEntity(Entity source) {
        this.source = source;
    }
}

