/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassLoader
extends ClassLoader {
    private static Hashtable<String, byte[]> bytecodes = new Hashtable();
    private static PluginClassLoader loader = new PluginClassLoader();

    private PluginClassLoader() {
    }

    public static PluginClassLoader getClassLoader() {
        return loader;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name);
        if (cl == null) {
            cl = this.applyDefinition(name, resolve);
        }
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
                return cl;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    private Class applyDefinition(String name, boolean resolve) {
        byte[] buf = bytecodes.get(name);
        if (buf == null) {
            return null;
        }
        Class<?> c = super.defineClass(null, buf, 0, buf.length);
        if (c != null && resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public synchronized void applyDefinitions(List<String> classList) {
        for (String classname : classList) {
            Class<?> c = this.findLoadedClass(classname);
            if (c != null) continue;
            this.applyDefinition(classname, true);
        }
    }

    public static void addJarFile(String jarfile) throws FileNotFoundException, IOException {
        JarEntry je;
        ArrayList<String> classList = new ArrayList<String>();
        JarInputStream jis = new JarInputStream(new BufferedInputStream(new FileInputStream(jarfile)));
        int bufsize = 1024;
        while ((je = jis.getNextJarEntry()) != null) {
            int len;
            String name = je.getName();
            if (name.indexOf(".class") <= 0) continue;
            String classname = name.substring(0, name.length() - 6);
            classname = classname.replace('/', '.');
            byte[] buf = new byte[bufsize];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while (jis.available() > 0 && (len = jis.read(buf, 0, bufsize)) > 0) {
                baos.write(buf, 0, len);
            }
            classList.add(classname);
            bytecodes.put(classname, baos.toByteArray());
        }
    }

    public static void main(String[] args) throws Exception {
        PluginClassLoader loader = PluginClassLoader.getClassLoader();
        Class<?> clz = loader.loadClass("net.sourceforge.jsdp.Uri");
        Object instance = clz.newInstance();
        System.out.println(instance);
    }
}

