/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.db;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.sip.address.URI;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.db.DataObjectImpl;
import jp.ac.naka.ec.db.DatabaseConnector;
import jp.ac.naka.ec.db.EventData;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityListener;
import jp.ac.naka.ec.entity.EntityType;

public class TupleSpaceAdapter
implements EventDispatcher {
    private EventDispatcher dispatcher;
    private static TupleSpaceAdapter tuple = new TupleSpaceAdapter();
    private DatabaseConnector con;
    private Map<String, EventData> map = new HashMap<String, EventData>();

    private TupleSpaceAdapter() {
        this.dispatcher = EntityEventDispatcher.getInstance();
    }

    public void addEntityListener(EntityListener listener) {
        this.dispatcher.addEntityListener(listener);
    }

    public void dispatchEvent(EntityEvent evt) {
        Entity source;
        URI uri;
        if (this.con != null && evt.getSource() instanceof Entity && evt.getEventType() == EntityEvent.EventType.MESSAGE) {
            this.storeData(evt);
        }
        if (evt.getMessage() != null && evt.getSource() instanceof Entity && evt.getEventType() == EntityEvent.EventType.MESSAGE && (uri = (source = (Entity)evt.getSource()).getURI()) != null) {
            String dateString;
            String key = uri.toString();
            EventData temp = new EventData();
            temp.name = source.getName();
            temp.value = evt.getMessage();
            if (evt.getMessage().equals("")) {
                temp.value = evt.getSessionDescription().toString();
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd 'at' hh:mm:ss");
            Date currentTime_1 = new Date();
            temp.date = dateString = formatter.format(currentTime_1);
            if (source.getLocation() != null) {
                temp.location = source.getLocation();
            }
            this.map.put(key, temp);
        }
        this.dispatcher.dispatchEvent(evt);
    }

    public String getDataByXML(String uri) {
        String ret = "";
        StringBuilder builder = new StringBuilder();
        builder.append("<event>");
        if (uri == null) {
            Set<String> set = this.map.keySet();
            for (String key : set) {
                EventData data = this.map.get(key);
                builder.append("<data uri=\"" + key + "\">");
                builder.append("<values>");
                String value = data.location != null ? "<value name=\"" + data.name + "\" time=\"" + data.date + "\" location=\"" + data.location.getName() + "\" latitude=\"" + data.location.getLatitude() + "\" longitude=\"" + data.location.getLongitude() + "\">" + data.value + "</value>" : "<value name=\"" + data.name + "\" time=\"" + data.date + "\">" + data.value + "</value>";
                builder.append(value);
                builder.append("</values>");
                builder.append("</data>");
            }
        } else {
            EventData data = this.map.get(uri);
            if (data != null) {
                builder.append("<data uri=\"" + uri + ">");
                builder.append("<values>");
                String value = data.location != null ? "<value name=\"" + data.name + "\" time=\"" + data.date + "\" location=\"" + data.location.getName() + "\" latitude=\"" + data.location.getLatitude() + "\" longitude=\"" + data.location.getLongitude() + "\">" + data.value + "</value>" : "<value name=\"" + data.name + "\" time=\"" + data.date + "\">" + data.value + "</value>";
                builder.append(value);
                builder.append("</values>");
                builder.append("</data>");
            }
        }
        builder.append("</event>");
        ret = builder.toString();
        return ret;
    }

    public String getDataByXML(String uri, int num) throws SQLException {
        String ret = "";
        if (uri != null) {
            StringBuilder builder = new StringBuilder();
            if (this.con == null) {
                return "";
            }
            builder.append("<event>");
            EventData[] data = this.con.getData(uri, num);
            builder.append("<data uri=\"" + uri + "\">");
            int count = 0;
            if (data.length != 0) {
                builder.append("<values>");
                EventData[] eventDataArray = data;
                int n = 0;
                int n2 = eventDataArray.length;
                while (n < n2) {
                    EventData d = eventDataArray[n];
                    if (d == null) break;
                    String value = "";
                    value = d.location != null ? "<value seq=\"" + count++ + "\" name=\"" + d.name + "\" time=\"" + d.date + "\" location=\"" + d.location.getName() + "\" latitude=\"" + d.location.getLatitude() + "\" longitude=\"" + d.location.getLongitude() + "\">" + d.value + "</value>" : "<value seq=\"" + count++ + "\" name=\"" + d.name + "\" time=\"" + d.date + "\">" + d.value + "</value>";
                    builder.append(value);
                    ++n;
                }
                builder.append("</values>");
            }
            builder.append("</data>");
            builder.append("</event>");
            ret = builder.toString();
        }
        return ret;
    }

    public static TupleSpaceAdapter getInstance() {
        return tuple;
    }

    public void setDatabaseConnector(DatabaseConnector con) {
        this.con = con;
    }

    public void storeData(EntityEvent evt) {
        if (this.con == null) {
            return;
        }
        try {
            Entity source = (Entity)evt.getSource();
            EntityType type = source.getEntityType();
            Entity target = (Entity)evt.getTarget();
            String data = evt.getMessage();
            if (data != null) {
                DataObjectImpl obj = new DataObjectImpl(type, evt.getMessage(), source, target, source.getLocation());
                this.con.store(obj);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String makeXML(String key, String data) {
        return "<" + key + ">" + data + "</" + key + ">";
    }
}

