/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.io.File;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.ac.naka.ec.Location;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityType;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityConfigParser {
    public static Logger logger = Logger.getLogger(EntityConfigParser.class);

    public static Entity[] parse(String config_file) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException e) throws SAXException {
                    logger.error((Object)"Error while parsing ./config/entities.xml", (Throwable)e);
                    System.exit(-1);
                }

                public void fatalError(SAXParseException e) throws SAXException {
                    logger.error((Object)"Error while parsing ./config/entities.xml", (Throwable)e);
                    System.exit(-1);
                }

                public void warning(SAXParseException e) throws SAXException {
                    logger.error((Object)"Error while parsing ./config/entities.xml", (Throwable)e);
                    System.exit(-1);
                }
            });
            Document doc = db.parse(new File(config_file));
            Element root = doc.getDocumentElement();
            NodeList entities = root.getElementsByTagName("entity");
            ArrayList<Object> list = new ArrayList();
            list = EntityConfigParser.parseEntity(entities);
            Entity[] a = new Entity[list.size()];
            return list.toArray(a);
        }
        catch (Exception e) {
            logger.error((Object)"Error while initiating Entity class", (Throwable)e);
            return new Entity[0];
        }
    }

    private static ArrayList<Entity> parseEntity(NodeList entities) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        int i = 0;
        while (i < entities.getLength()) {
            block9: {
                Entity instance;
                Element entity = (Element)entities.item(i);
                String id = entity.getAttribute("id");
                String cls = entity.getAttribute("class");
                Node temp = entity.getElementsByTagName("type").item(0);
                String type = "SENSOR";
                if (temp != null) {
                    type = temp.getFirstChild().getNodeValue();
                }
                try {
                    Class<?> clazz = Class.forName(cls);
                    instance = (Entity)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)("Could not found class :" + cls), (Throwable)e);
                    break block9;
                }
                catch (Exception e) {
                    logger.error((Object)("Error while initiating class :" + cls), (Throwable)e);
                    break block9;
                }
                instance.setName(id);
                instance.setEntityType(EntityType.valueOf(type));
                temp = entity.getElementsByTagName("location").item(0);
                if (temp != null) {
                    String location = ((Element)temp).getAttribute("name");
                    temp = ((Element)temp).getElementsByTagName("latitude").item(0);
                    String lat = "";
                    String lon = "";
                    if (temp != null) {
                        lat = temp.getFirstChild().getNodeValue();
                        temp = temp.getNextSibling();
                        do {
                            if (temp.getNodeType() == 3 || !temp.getNodeName().equals("longitude")) continue;
                            lon = temp.getFirstChild().getNodeValue();
                            break;
                        } while ((temp = temp.getNextSibling()) != null);
                    }
                    if (!lat.equals("") && !lon.equals("")) {
                        instance.setLocation(new Location(location, lat, lon));
                    }
                }
                list.add(instance);
            }
            ++i;
        }
        return list;
    }
}

