/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.entity;

import java.util.List;
import java.util.Vector;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityListener;

public class EntityEventDispatcher
implements EventDispatcher {
    private static EntityEventDispatcher instance = new EntityEventDispatcher();
    private List<EntityListener> listeners = new Vector<EntityListener>();

    private EntityEventDispatcher() {
    }

    public static EntityEventDispatcher getInstance() {
        return instance;
    }

    public synchronized void addEntityListener(EntityListener listener) {
        this.listeners.add(listener);
    }

    public void dispatchEvent(EntityEvent evt) {
        for (EntityListener listener : this.listeners) {
            switch (evt.getEventType()) {
                case MESSAGE: {
                    listener.receiveMessage(evt);
                    break;
                }
                case OFFER: {
                    listener.receiveOffer(evt);
                    break;
                }
                case BYE: {
                    listener.receiveBye(evt);
                    break;
                }
                case ANSWER: {
                    listener.receiveAnswer(evt);
                    break;
                }
                case ADD: {
                    listener.addedNewEntity(evt);
                    break;
                }
                case NOTIFY: {
                    listener.addedNewEntity(evt);
                    break;
                }
                case SUBSCRIBE: {
                    listener.addedNewEntity(evt);
                    break;
                }
                case REGISTER: {
                    listener.addedNewEntity(evt);
                    break;
                }
                case ACK: {
                    listener.receiveAck(evt);
                    break;
                }
                default: {
                    listener.receiveMessage(evt);
                }
            }
        }
    }
}

