/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.MediaException;
import javax.media.PlugInManager;
import javax.media.format.AudioFormat;
import jp.ac.naka.ec.media.AudioReceiver;
import jp.ac.naka.ec.media.AudioTransmitter;
import jp.ac.naka.ec.media.MediaPlayer;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.Origin;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;
import net.sourceforge.jsdp.SessionName;
import net.sourceforge.jsdp.Time;
import net.sourceforge.jsdp.TimeDescription;
import net.sourceforge.jsdp.Version;

public class AudioPlayer
implements MediaPlayer {
    private InetAddress localhost;
    protected static int srcPort = 20023;
    protected int limit = 3;
    private AudioReceiver receiver;
    private AudioTransmitter transmiter;
    protected List<Integer> availableAudioFormats = new ArrayList<Integer>();
    protected int[] receivableJmfAudioFormats;

    public AudioPlayer() throws IOException {
        this("localhost");
    }

    public AudioPlayer(String host) throws IOException {
        this(host, srcPort);
    }

    public AudioPlayer(String host, int port) throws IOException {
        int[] nArray = new int[7];
        nArray[0] = 4;
        nArray[1] = 3;
        nArray[3] = 5;
        nArray[4] = 6;
        nArray[5] = 8;
        nArray[6] = 15;
        this.receivableJmfAudioFormats = nArray;
        this.init(host);
        srcPort = port;
    }

    private void init(String host) throws IOException {
        this.localhost = InetAddress.getByName(host);
        Arrays.sort(this.receivableJmfAudioFormats);
        int[] nArray = this.receivableJmfAudioFormats;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int format = nArray[n];
            this.availableAudioFormats.add(format);
            ++n;
        }
    }

    public Component getVisualComponent() {
        return null;
    }

    private SessionDescription generateBasicSessionDescription(int version, String userName, String sessionName) {
        SessionDescription sdp = null;
        try {
            Version v = new Version(version);
            Date date = new Date();
            long sessionVersion = date.getTime();
            Origin o = new Origin(userName, sessionVersion, this.localhost.getHostAddress());
            o.setSessionVersion(o.getSessionID());
            SessionName s = new SessionName(sessionName);
            TimeDescription t = new TimeDescription(new Time());
            Connection c = new Connection(this.localhost.getHostAddress());
            sdp = new SessionDescription(v, o, s, t);
            sdp.setConnection(c);
            sdp.setSessionName(s);
        }
        catch (SdpException e) {
            System.err.println("An SDP exception occurred while generating local sdp description \n" + e.getMessage());
        }
        return sdp;
    }

    public SessionDescription getRequestSessionDescription(String user_name, String session_name) throws MediaException {
        String sdp_str = this.getRequestSessionDescription(0, user_name, session_name);
        return this.getSessionDescription(sdp_str);
    }

    public String getRequestSessionDescription(int version, String userName, String sessionName) {
        SessionDescription sdp = this.generateBasicSessionDescription(version, userName, sessionName);
        MediaDescription[] md = null;
        String sdp_str = null;
        if (!this.availableAudioFormats.isEmpty()) {
            md = new MediaDescription[1];
            String name = "rtpmap";
            Iterator<Integer> iter = this.availableAudioFormats.iterator();
            int payload = iter.next();
            Media media = new Media("audio", srcPort, "RTP/AVP", String.valueOf(payload));
            String value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
            Attribute attr = new Attribute(name, value);
            md[0] = new MediaDescription(media);
            md[0].addAttribute(attr);
            while (iter.hasNext()) {
                payload = iter.next();
                media.addMediaFormat(String.valueOf(payload));
                value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
                attr = new Attribute(name, value);
                md[0].addAttribute(attr);
                --this.limit;
                if (this.limit == 1) break;
            }
            this.limit = 3;
            sdp_str = sdp.toString();
            if (md != null) {
                MediaDescription[] mediaDescriptionArray = md;
                int n = 0;
                int n2 = mediaDescriptionArray.length;
                while (n < n2) {
                    MediaDescription mediaDescriptor = mediaDescriptionArray[n];
                    sdp_str = String.valueOf(sdp_str) + mediaDescriptor.encode();
                    ++n;
                }
            }
        } else {
            return "";
        }
        return sdp_str;
    }

    public int[] getReceivableFormats(String sdp_str) {
        int[] supports = this.getSupportedFormats(sdp_str);
        Vector codecs = PlugInManager.getPlugInList(null, null, (int)2);
        HashSet<Integer> vec = new HashSet<Integer>();
        int size = 8;
        for (String plugin : codecs) {
            Format[] formats;
            Format[] formatArray = formats = PlugInManager.getSupportedInputFormats((String)plugin, (int)2);
            int n = 0;
            int n2 = formatArray.length;
            while (n < n2) {
                Format format = formatArray[n];
                if (format instanceof AudioFormat) {
                    AudioFormat f = (AudioFormat)format;
                    int i = 0;
                    while (i < supports.length) {
                        AudioFormat target;
                        AudioFormat audio;
                        AudioJmfFormats jmfFormat = this.findCorrespondingJmfFormat(supports[i]);
                        if (jmfFormat != null && (audio = (target = new AudioFormat(jmfFormat.encoding, jmfFormat.sampleRate, size, jmfFormat.channel))).isSameEncoding((Format)f)) {
                            vec.add(supports[i]);
                        }
                        ++i;
                    }
                }
                ++n;
            }
        }
        int[] fmts = new int[vec.size()];
        int fmt = 0;
        int i = 0;
        Iterator iter = vec.iterator();
        while (iter.hasNext()) {
            fmts[i] = fmt;
            fmt = (Integer)iter.next();
            ++i;
        }
        Arrays.sort(fmts);
        return fmts;
    }

    private int[] getSupportedFormats(String sdp_str) {
        MediaDescription[] mediaDescriptions;
        int[] supportedFormats = null;
        String[] temp = null;
        MediaDescription[] mediaDescriptionArray = mediaDescriptions = this.getSessionDescription(sdp_str).getMediaDescriptions();
        int n = 0;
        int n2 = mediaDescriptionArray.length;
        while (n < n2) {
            MediaDescription mediaDescription = mediaDescriptionArray[n];
            Media media = mediaDescription.getMedia();
            if (media.getMediaType().equals("audio")) {
                temp = media.getMediaFormats();
                break;
            }
            ++n;
        }
        supportedFormats = new int[temp.length];
        int i = 0;
        String[] stringArray = temp;
        n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            String str = stringArray[n2];
            supportedFormats[i++] = Integer.parseInt(str);
            ++n2;
        }
        return supportedFormats;
    }

    public SessionDescription getResponseSessionDescription(SessionDescription sdp) {
        int version = 0;
        String name = sdp.getSessionName().toString();
        String userName = sdp.getOrigin().getUser();
        String sdp_str = this.getResponseSessionDescription(sdp.toString(), version, userName, name);
        return this.getSessionDescription(sdp_str);
    }

    protected SessionDescription getSessionDescription(String sdp_str) {
        SessionDescription sdp = SdpMessageParser.getSessionDescription((String)sdp_str);
        return sdp;
    }

    public static String getSessionDescriptionString(String sdp_file) throws FileNotFoundException, IOException {
        FileReader fr = new FileReader(sdp_file);
        BufferedReader br = new BufferedReader(fr);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while ((i = br.read()) != -1) {
            char c = (char)i;
            builder.append(c);
        }
        return builder.toString();
    }

    private String getAttributeValue(int payload) {
        switch (payload) {
            case 0: {
                return "PCMU/8000";
            }
            case 3: {
                return "gsm/8000";
            }
            case 4: {
                return "g723/8000";
            }
            case 5: {
                return "dvi4/8000";
            }
            case 6: {
                return "dvi4/16000";
            }
            case 8: {
                return "PCMA/8000";
            }
            case 15: {
                return "g728/8000";
            }
            case 16: {
                return "dvi4/11025";
            }
            case 17: {
                return "dvi4/22050";
            }
            case 18: {
                return "g729/8000";
            }
        }
        return null;
    }

    private AudioJmfFormats findCorrespondingJmfFormat(int sdpFormat) {
        switch (sdpFormat) {
            case 0: {
                return new AudioJmfFormats("ULAW/rtp", 8000.0);
            }
            case 3: {
                return new AudioJmfFormats("gsm/rtp", 8000.0);
            }
            case 4: {
                return new AudioJmfFormats("g723/rtp", 8000.0);
            }
            case 5: {
                return new AudioJmfFormats("dvi/rtp", 8000.0);
            }
            case 6: {
                return new AudioJmfFormats("dvi/rtp", 16000.0);
            }
            case 8: {
                return new AudioJmfFormats("alaw", 8000.0);
            }
            case 15: {
                return new AudioJmfFormats("g728/rtp", 8000.0);
            }
            case 16: {
                return new AudioJmfFormats("dvi/rtp", 11025.0);
            }
            case 17: {
                return new AudioJmfFormats("dvi/rtp", 22050.0);
            }
            case 18: {
                return new AudioJmfFormats("g729/rtp", 8000.0);
            }
        }
        return null;
    }

    AudioFormat findCorrespondingAudioFormat(int sdpFormat) {
        switch (sdpFormat) {
            case 0: {
                return new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
            }
            case 3: {
                return new AudioFormat("gsm/rtp", 8000.0, 8, 1);
            }
            case 4: {
                return new AudioFormat("g723/rtp", 8000.0, 8, 1);
            }
            case 5: {
                return new AudioFormat("dvi/rtp", 8000.0, 8, 1);
            }
            case 6: {
                return new AudioFormat("dvi/rtp", 16000.0, 8, 1);
            }
            case 8: {
                return new AudioFormat("alaw", 8000.0, 8, 1);
            }
            case 15: {
                return new AudioFormat("g728/rtp", 8000.0, 8, 1);
            }
            case 16: {
                return new AudioFormat("dvi/rtp", 11025.0, 8, 1);
            }
            case 17: {
                return new AudioFormat("dvi/rtp", 22050.0, 8, 1);
            }
            case 18: {
                return new AudioFormat("g729/rtp", 8000.0, 8, 1);
            }
        }
        return null;
    }

    public void addAvailableFormat(int payload) {
        this.availableAudioFormats.add(payload);
    }

    public String getResponseSessionDescription(String sdp_string, int version, String userName, String sessionName) {
        int[] supports = this.getReceivableFormats(sdp_string);
        int payload = supports[0];
        String name = "rtpmap";
        MediaDescription[] md = new MediaDescription[1];
        SessionDescription sdp = this.generateBasicSessionDescription(version, userName, sessionName);
        Media media = new Media("audio", srcPort, "RTP/AVP", String.valueOf(payload));
        String value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
        Attribute attr = new Attribute(name, value);
        md[0] = new MediaDescription(media);
        md[0].addAttribute(attr);
        int i = 1;
        while (i < supports.length) {
            payload = supports[i];
            String attr_str = this.getAttributeValue(payload);
            if (attr_str != null) {
                media.addMediaFormat(String.valueOf(payload));
                value = String.valueOf(payload) + " " + attr_str;
                attr = new Attribute(name, value);
                md[0].addAttribute(attr);
            }
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(sdp.toString());
        builder.append(md[0].encode());
        return builder.toString();
    }

    public boolean isAvailable(String sdp_string) {
        int[] formats = this.getReceivableFormats(sdp_string);
        return formats != null || formats.length != 0;
    }

    public void receiveMediaStream(String sdp_string) throws MediaException {
        if (this.receiver == null) {
            this.receiver = new AudioReceiver();
        }
        SessionDescription sdp = SdpMessageParser.getSessionDescription((String)sdp_string);
        int[] formats = this.getReceivableFormats(sdp_string);
        if (formats.length <= 0) {
            throw new MediaException("Invalid MediaFormats: " + sdp.getMediaDescriptions().toString());
        }
        this.receiver.receiveMedia(sdp);
    }

    public void sendMediaStream(String path, int port) throws MediaException {
        if (this.transmiter == null) {
            this.transmiter = new AudioTransmitter(path, port);
        }
    }

    public void sendMediaStream(String sdp_string) throws MediaException, IOException {
        MediaDescription[] mls;
        int[] formats = this.getReceivableFormats(sdp_string);
        AudioJmfFormats f = this.findCorrespondingJmfFormat(formats[0]);
        AudioFormat format = new AudioFormat(f.encoding, f.sampleRate, AudioTransmitter.rtp_bit, f.channel);
        SessionDescription sdp = SdpMessageParser.getSessionDescription((String)sdp_string);
        Connection c = sdp.getConnection();
        String url = c.getAddress();
        int port = 0;
        MediaDescription[] mediaDescriptionArray = mls = sdp.getMediaDescriptions();
        int n = 0;
        int n2 = mediaDescriptionArray.length;
        while (n < n2) {
            MediaDescription md = mediaDescriptionArray[n];
            Media media = md.getMedia();
            if (media.getMediaType().equals("audio")) {
                port = media.getPort();
            }
            ++n;
        }
        if (this.transmiter == null) {
            this.transmiter = new AudioTransmitter(url, port, format);
        }
        this.transmiter.play();
    }

    public void sendMediaStream(String path, int port, String media) throws MediaException {
        if (this.transmiter == null) {
            this.transmiter = new AudioTransmitter(media, path, port);
        }
    }

    public void stopReceivingMediaStream() {
        this.receiver.stop();
    }

    public void stopSendingMediaStream() {
        this.transmiter.close();
    }

    public boolean isPlaying() {
        return this.receiver.isPlaying();
    }

    public Component getTransmitterController() {
        return this.transmiter.getControlPanelComponent();
    }

    public Component getReceiverController() {
        return this.receiver.getControlPanelComponent();
    }

    public boolean isSending() {
        return this.transmiter.isPlaying();
    }

    public static void main(String[] args) {
        AudioPlayer receiver = null;
        try {
            receiver = new AudioPlayer();
        }
        catch (IOException e1) {
            return;
        }
        String sdp_string = "";
        try {
            FileReader fr = new FileReader("03.sdp");
            BufferedReader br = new BufferedReader(fr);
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while ((i = br.read()) != -1) {
                char c = (char)i;
                builder.append(c);
            }
            sdp_string = builder.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Frame frame = new Frame("test");
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class AudioJmfFormats {
        String encoding;
        double sampleRate;
        int channel = 1;

        private AudioJmfFormats(String encoding, double sampleRate) {
            this.encoding = encoding;
            this.sampleRate = sampleRate;
        }

        private AudioJmfFormats(String encoding, double sampleRate, int channel) {
            this.encoding = encoding;
            this.sampleRate = sampleRate;
            this.channel = 1;
        }
    }
}

