/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.Origin;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;
import net.sourceforge.jsdp.SessionName;
import net.sourceforge.jsdp.Time;
import net.sourceforge.jsdp.TimeDescription;
import net.sourceforge.jsdp.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SDPGenerator {
    protected static int limit = 3;

    SDPGenerator() {
    }

    public static SessionDescription getRequestSessionDescription(int version, String userName, String sessionName, InetAddress host, List<Integer> availableAudioFormats, int audioPort, List<Integer> availableVideoFormats, int videoPort) {
        Attribute attr;
        String value;
        Media media;
        int payload;
        Iterator<Integer> iter;
        String name;
        SessionDescription sdp = SDPGenerator.generateBasicSessionDescription(version, userName, sessionName, host);
        MediaDescription[] md = null;
        int cnt = 0;
        md = availableAudioFormats != null && availableVideoFormats != null ? new MediaDescription[2] : new MediaDescription[1];
        if (availableAudioFormats != null) {
            name = "rtpmap";
            iter = availableAudioFormats.iterator();
            payload = iter.next();
            media = new Media("audio", audioPort, "RTP/AVP", String.valueOf(payload));
            value = String.valueOf(payload) + " " + SDPGenerator.getAttributeValue(payload);
            attr = new Attribute(name, value);
            md[0] = new MediaDescription(media);
            md[0].addAttribute(attr);
            while (iter.hasNext()) {
                payload = iter.next();
                media.addMediaFormat(String.valueOf(payload));
                value = String.valueOf(payload) + " " + SDPGenerator.getAttributeValue(payload);
                attr = new Attribute(name, value);
                md[0].addAttribute(attr);
                if (--limit == 1) break;
            }
            limit = 3;
            ++cnt;
        }
        if (availableVideoFormats != null) {
            name = "rtpmap";
            iter = availableVideoFormats.iterator();
            payload = iter.next();
            media = new Media("video", videoPort, "RTP/AVP", String.valueOf(payload));
            value = String.valueOf(payload) + " " + SDPGenerator.getAttributeValue(payload);
            attr = new Attribute(name, value);
            md[cnt] = new MediaDescription(media);
            md[cnt].addAttribute(attr);
            while (iter.hasNext()) {
                payload = iter.next();
                media.addMediaFormat(String.valueOf(payload));
                value = String.valueOf(payload) + " " + SDPGenerator.getAttributeValue(payload);
                attr = new Attribute(name, value);
                md[cnt].addAttribute(attr);
                if (--limit == 1) break;
            }
        }
        String sdp_str = sdp.toString();
        if (md != null) {
            MediaDescription[] mediaDescriptionArray = md;
            int n = 0;
            int n2 = mediaDescriptionArray.length;
            while (n < n2) {
                MediaDescription mediaDescriptor = mediaDescriptionArray[n];
                sdp_str = String.valueOf(sdp_str) + mediaDescriptor.encode();
                ++n;
            }
        }
        sdp = SdpMessageParser.getSessionDescription((String)sdp_str);
        return sdp;
    }

    public static SessionDescription generateBasicSessionDescription(int version, String userName, String sessionName, InetAddress host) {
        SessionDescription sdp = null;
        try {
            Version v = new Version(version);
            Date date = new Date();
            long sessionVersion = date.getTime();
            Origin o = new Origin(userName, sessionVersion, host.getHostAddress());
            o.setSessionVersion(o.getSessionID());
            SessionName s = new SessionName(sessionName);
            TimeDescription t = new TimeDescription(new Time());
            Connection c = new Connection(host.getHostAddress());
            sdp = new SessionDescription(v, o, s, t);
            sdp.setConnection(c);
            sdp.setSessionName(s);
        }
        catch (SdpException e) {
            System.err.println("An SDP exception occurred while generating local sdp description \n" + e.getMessage());
        }
        return sdp;
    }

    private static String getAttributeValue(int payload) {
        switch (payload) {
            case 0: {
                return "PCMU/8000";
            }
            case 3: {
                return "gsm/8000";
            }
            case 4: {
                return "g723/8000";
            }
            case 5: {
                return "dvi4/8000";
            }
            case 6: {
                return "dvi4/16000";
            }
            case 8: {
                return "PCMA/8000";
            }
            case 15: {
                return "g728/8000";
            }
            case 16: {
                return "dvi4/11025";
            }
            case 17: {
                return "dvi4/22050";
            }
            case 18: {
                return "g729/8000";
            }
            case 31: {
                return "H261/90000";
            }
            case 34: {
                return "H263/90000";
            }
            case 32: {
                return "MPV/90000";
            }
            case 26: {
                return "JPEG/90000";
            }
        }
        return null;
    }

    static Format findCorrespondingFormat(int sdpFormat) {
        String format = null;
        switch (sdpFormat) {
            case 0: {
                return new AudioFormat("ULAW/rtp", 8000.0, 8, 1);
            }
            case 3: {
                return new AudioFormat("gsm/rtp", 8000.0, 8, 1);
            }
            case 4: {
                return new AudioFormat("g723/rtp", 8000.0, 8, 1);
            }
            case 5: {
                return new AudioFormat("dvi/rtp", 8000.0, 8, 1);
            }
            case 6: {
                return new AudioFormat("dvi/rtp", 16000.0, 8, 1);
            }
            case 8: {
                return new AudioFormat("alaw", 8000.0, 8, 1);
            }
            case 15: {
                return new AudioFormat("g728/rtp", 8000.0, 8, 1);
            }
            case 16: {
                return new AudioFormat("dvi/rtp", 11025.0, 8, 1);
            }
            case 17: {
                return new AudioFormat("dvi/rtp", 22050.0, 8, 1);
            }
            case 18: {
                return new AudioFormat("g729/rtp", 8000.0, 8, 1);
            }
            case 34: {
                format = "h263/rtp";
                break;
            }
            case 26: {
                format = "jpeg/rtp";
                break;
            }
            case 31: {
                format = "h261/rtp";
                break;
            }
            case 32: {
                format = "mpeg/rtp";
                break;
            }
            default: {
                return null;
            }
        }
        return new VideoFormat(format);
    }

    public static int[] getReceivableFormats(String[] supports) {
        Vector codecs = PlugInManager.getPlugInList(null, null, (int)2);
        HashSet<Integer> vec = new HashSet<Integer>();
        for (String plugin : codecs) {
            Format[] formats;
            Format[] formatArray = formats = PlugInManager.getSupportedInputFormats((String)plugin, (int)2);
            int n = 0;
            int n2 = formatArray.length;
            while (n < n2) {
                Format target;
                int i;
                AudioFormat f;
                Format format = formatArray[n];
                if (format instanceof AudioFormat) {
                    f = (AudioFormat)format;
                    i = 0;
                    while (i < supports.length) {
                        target = SDPGenerator.findCorrespondingFormat(Integer.parseInt(supports[i]));
                        if (target != null && target.isSameEncoding((Format)f)) {
                            vec.add(Integer.parseInt(supports[i]));
                        }
                        ++i;
                    }
                } else if (format instanceof VideoFormat) {
                    f = (VideoFormat)format;
                    i = 0;
                    while (i < supports.length) {
                        target = SDPGenerator.findCorrespondingFormat(Integer.parseInt(supports[i]));
                        if (target != null && target.isSameEncoding((Format)f)) {
                            vec.add(Integer.parseInt(supports[i]));
                        }
                        ++i;
                    }
                }
                ++n;
            }
        }
        int[] fmts = new int[vec.size()];
        int fmt = 0;
        int i = 0;
        Iterator iter = vec.iterator();
        while (iter.hasNext()) {
            fmts[i] = fmt = ((Integer)iter.next()).intValue();
            ++i;
        }
        Arrays.sort(fmts);
        return fmts;
    }

    private static MediaDescription[] getSupportedMedia(SessionDescription sdp) {
        int[] audio = null;
        int[] video = null;
        MediaDescription[] mediaDescriptions = sdp.getMediaDescriptions();
        int audio_port = 0;
        int video_port = 0;
        MediaDescription[] mediaDescriptionArray = mediaDescriptions;
        int n = 0;
        int n2 = mediaDescriptionArray.length;
        while (n < n2) {
            MediaDescription mediaDescription = mediaDescriptionArray[n];
            Media media = mediaDescription.getMedia();
            if (media.getMediaType().equals("audio")) {
                audio = SDPGenerator.getReceivableFormats(media.getMediaFormats());
                audio_port = media.getPort();
            } else if (media.getMediaType().equals("video")) {
                video = SDPGenerator.getReceivableFormats(media.getMediaFormats());
                video_port = media.getPort();
            }
            ++n;
        }
        MediaDescription[] ret = null;
        int cnt = 0;
        if (audio != null && video != null) {
            ret = new MediaDescription[2];
            cnt = 2;
        } else {
            ret = new MediaDescription[1];
            cnt = 1;
        }
        int i = 0;
        while (i < cnt) {
            int port = 0;
            String m = "audio";
            int[] target = audio;
            if (audio != null && i == 0) {
                port = audio_port;
            } else if (video != null) {
                port = video_port;
                m = "video";
                target = video;
            }
            int payload = target[0];
            String name = "rtpmap";
            Media media = new Media(m, port, "RTP/AVP", String.valueOf(payload));
            String value = String.valueOf(payload) + " " + SDPGenerator.getAttributeValue(payload);
            Attribute attr = new Attribute(name, value);
            MediaDescription md = new MediaDescription(media);
            md.addAttribute(attr);
            int j = 1;
            while (j < target.length) {
                payload = target[j];
                media.addMediaFormat(String.valueOf(payload));
                value = String.valueOf(payload) + " " + SDPGenerator.getAttributeValue(payload);
                attr = new Attribute(name, value);
                md.addAttribute(attr);
                ++j;
            }
            ret[i] = md;
            ++i;
        }
        return ret;
    }

    public static SessionDescription getResponseSessionDescription(SessionDescription sdp) {
        InetAddress addr;
        try {
            addr = InetAddress.getByName(sdp.getConnection().getAddress());
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return null;
        }
        String usr = sdp.getOrigin().getUser();
        String session = sdp.getSessionName().getValue();
        SessionDescription ret = SDPGenerator.generateBasicSessionDescription(0, usr, session, addr);
        MediaDescription[] md = SDPGenerator.getSupportedMedia(sdp);
        String sdp_str = ret.toString();
        if (md != null) {
            MediaDescription[] mediaDescriptionArray = md;
            int n = 0;
            int n2 = mediaDescriptionArray.length;
            while (n < n2) {
                MediaDescription mediaDescriptor = mediaDescriptionArray[n];
                sdp_str = String.valueOf(sdp_str) + mediaDescriptor.encode();
                ++n;
            }
        }
        ret = SdpMessageParser.getSessionDescription((String)sdp_str);
        return ret;
    }
}

