/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.media;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.Format;
import javax.media.MediaException;
import javax.media.PlugInManager;
import javax.media.format.VideoFormat;
import jp.ac.naka.ec.media.AudioPlayer;
import jp.ac.naka.ec.media.MediaReceiver;
import jp.ac.naka.ec.media.MediaTransmitter;
import jp.ac.naka.ec.media.SessionInformation;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;

public class VideoPlayer
extends AudioPlayer {
    protected int[] receivableJmfVideoFormats = new int[]{34, 26, 31};
    private static int video_srcPort = 44444;
    private MediaReceiver receiver;
    MediaTransmitter transmitter;
    protected List<Integer> availableVideoFormats = new ArrayList<Integer>();

    public VideoPlayer() throws IOException {
        this("localhost");
    }

    public VideoPlayer(String host) throws IOException {
        this(host, video_srcPort);
    }

    public VideoPlayer(String host, int port) throws IOException {
        super(host);
        video_srcPort = port;
        this.init();
    }

    private void init() {
        Arrays.sort(this.receivableJmfVideoFormats);
        int[] nArray = this.receivableJmfVideoFormats;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int format = nArray[n];
            this.availableVideoFormats.add(format);
            ++n;
        }
    }

    public void addAvailableFormat(int payload) {
        this.availableVideoFormats.add(payload);
    }

    public int[] getReceivableFormats(String sdp_str) {
        return this.getReceivableFormats(sdp_str, false);
    }

    private int[] getReceivableFormats(String sdp_str, boolean only_video) {
        Iterator iter;
        int[] audio_formats = super.getReceivableFormats(sdp_str);
        int[] supports = this.getSupportedFormats(sdp_str);
        Vector codecs = PlugInManager.getPlugInList(null, null, (int)2);
        HashSet<Integer> vec = new HashSet<Integer>();
        for (String plugin : codecs) {
            Format[] formats;
            Format[] formatArray = formats = PlugInManager.getSupportedInputFormats((String)plugin, (int)2);
            int n = 0;
            int n2 = formatArray.length;
            while (n < n2) {
                Format format = formatArray[n];
                if (format instanceof VideoFormat) {
                    VideoFormat f = (VideoFormat)format;
                    int i = 0;
                    while (i < supports.length) {
                        VideoFormat target = this.findCorrespondingVideoFormat(supports[i]);
                        if (target != null && target.isSameEncoding((Format)f)) {
                            vec.add(supports[i]);
                        }
                        ++i;
                    }
                }
                ++n;
            }
        }
        int[] video_formats = null;
        int i = 0;
        if (!only_video) {
            video_formats = new int[audio_formats.length + vec.size()];
            i = 0;
            while (i < audio_formats.length) {
                video_formats[i] = audio_formats[i];
                ++i;
            }
            iter = vec.iterator();
            while (iter.hasNext()) {
                int next;
                video_formats[i] = next = ((Integer)iter.next()).intValue();
                ++i;
            }
        } else {
            video_formats = new int[vec.size()];
            iter = vec.iterator();
            while (iter.hasNext()) {
                int next = (Integer)iter.next();
                video_formats[i++] = next;
            }
        }
        Arrays.sort(video_formats);
        return video_formats;
    }

    private int[] getSupportedFormats(String sdp_str) {
        MediaDescription[] mediaDescriptions;
        int[] supportedFormats = null;
        String[] temp = null;
        MediaDescription[] mediaDescriptionArray = mediaDescriptions = SdpMessageParser.getSessionDescription((String)sdp_str).getMediaDescriptions();
        int n = 0;
        int n2 = mediaDescriptionArray.length;
        while (n < n2) {
            MediaDescription mediaDescription = mediaDescriptionArray[n];
            Media media = mediaDescription.getMedia();
            if (media.getMediaType().equals("video")) {
                temp = media.getMediaFormats();
                break;
            }
            ++n;
        }
        supportedFormats = new int[temp.length];
        int i = 0;
        String[] stringArray = temp;
        n2 = 0;
        int n3 = stringArray.length;
        while (n2 < n3) {
            String str = stringArray[n2];
            supportedFormats[i++] = Integer.parseInt(str);
            ++n2;
        }
        return supportedFormats;
    }

    protected VideoFormat findCorrespondingVideoFormat(int sdpFormat) {
        String format = null;
        switch (sdpFormat) {
            case 34: {
                format = "h263/rtp";
                break;
            }
            case 26: {
                format = "jpeg/rtp";
                break;
            }
            case 31: {
                format = "h261/rtp";
                break;
            }
            case 32: {
                format = "mpeg/rtp";
                break;
            }
            default: {
                return null;
            }
        }
        return new VideoFormat(format);
    }

    public Component getTransmitterController() {
        if (this.transmitter == null) {
            return null;
        }
        return this.transmitter.getControlPanelComponent();
    }

    public Component getReceiverController() {
        if (this.receiver == null) {
            return null;
        }
        return this.receiver.getControlPanelComponent();
    }

    public Component getVisualComponent() {
        if (this.receiver == null) {
            return null;
        }
        return this.receiver.getVisualComponent();
    }

    public String getRequestSessionDescription(int version, String userName, String sessionName) {
        String sdp_str = super.getRequestSessionDescription(version, userName, sessionName);
        if (!this.availableVideoFormats.isEmpty()) {
            MediaDescription[] md = new MediaDescription[1];
            String name = "rtpmap";
            Iterator<Integer> iter = this.availableVideoFormats.iterator();
            int payload = iter.next();
            Media media = new Media("video", video_srcPort, "RTP/AVP", String.valueOf(payload));
            String value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
            Attribute attr = new Attribute(name, value);
            md[0] = new MediaDescription(media);
            md[0].addAttribute(attr);
            while (iter.hasNext()) {
                payload = iter.next();
                media.addMediaFormat(String.valueOf(payload));
                value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
                attr = new Attribute(name, value);
                md[0].addAttribute(attr);
                --this.limit;
                if (this.limit == 1) break;
            }
            this.limit = 3;
            if (md != null) {
                MediaDescription[] mediaDescriptionArray = md;
                int n = 0;
                int n2 = mediaDescriptionArray.length;
                while (n < n2) {
                    MediaDescription mediaDescriptor = mediaDescriptionArray[n];
                    sdp_str = String.valueOf(sdp_str) + mediaDescriptor.encode();
                    ++n;
                }
            }
        }
        return sdp_str;
    }

    private String getAttributeValue(int payload) {
        switch (payload) {
            case 31: {
                return "H261/90000";
            }
            case 34: {
                return "H263/90000";
            }
            case 32: {
                return "MPV/90000";
            }
            case 26: {
                return "JPEG/90000";
            }
        }
        return null;
    }

    public String getResponseSessionDescription(String sdp_string, int version, String userName, String sessionName) {
        String sdp = super.getResponseSessionDescription(sdp_string, version, userName, sessionName);
        int[] supports = this.getReceivableFormats(sdp_string, true);
        int payload = supports[0];
        String name = "rtpmap";
        MediaDescription[] md = new MediaDescription[1];
        Media media = new Media("video", video_srcPort, "RTP/AVP", String.valueOf(payload));
        String value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
        Attribute attr = new Attribute(name, value);
        md[0] = new MediaDescription(media);
        md[0].addAttribute(attr);
        int i = 1;
        while (i < supports.length) {
            payload = supports[i];
            media.addMediaFormat(String.valueOf(payload));
            value = String.valueOf(payload) + " " + this.getAttributeValue(payload);
            attr = new Attribute(name, value);
            md[0].addAttribute(attr);
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(sdp);
        builder.append(md[0].encode());
        return builder.toString();
    }

    public boolean isAvailable(String sdp_string) {
        boolean a = super.isAvailable(sdp_string);
        int[] formats = this.getReceivableFormats(sdp_string, true);
        boolean v = formats != null && formats.length != 0;
        return a & v;
    }

    public boolean isPlaying() {
        if (this.receiver == null) {
            return false;
        }
        return this.receiver.isPlaying();
    }

    public boolean isSending() {
        if (this.transmitter == null) {
            return false;
        }
        return this.transmitter.isPlaying();
    }

    public void receiveMediaStream(String sdp_string) throws MediaException {
        SessionDescription sdp = SdpMessageParser.getSessionDescription((String)sdp_string);
        try {
            if (this.receiver == null) {
                this.receiver = new MediaReceiver(sdp);
            } else {
                this.receiver.setNewSessionDescription(sdp);
            }
        }
        catch (IOException e) {
            throw new MediaException(e.getMessage());
        }
        this.receiver.play();
    }

    public void sendMediaStream(String sdp_string) throws MediaException, IOException {
        SessionDescription sdp = SdpMessageParser.getSessionDescription((String)sdp_string);
        Connection c = sdp.getConnection();
        InetAddress addr = InetAddress.getByName(c.getAddress());
        MediaDescription[] mds = sdp.getMediaDescriptions();
        SessionInformation[] info = new SessionInformation[mds.length];
        int i = 0;
        MediaDescription[] mediaDescriptionArray = mds;
        int n = 0;
        int n2 = mediaDescriptionArray.length;
        while (n < n2) {
            MediaDescription md = mediaDescriptionArray[n];
            Media media = md.getMedia();
            String[] formats = media.getMediaFormats();
            int payload = Integer.parseInt(formats[0]);
            int port = media.getPort();
            info[i] = new SessionInformation(addr.getHostAddress(), port);
            VideoFormat format = this.findCorrespondingVideoFormat(payload);
            if (format == null) {
                format = this.findCorrespondingAudioFormat(payload);
            }
            info[i].format = format;
            ++i;
            ++n;
        }
        if (this.transmitter != null) {
            this.transmitter.setNewSessionDescription(sdp);
        }
        this.transmitter.play();
    }

    public void stopReceivingMediaStream() {
        if (this.receiver == null) {
            throw new NullPointerException("Receiver is null.");
        }
        this.receiver.stop();
        this.receiver.close();
    }

    public void stopSendingMediaStream() {
        if (this.transmitter == null) {
            return;
        }
        this.transmitter.close();
    }

    public static void main(String[] args) {
        try {
            VideoPlayer vp = new VideoPlayer();
            SessionDescription sdp = vp.getRequestSessionDescription("name", "-");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class VideoJmfFormats {
        String encoding;
        float frameRate;
        Dimension dim;
        int maxDataLength;
        Class type;

        private VideoJmfFormats(String encoding, Dimension size, int maxDataLength, Class dataType, float frameRate) {
            this.encoding = encoding;
            this.dim = size;
            this.maxDataLength = maxDataLength;
            this.type = dataType;
            this.frameRate = frameRate;
        }

        private VideoJmfFormats(String encoding) {
            this.encoding = encoding;
        }
    }
}

