/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.naka.ec.sip;

import javax.sip.RequestEvent;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.FromHeader;
import javax.sip.header.ToHeader;
import javax.sip.message.Request;
import jp.ac.naka.ec.EventDispatcher;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.sip.MethodDelegate;
import jp.ac.naka.ec.sip.SipCore;
import org.apache.log4j.Logger;

class ByeDelegate
extends MethodDelegate {
    private static Logger logger = Logger.getLogger(ByeDelegate.class);
    private static EventDispatcher dispatcher;
    private SipCore core = SipCore.getInstance();

    public ByeDelegate() {
        dispatcher = EntityEventDispatcher.getInstance();
    }

    public boolean forward(RequestEvent evt) {
        Request req = evt.getRequest();
        FromHeader from = (FromHeader)req.getHeader("From");
        Address addr = from.getAddress();
        try {
            ToHeader to = (ToHeader)req.getHeader("To");
            SipURI targetURI = (SipURI)to.getAddress().getURI();
            EntityImpl target = new EntityImpl(targetURI);
            SipURI sourceURI = (SipURI)from.getAddress().getURI();
            EntityImpl source = new EntityImpl(sourceURI);
            this.core.sendResponse(200, req);
            EntityEvent ee = new EntityEvent(target, source, EntityEvent.EventType.BYE);
            dispatcher.dispatchEvent(ee);
        }
        catch (Exception e) {
            logger.warn((Object)"Error while processing SDP.", (Throwable)e);
            try {
                this.core.sendResponse(500, evt, addr.getURI().toString());
            }
            catch (Exception e1) {
                logger.warn((Object)"Cannot send a error Response.", (Throwable)e);
            }
            return false;
        }
        return true;
    }
}

