/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.util.regex.Pattern;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.SdpException;

public class Attribute
implements Field {
    private static final long serialVersionUID = -6003475409338057035L;
    protected String name;
    protected String value;

    private Attribute() {
    }

    public Attribute(String name) throws SdpException {
        this.setName(name);
        this.value = null;
    }

    public Attribute(String name, String value) throws SdpException {
        this.setName(name);
        this.setValue(value);
    }

    public Object clone() {
        Attribute field = new Attribute();
        field.name = new String(this.name);
        field.value = this.value != null ? new String(this.value) : null;
        return field;
    }

    public String encode() {
        return this.toString() + "\r\n";
    }

    public char getFieldType() {
        return 'a';
    }

    public String getFieldValue() {
        StringBuffer result = new StringBuffer(this.name);
        if (this.value != null) {
            result.append(":" + this.value);
        }
        return result.toString();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws SdpException {
        if (!Pattern.matches("(\\w)+(-\\w+)*", name)) {
            throw new SdpException("Invalid attribute name: " + name);
        }
        this.name = name;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws SdpException {
        if (!Pattern.matches("[^\u0000\\r\\n]+", value)) {
            throw new SdpException("Invalid attribute value");
        }
        this.value = value;
    }

    public String toString() {
        return "a=" + this.getFieldValue();
    }
}

