/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Vector;
import net.sourceforge.jsdp.Attribute;
import net.sourceforge.jsdp.Bandwith;
import net.sourceforge.jsdp.Connection;
import net.sourceforge.jsdp.Description;
import net.sourceforge.jsdp.Email;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.Information;
import net.sourceforge.jsdp.Key;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.MediaDescription;
import net.sourceforge.jsdp.Origin;
import net.sourceforge.jsdp.Phone;
import net.sourceforge.jsdp.RepeatTime;
import net.sourceforge.jsdp.SdpElement;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.SessionDescription;
import net.sourceforge.jsdp.SessionName;
import net.sourceforge.jsdp.Time;
import net.sourceforge.jsdp.TimeDescription;
import net.sourceforge.jsdp.TimeZone;
import net.sourceforge.jsdp.Uri;
import net.sourceforge.jsdp.Version;
import net.sourceforge.jsdp.parser.ParserFactory;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.SdpSyntax;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;

public class SdpMessageParser {
    private static Hashtable parsers = new Hashtable(3, 1.0f);
    private Vector queque = new Vector();
    private ListIterator syntaxs;
    private Vector constructorArgs;
    private Vector methods;
    private Vector elements;
    private Class classInfo;

    private SdpMessageParser(Class type) {
        if (type == TimeDescription.class) {
            this.queque.add(new SdpSyntax(Time.class, 2));
            this.queque.add(new SdpSyntax(RepeatTime.class, 3));
            this.classInfo = TimeDescription.class;
        } else if (type == MediaDescription.class) {
            this.queque.add(new SdpSyntax(Media.class, 2));
            this.queque.add(new SdpSyntax(Information.class, 1));
            this.queque.add(new SdpSyntax(Connection.class, 1));
            this.queque.add(new SdpSyntax(Bandwith.class, 3));
            this.queque.add(new SdpSyntax(Key.class, 1));
            this.queque.add(new SdpSyntax(Attribute.class, 3));
            this.classInfo = MediaDescription.class;
        } else if (type == SessionDescription.class) {
            this.queque.add(new SdpSyntax(Version.class, 2));
            this.queque.add(new SdpSyntax(Origin.class, 2));
            this.queque.add(new SdpSyntax(SessionName.class, 2));
            this.queque.add(new SdpSyntax(Information.class, 1));
            this.queque.add(new SdpSyntax(Uri.class, 1));
            this.queque.add(new SdpSyntax(Email.class, 3));
            this.queque.add(new SdpSyntax(Phone.class, 3));
            this.queque.add(new SdpSyntax(Connection.class, 1));
            this.queque.add(new SdpSyntax(Bandwith.class, 3));
            this.queque.add(new SdpSyntax(TimeDescription.class, 4));
            this.queque.add(new SdpSyntax(TimeZone.class, 1));
            this.queque.add(new SdpSyntax(Key.class, 1));
            this.queque.add(new SdpSyntax(Attribute.class, 3));
            this.queque.add(new SdpSyntax(MediaDescription.class, 3));
            this.classInfo = SessionDescription.class;
        }
        this.constructorArgs = new Vector();
        this.methods = new Vector();
        this.elements = new Vector();
    }

    public static TimeDescription getTimeDescription(String message) throws UnexpectedFieldException, SdpException {
        return (TimeDescription)SdpMessageParser.getInstance(TimeDescription.class).getDescription(message);
    }

    public static MediaDescription getMediaDescription(String message) throws UnexpectedFieldException, SdpException {
        return (MediaDescription)SdpMessageParser.getInstance(MediaDescription.class).getDescription(message);
    }

    public static SessionDescription getSessionDescription(String message) throws UnexpectedFieldException, SdpException {
        return (SessionDescription)SdpMessageParser.getInstance(SessionDescription.class).getDescription(message);
    }

    private void addElement(SdpElement element, SdpSyntax syntax) {
        Method method = null;
        Class[] args = new Class[]{element.getClass()};
        Object[] arguments = new Object[]{element};
        try {
            switch (syntax.getOccurrences()) {
                case 1: {
                    method = this.classInfo.getMethod("set" + syntax.getName(), args);
                    break;
                }
                case 2: {
                    method = this.classInfo.getMethod("set" + syntax.getName(), args);
                    break;
                }
                case 3: {
                    try {
                        method = this.classInfo.getMethod("add" + syntax.getName(), args);
                    }
                    catch (NoSuchMethodException noMethod) {
                        method = this.classInfo.getMethod("set" + syntax.getName(), args);
                    }
                    break;
                }
                case 4: {
                    try {
                        method = this.classInfo.getMethod("add" + syntax.getName(), args);
                        break;
                    }
                    catch (NoSuchMethodException noMethod) {
                        method = this.classInfo.getMethod("set" + syntax.getName(), args);
                    }
                }
            }
            this.methods.add(method);
            this.elements.add(arguments);
        }
        catch (Exception noAccess) {
            noAccess.printStackTrace();
        }
    }

    private void addToConstructor(SdpElement element) {
        this.constructorArgs.add(element);
    }

    private Description createDescription() throws SdpException {
        Description description = null;
        Class[] args = new Class[this.constructorArgs.size()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.constructorArgs.get(i).getClass();
        }
        try {
            Constructor constructor = this.classInfo.getConstructor(args);
            description = (Description)constructor.newInstance(this.constructorArgs.toArray());
        }
        catch (Exception e) {
            StringBuffer message = new StringBuffer();
            String line = System.getProperty("line.separator");
            message.append("This message is not valid !!! These elements are required :");
            message.append(line);
            message.append(line);
            while (this.syntaxs.hasNext()) {
                SdpSyntax syntax = (SdpSyntax)this.syntaxs.next();
                if (!syntax.isRequired()) continue;
                message.append("\t\t" + this.shortClassName(syntax.getType()));
                message.append(line);
            }
            throw new SdpException(message.toString());
        }
        try {
            for (int j = 0; j < this.methods.size(); ++j) {
                Method method = (Method)this.methods.get(j);
                method.invoke((Object)description, (Object[])this.elements.get(j));
            }
        }
        catch (Exception fieldException) {
            throw new SdpException(fieldException.getCause().getMessage());
        }
        return description;
    }

    private Description getDescription(String message) {
        String[] fields = message.split("\r\n|\n");
        Vector<String> temp = new Vector<String>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            temp.add(fields[i]);
        }
        return this.getDescription(temp.listIterator(), true);
    }

    private Description getDescription(ListIterator fields) throws UnexpectedFieldException, SdpException {
        return this.getDescription(fields, false);
    }

    private Description getDescription(ListIterator fields, boolean strict) throws UnexpectedFieldException, SdpException {
        this.parse(fields, strict);
        return this.createDescription();
    }

    private static SdpMessageParser getInstance(Class type) {
        return (SdpMessageParser)parsers.get(type);
    }

    private static boolean isDescription(Class c) {
        return c.getInterfaces()[0] == Description.class;
    }

    private void parse(ListIterator fields, boolean strict) throws UnexpectedFieldException, SdpException {
        SdpSyntax syntax = null;
        this.constructorArgs.clear();
        this.methods.clear();
        this.elements.clear();
        this.syntaxs = this.queque.listIterator();
        while (fields.hasNext() && this.syntaxs.hasNext()) {
            try {
                syntax = (SdpSyntax)this.syntaxs.next();
                switch (syntax.getOccurrences()) {
                    case 1: {
                        Field field;
                        SdpMessageParser parser;
                        try {
                            if (SdpMessageParser.isDescription(syntax.getType())) {
                                parser = SdpMessageParser.getInstance(syntax.getType());
                                Description aDescription = parser.getDescription(fields);
                                this.addElement(aDescription, syntax);
                                break;
                            }
                            field = this.parseField((String)fields.next(), syntax);
                            this.addElement(field, syntax);
                        }
                        catch (UnexpectedFieldException unexpectedField) {
                            fields.previous();
                        }
                        catch (SdpException invalidElementSyntax) {}
                        break;
                    }
                    case 2: {
                        Field field = this.parseField((String)fields.next(), syntax);
                        this.addToConstructor(field);
                        break;
                    }
                    case 3: {
                        Field field;
                        SdpMessageParser parser;
                        boolean maybeHasOccurrences = true;
                        while (fields.hasNext() && maybeHasOccurrences) {
                            try {
                                if (SdpMessageParser.isDescription(syntax.getType())) {
                                    parser = SdpMessageParser.getInstance(syntax.getType());
                                    Description aDescription = parser.getDescription(fields);
                                    this.addElement(aDescription, syntax);
                                    continue;
                                }
                                field = this.parseField((String)fields.next(), syntax);
                                this.addElement(field, syntax);
                            }
                            catch (UnexpectedFieldException unexpectedField) {
                                maybeHasOccurrences = false;
                                fields.previous();
                            }
                            catch (SdpException invalidElementSyntax) {}
                        }
                        break;
                    }
                    case 4: {
                        Field field;
                        SdpMessageParser parser;
                        if (SdpMessageParser.isDescription(syntax.getType())) {
                            parser = SdpMessageParser.getInstance(syntax.getType());
                            Description aDescription = parser.getDescription(fields);
                            this.addToConstructor(aDescription);
                        } else {
                            field = this.parseField((String)fields.next(), syntax);
                            this.addToConstructor(field);
                        }
                        boolean maybeMoreThanOne = true;
                        while (fields.hasNext() && maybeMoreThanOne) {
                            try {
                                if (SdpMessageParser.isDescription(syntax.getType())) {
                                    parser = SdpMessageParser.getInstance(syntax.getType());
                                    Description aDescription = parser.getDescription(fields);
                                    this.addElement(aDescription, syntax);
                                    continue;
                                }
                                field = this.parseField((String)fields.next(), syntax);
                                this.addElement(field, syntax);
                            }
                            catch (UnexpectedFieldException unexpectedField) {
                                maybeMoreThanOne = false;
                                fields.previous();
                            }
                            catch (SdpException invalidElementSyntax) {}
                        }
                        break;
                    }
                }
            }
            catch (UnexpectedFieldException unexpectedField) {
                StringBuffer message = new StringBuffer();
                message.append("A " + syntax.getName());
                if (!SdpMessageParser.isDescription(syntax.getType())) {
                    message.append(" field");
                }
                message.append(" is required at line " + fields.nextIndex() + ". This SDP message is not valid !!");
                throw new UnexpectedFieldException(message.toString());
            }
            catch (SdpException invalidElementSyntax) {
                StringBuffer message = new StringBuffer();
                message.append("The syntax of the " + syntax.getName());
                if (!SdpMessageParser.isDescription(syntax.getType())) {
                    message.append(" field");
                }
                message.append(" contained in this SDP message not valid !!");
                throw new SdpException(message.toString());
            }
        }
        if (fields.hasNext() && strict) {
            StringBuffer message = new StringBuffer("The syntax of the SDP message is not valid. These lines are not allowed :");
            message.append(System.getProperty("line.separator"));
            message.append(System.getProperty("line.separator"));
            while (fields.hasNext()) {
                message.append(fields.next() + System.getProperty("line.separator"));
            }
            throw new SdpException(message.toString());
        }
    }

    private Field parseField(String line, SdpSyntax syntax) throws UnexpectedFieldException, SdpException {
        Field field = null;
        SdpFieldParser parser = ParserFactory.getParser(syntax.getType(), line);
        field = parser.parse();
        return field;
    }

    private String shortClassName(Class c) {
        Package p = c.getPackage();
        return c.getName().substring(p.getName().length() + 1);
    }

    static {
        parsers.put(TimeDescription.class, new SdpMessageParser(TimeDescription.class));
        parsers.put(MediaDescription.class, new SdpMessageParser(MediaDescription.class));
        parsers.put(SessionDescription.class, new SdpMessageParser(SessionDescription.class));
    }
}

