/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.Key;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;

public class KeyParser
extends SdpFieldParser {
    public KeyParser(String input) {
        super(input);
    }

    public Field parse() throws UnexpectedFieldException, SdpException {
        if (!this.type.equals("k=")) {
            throw new UnexpectedFieldException("This is not a Key field : " + this.type + this.value);
        }
        StringTokenizer tokenizer = new StringTokenizer(this.value, ":");
        String method = null;
        String key = null;
        try {
            method = tokenizer.nextToken();
            key = this.value.substring(method.length() + 1);
        }
        catch (NoSuchElementException invalidData) {
            throw new SdpException("Invalid <method>:<data> format for this value : " + this.value);
        }
        return new Key(method, key);
    }
}

