/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.Media;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;

public class MediaParser
extends SdpFieldParser {
    public MediaParser(String input) {
        super(input);
    }

    public Field parse() throws UnexpectedFieldException, SdpException {
        Media field = null;
        if (!this.type.equals("m=")) {
            throw new UnexpectedFieldException("This is not a Media field : " + this.type + this.value);
        }
        String[] values = this.value.split(" ");
        if (values.length < 4) {
            throw new SdpException("Some media field parameters are missing");
        }
        String portInfo = values[1];
        String[] portInfoValues = portInfo.split("/");
        if (portInfoValues.length == 1) {
            field = new Media(values[0], Integer.parseInt(values[1]), values[2], values[3]);
        } else if (portInfoValues.length == 2) {
            field = new Media(values[0], Integer.parseInt(portInfoValues[0]), Integer.parseInt(portInfoValues[1]), values[2], values[3]);
        }
        try {
            for (int i = 4; i < values.length; ++i) {
                field.addMediaFormat(values[i]);
            }
        }
        catch (SdpException invalidMediaFormat) {
            // empty catch block
        }
        return field;
    }
}

