/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.parser;

import net.sourceforge.jsdp.Field;
import net.sourceforge.jsdp.Origin;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.parser.SdpFieldParser;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;

public class OriginParser
extends SdpFieldParser {
    public OriginParser(String input) {
        super(input);
    }

    public Field parse() throws UnexpectedFieldException, SdpException {
        if (!this.type.equals("o=")) {
            throw new UnexpectedFieldException("This is not an Origin field : " + this.type + this.value);
        }
        String[] values = this.value.split(" ");
        if (!values[3].equals("IN")) {
            throw new SdpException("Unknown NetType : " + values[3]);
        }
        if (!values[4].equals("IP4") && !values[4].equals("IP6")) {
            throw new SdpException("Unknown AddressType : " + values[4]);
        }
        String user = values[0];
        long sessionID = Long.valueOf(values[1]);
        long sessionVersion = Long.valueOf(values[2]);
        String address = values[5];
        return new Origin(user, sessionID, sessionVersion, address);
    }
}

