/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.sourceforge.jsdp.Description;
import net.sourceforge.jsdp.SdpException;
import net.sourceforge.jsdp.SdpMessageParser;
import net.sourceforge.jsdp.SessionDescription;
import net.sourceforge.jsdp.parser.UnexpectedFieldException;
import net.sourceforge.jsdp.tools.util.ClipboardPopup;
import net.sourceforge.jsdp.tools.util.SdpFileFilter;

public class SdpMessageParserGUI
extends JFrame {
    private static final long serialVersionUID = -8094695608668448929L;
    private static final String ABOUT = "jSDP : A Java implementation of SDP protocol\n\nCopyright \ufffd 2004 Claudio Di Vita\n\nVersion 0.1.2 - 7 June 2004\n\n";
    private JMenuItem aboutMenuItem;
    private JPanel buttonPanel;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JSeparator editMenuSeparator01;
    private JSeparator editMenuSeparator02;
    private JButton exitButton;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JSeparator fileMenuSeparator01;
    private JMenu infoMenu;
    private JMenuBar menuBar;
    private JTextArea messageArea;
    private JMenuItem newMenuItem;
    private JMenuItem openMenuItem;
    private JMenuItem pasteMenuItem;
    private JMenuItem saveMenuItem;
    private JScrollPane scrollPane;
    private JMenuItem selectAllMenuItem;
    private JMenuItem undoMenuItem;
    private JButton validateButton;

    public SdpMessageParserGUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initComponents();
        this.getRootPane().setDefaultButton(this.validateButton);
        this.setLocationRelativeTo(null);
        this.initFileMenuProperties();
        this.initEditMenuProperties();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemClassLoader().getResource("net/sourceforge/jsdp/tools/jsdp.gif")));
        ClipboardPopup.addPopupToComponent(this.messageArea);
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.messageArea = new JTextArea();
        this.buttonPanel = new JPanel();
        this.validateButton = new JButton();
        this.exitButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenuItem = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.fileMenuSeparator01 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.undoMenuItem = new JMenuItem();
        this.editMenuSeparator01 = new JSeparator();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.editMenuSeparator02 = new JSeparator();
        this.selectAllMenuItem = new JMenuItem();
        this.infoMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("jSDP 0.1.2 - SdpMessageParserGUI");
        this.setFont(new Font("Default", 0, 10));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                SdpMessageParserGUI.this.exitForm(event);
            }
        });
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setFont(new Font("Default", 0, 11));
        this.scrollPane.setMinimumSize(new Dimension(200, 150));
        this.scrollPane.setPreferredSize(new Dimension(500, 350));
        this.messageArea.setMargin(new Insets(2, 5, 2, 5));
        this.messageArea.setMaximumSize(null);
        this.messageArea.setMinimumSize(null);
        this.messageArea.setPreferredSize(null);
        this.scrollPane.setViewportView(this.messageArea);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.buttonPanel.setFont(new Font("Default", 0, 11));
        this.validateButton.setFont(new Font("Default", 0, 11));
        this.validateButton.setMnemonic('v');
        this.validateButton.setText("Validate");
        this.validateButton.setToolTipText("Validate the SDP message");
        this.validateButton.setMaximumSize(new Dimension(75, 25));
        this.validateButton.setMinimumSize(new Dimension(75, 25));
        this.validateButton.setPreferredSize(new Dimension(75, 25));
        this.validateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.validateButtonActionPerformed(event);
            }
        });
        this.buttonPanel.add(this.validateButton);
        this.exitButton.setFont(new Font("Default", 0, 11));
        this.exitButton.setMnemonic('e');
        this.exitButton.setText("Exit");
        this.exitButton.setToolTipText("Close the application");
        this.exitButton.setMaximumSize(new Dimension(75, 25));
        this.exitButton.setMinimumSize(new Dimension(75, 25));
        this.exitButton.setPreferredSize(new Dimension(75, 25));
        this.exitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.exitButtonActionPerformed(event);
            }
        });
        this.buttonPanel.add(this.exitButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent event) {
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuSelected(MenuEvent event) {
                SdpMessageParserGUI.this.fileMenuMenuSelected(event);
            }
        });
        this.newMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.newMenuItem.setText("New message");
        this.newMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.newMenuItemActionPerformed(event);
            }
        });
        this.fileMenu.add(this.newMenuItem);
        this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openMenuItem.setMnemonic('o');
        this.openMenuItem.setText("Open message");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.openMenuItemActionPerformed(event);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.saveMenuItem.setMnemonic('s');
        this.saveMenuItem.setText("Save message");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.saveMenuItemActionPerformed(event);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.fileMenu.add(this.fileMenuSeparator01);
        this.exitMenuItem.setMnemonic('e');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.exitMenuItemActionPerformed(event);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.editMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent event) {
            }

            public void menuDeselected(MenuEvent event) {
            }

            public void menuSelected(MenuEvent event) {
                SdpMessageParserGUI.this.editMenuMenuSelected(event);
            }
        });
        this.undoMenuItem.setMnemonic('u');
        this.undoMenuItem.setText("Undo");
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.undoMenuItemActionPerformed(event);
            }
        });
        this.editMenu.add(this.undoMenuItem);
        this.editMenu.add(this.editMenuSeparator01);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.cutMenuItemActionPerformed(event);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.copyMenuItemActionPerformed(event);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setMnemonic('p');
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.pasteMenuItemActionPerformed(event);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.deleteMenuItemActionPerformed(event);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.editMenu.add(this.editMenuSeparator02);
        this.selectAllMenuItem.setAccelerator(KeyStroke.getKeyStroke(53, 2));
        this.selectAllMenuItem.setText("Select all");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.selectAllMenuItemActionPerformed(event);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.menuBar.add(this.editMenu);
        this.infoMenu.setText("?");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SdpMessageParserGUI.this.aboutMenuItemActionPerformed(event);
            }
        });
        this.infoMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.infoMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void newMenuItemActionPerformed(ActionEvent event) {
        this.messageArea.setText(null);
        this.initFileMenuProperties();
        this.initEditMenuProperties();
    }

    private void deleteMenuItemActionPerformed(ActionEvent event) {
        this.messageArea.replaceSelection(null);
    }

    private void selectAllMenuItemActionPerformed(ActionEvent event) {
        this.messageArea.selectAll();
    }

    private void copyMenuItemActionPerformed(ActionEvent event) {
        this.messageArea.copy();
    }

    private void cutMenuItemActionPerformed(ActionEvent event) {
        this.messageArea.cut();
    }

    private void pasteMenuItemActionPerformed(ActionEvent event) {
        this.messageArea.paste();
    }

    private void editMenuMenuSelected(MenuEvent event) {
        this.initEditMenuProperties();
    }

    private void initEditMenuProperties() {
        boolean hasSelection = this.messageArea.getSelectedText() != null;
        this.cutMenuItem.setEnabled(hasSelection);
        this.copyMenuItem.setEnabled(hasSelection);
        this.pasteMenuItem.setEnabled(!ClipboardPopup.isClipboardEmpty(this.messageArea));
        this.deleteMenuItem.setEnabled(hasSelection);
        this.selectAllMenuItem.setEnabled(this.messageArea.getSelectedText() == null || this.messageArea.getText().length() != this.messageArea.getSelectedText().length());
    }

    private void initFileMenuProperties() {
        this.saveMenuItem.setEnabled(false);
    }

    private void undoMenuItemActionPerformed(ActionEvent event) {
    }

    private void fileMenuMenuSelected(MenuEvent event) {
        this.saveMenuItem.setEnabled(this.messageArea.getLineCount() > 4);
    }

    private void saveMenuItemActionPerformed(ActionEvent event) {
        SessionDescription message;
        if (this.saveMenuItem.isEnabled() && (message = this.validateMessage()) != null) {
            JFileChooser dialog = new JFileChooser(System.getProperty("user.dir"));
            dialog.setDialogTitle("Save a SDP message...");
            dialog.setFileFilter(new SdpFileFilter());
            int result = dialog.showSaveDialog(this);
            if (result == 0) {
                try {
                    this.saveFile(dialog.getSelectedFile(), message);
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent event) {
        JOptionPane.showMessageDialog(this, ABOUT, "About jSDP", 1);
    }

    private void exitMenuItemActionPerformed(ActionEvent event) {
        System.exit(0);
    }

    private void exitButtonActionPerformed(ActionEvent event) {
        System.exit(0);
    }

    private void validateButtonActionPerformed(ActionEvent event) {
        this.validateMessage(true);
    }

    private void openMenuItemActionPerformed(ActionEvent event) {
        File file = this.selectFile();
        if (file != null) {
            try {
                this.messageArea.setText(SdpMessageParserGUI.readFile(file));
            }
            catch (FileNotFoundException fileNotFound) {
                fileNotFound.printStackTrace();
            }
            catch (IOException readError) {
                readError.printStackTrace();
            }
        }
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    private static String readFile(File file) throws FileNotFoundException, IOException {
        StringBuffer result = new StringBuffer();
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            int i;
            while ((i = reader.read()) != -1) {
                char c = (char)i;
                result.append(c);
            }
        }
        catch (IOException readError) {
            throw new IOException("Unable to read from file " + file.toString());
        }
        return result.toString();
    }

    private void saveFile(File file, Description description) throws IOException {
        if (!"sdp".equals(SdpFileFilter.getExtension(file))) {
            file = new File(file.getAbsolutePath() + ".sdp");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(description.encode());
        writer.flush();
        writer.close();
    }

    private File selectFile() {
        File file = null;
        JFileChooser dialog = new JFileChooser();
        dialog.setDialogTitle("Open a SDP message...");
        int result = dialog.showOpenDialog(this);
        if (result == 0) {
            file = dialog.getSelectedFile();
        }
        return file;
    }

    private SessionDescription validateMessage() {
        return this.validateMessage(false);
    }

    private SessionDescription validateMessage(boolean showValidMessage) {
        SessionDescription message = null;
        try {
            message = SdpMessageParser.getSessionDescription(this.messageArea.getText());
            if (showValidMessage) {
                JOptionPane.showMessageDialog(this, "This is a valid SDP message !!!", "jSDP 0.1.2", 1);
            }
        }
        catch (UnexpectedFieldException unexpectedField) {
            JOptionPane.showMessageDialog(this, unexpectedField.getMessage(), "jSDP 0.1.2", 0);
        }
        catch (SdpException invalidSyntax) {
            JOptionPane.showMessageDialog(this, invalidSyntax.getMessage(), "jSDP 0.1.2", 0);
        }
        return message;
    }

    public static void main(String[] args) {
        new SdpMessageParserGUI().setVisible(true);
    }
}

