/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.jsdp.util.InvalidValueException;

public class EmailAddress
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -1082887678662975345L;
    private static final String EMAIL = "([\\w'-/:?#\\$&\\*;=\\[\\]\\^_`\\{\\}\\+~]+(\\.[\\w'-/:?#\\$&\\*;=\\[\\]\\^_`\\{\\}\\+~]+)*)@([\\w'-/:?#\\$&\\*;=\\[\\]\\^_`\\{\\}\\+~]+(\\.[\\w'-/:?#\\$&\\*;=\\[\\]\\^_`\\{\\}\\+~]+)*)";
    private static final String PERSONAL = "[^\\(\\)<>\\r\\n]+";
    protected String address;
    protected String personal;

    protected EmailAddress() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EmailAddress(String address) throws InvalidValueException {
        Matcher emailMatcher = Pattern.compile(EMAIL).matcher(address);
        if (emailMatcher.lookingAt()) {
            int position = emailMatcher.end();
            if (position == address.length()) {
                this.address = address;
                return;
            } else {
                this.address = address.substring(0, position);
                StringTokenizer tokenizer = new StringTokenizer(address.substring(position), "()");
                StringBuffer temp = new StringBuffer();
                while (tokenizer.hasMoreTokens()) {
                    temp.append(tokenizer.nextToken());
                }
                String name = temp.toString().trim();
                if (name.length() <= 0) throw new InvalidValueException("invalid format");
                this.setPersonal(name);
            }
            return;
        } else {
            StringTokenizer tokenizer = new StringTokenizer(address, "<>");
            this.setPersonal(tokenizer.nextToken().trim());
            this.setAddress(tokenizer.nextToken());
        }
    }

    public EmailAddress(String address, String personal) throws InvalidValueException {
        this.setAddress(address);
        this.setPersonal(personal);
    }

    public Object clone() {
        EmailAddress email = new EmailAddress();
        email.address = new String(this.address);
        email.personal = this.personal != null ? new String(this.personal) : null;
        return email;
    }

    public String getAddress() {
        return this.address;
    }

    public String getPersonal() {
        return this.personal;
    }

    public void setAddress(String address) throws InvalidValueException {
        if (!Pattern.matches(EMAIL, address)) {
            throw new InvalidValueException("Invalid email address :" + address);
        }
        this.address = address;
    }

    public void setPersonal(String personal) throws InvalidValueException {
        if (!Pattern.matches(PERSONAL, personal)) {
            throw new InvalidValueException("Invalid personal :" + personal);
        }
        this.personal = personal.trim();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.personal != null) {
            result.append(this.personal);
            result.append(" <" + this.getAddress() + ">");
        } else {
            result.append(this.getAddress());
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(new EmailAddress("Claudio Di Vita <talyan@users.sourceforge.net>"));
    }
}

