/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jsdp.util;

import java.io.Serializable;
import java.util.Date;
import net.sourceforge.jsdp.Time;
import net.sourceforge.jsdp.util.InvalidValueException;

public class ZoneAdjustment
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5613785303341511624L;
    protected long offset;
    protected long time;

    protected ZoneAdjustment() {
    }

    public ZoneAdjustment(long time, long offset) throws InvalidValueException {
        this.setTime(time);
        this.offset = offset;
    }

    public ZoneAdjustment(Date time, long offset) throws InvalidValueException {
        this.setTime(Time.getNTP(time));
        this.offset = offset;
    }

    public Object clone() {
        ZoneAdjustment adjustment = new ZoneAdjustment();
        adjustment.time = this.time;
        adjustment.offset = this.offset;
        return adjustment;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getTime() {
        return this.time;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public void setTime(long time) throws InvalidValueException {
        if (time < 0L) {
            throw new InvalidValueException("Time must be > 0");
        }
        this.time = time;
    }

    public String toString() {
        return this.time + " " + this.offset;
    }
}

