/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.stack.MessageProcessor;
import java.text.ParseException;
import javax.sip.ListeningPoint;
import javax.sip.SipStack;

public class ListeningPointImpl
implements ListeningPoint {
    protected String transport;
    int port;
    protected MessageProcessor messageProcessor;
    protected SipProviderImpl sipProvider;
    protected SipStackImpl sipStack;

    public static String makeKey(String host, int port, String transport) {
        return (host + ":" + port + "/" + transport).toLowerCase();
    }

    protected String getKey() {
        return ListeningPointImpl.makeKey(this.getIPAddress(), this.port, this.transport);
    }

    protected void setSipProvider(SipProviderImpl sipProviderImpl) {
        this.sipProvider = sipProviderImpl;
    }

    protected void removeSipProvider() {
        this.sipProvider = null;
    }

    protected ListeningPointImpl(SipStack sipStack, int port, String transport) {
        this.sipStack = (SipStackImpl)sipStack;
        this.port = port;
        this.transport = transport;
    }

    public Object clone() {
        ListeningPointImpl lip = new ListeningPointImpl(this.sipStack, this.port, null);
        lip.sipStack = this.sipStack;
        return lip;
    }

    public int getPort() {
        return this.messageProcessor.getPort();
    }

    public String getTransport() {
        return this.messageProcessor.getTransport();
    }

    public SipProviderImpl getProvider() {
        return this.sipProvider;
    }

    public String getIPAddress() {
        return this.messageProcessor.getIPAddress().getHostAddress();
    }

    public void setSentBy(String sentBy) throws ParseException {
        this.messageProcessor.setSentBy(sentBy);
    }

    public String getSentBy() {
        return this.messageProcessor.getSentBy();
    }

    public boolean isSentBySet() {
        return this.messageProcessor.isSentBySet();
    }

    public Via getViaHeader() {
        return this.messageProcessor.getViaHeader();
    }

    public MessageProcessor getMessageProcessor() {
        return this.messageProcessor;
    }
}

