/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import gov.nist.core.Host;
import gov.nist.core.HostPort;
import gov.nist.core.LogWriter;
import gov.nist.core.net.AddressResolver;
import gov.nist.core.net.DefaultNetworkLayer;
import gov.nist.core.net.NetworkLayer;
import gov.nist.javax.sip.DefaultAddressResolver;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.Event;
import gov.nist.javax.sip.header.Server;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.DefaultRouter;
import gov.nist.javax.sip.stack.IOHandler;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPDialog;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionErrorEvent;
import gov.nist.javax.sip.stack.SIPTransactionEventListener;
import gov.nist.javax.sip.stack.ServerLog;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;
import gov.nist.javax.sip.stack.TCPMessageProcessor;
import gov.nist.javax.sip.stack.TLSMessageProcessor;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import javax.sip.ClientTransaction;
import javax.sip.DialogTerminatedEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;

public abstract class SIPTransactionStack
implements SIPTransactionEventListener {
    public static final int BASE_TIMER_INTERVAL = 500;
    public static final int CONNECTION_LINGER_TIME = 8;
    protected ConcurrentHashMap retransmissionAlertTransactions;
    protected ConcurrentHashMap dialogTable;
    protected HashSet dialogCreatingMethods;
    protected Timer timer;
    private ConcurrentHashMap pendingTransactions;
    private ConcurrentHashMap clientTransactionTable;
    private boolean unlimitedTableSize = false;
    protected int serverTransactionTableHighwaterMark = 5000;
    protected int serverTransactionTableLowaterMark = 4000;
    private ConcurrentHashMap serverTransactionTable;
    protected LogWriter logWriter;
    protected ServerLog serverLog;
    boolean udpFlag;
    protected DefaultRouter defaultRouter;
    protected boolean needsLogging;
    protected boolean non2XXAckPassedToListener;
    protected IOHandler ioHandler;
    protected boolean toExit = false;
    protected String stackName;
    protected String stackAddress;
    protected InetAddress stackInetAddress;
    protected StackMessageFactory sipMessageFactory;
    protected Router router;
    protected int threadPoolSize = -1;
    protected int maxConnections = -1;
    protected boolean cacheServerConnections = true;
    protected boolean cacheClientConnections = true;
    protected boolean useRouterForAll;
    protected int maxContentLength;
    protected int maxMessageSize;
    private Collection messageProcessors;
    protected int readTimeout = -1;
    protected NetworkLayer networkLayer;
    protected String outboundProxy;
    protected String routerPath;
    protected boolean isAutomaticDialogSupportEnabled;
    protected HashSet forkedEvents = new HashSet();
    protected boolean generateTimeStampHeader;
    protected AddressResolver addressResolver;

    protected SIPTransactionStack() {
        this.messageProcessors = new ArrayList();
        this.ioHandler = new IOHandler(this);
        this.dialogCreatingMethods = new HashSet();
        this.dialogCreatingMethods.add("REFER");
        this.dialogCreatingMethods.add("INVITE");
        this.dialogCreatingMethods.add("SUBSCRIBE");
        this.addressResolver = new DefaultAddressResolver();
        this.dialogTable = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.timer = new Timer();
        this.pendingTransactions = new ConcurrentHashMap();
    }

    protected void reInit() {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Re-initializing !");
        }
        this.messageProcessors = new ArrayList();
        this.ioHandler = new IOHandler(this);
        this.pendingTransactions = new ConcurrentHashMap();
        this.clientTransactionTable = new ConcurrentHashMap();
        this.serverTransactionTable = new ConcurrentHashMap();
        this.retransmissionAlertTransactions = new ConcurrentHashMap();
        this.dialogTable = new ConcurrentHashMap();
        this.timer = new Timer();
    }

    public void disableLogging() {
        this.getLogWriter().disableLogging();
    }

    public void enableLogging() {
        this.getLogWriter().enableLogging();
    }

    public void printDialogTable() {
        if (this.getLogWriter().isLoggingEnabled()) {
            this.getLogWriter().logDebug("dialog table  = " + this.dialogTable);
            System.out.println("dialog table = " + this.dialogTable);
        }
    }

    public SIPServerTransaction getRetransmissionAlertTransaction(String dialogId) {
        return (SIPServerTransaction)this.retransmissionAlertTransactions.get((Object)dialogId);
    }

    public boolean isDialogCreated(String method) {
        boolean retval = this.dialogCreatingMethods.contains(method);
        if (this.isLoggingEnabled()) {
            this.getLogWriter().logDebug("isDialogCreated : " + method + " returning " + retval);
        }
        return retval;
    }

    public void addExtensionMethod(String extensionMethod) {
        if (extensionMethod.equals("NOTIFY")) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("NOTIFY Supported Natively");
            }
        } else {
            this.dialogCreatingMethods.add(extensionMethod.trim().toUpperCase());
        }
    }

    public void putDialog(SIPDialog dialog) {
        String dialogId = dialog.getDialogId();
        if (this.dialogTable.containsKey((Object)dialogId)) {
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("putDialog: dialog already exists" + dialogId + " in table = " + this.dialogTable.get((Object)dialogId));
            }
            return;
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("putDialog dialogId=" + dialogId + " dialog = " + dialog);
        }
        dialog.setStack(this);
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logStackTrace();
        }
        this.dialogTable.put((Object)dialogId, (Object)dialog);
    }

    public SIPDialog createDialog(SIPTransaction transaction) {
        SIPDialog retval = new SIPDialog(transaction);
        return retval;
    }

    public Iterator getDialogs() {
        return this.dialogTable.values().iterator();
    }

    public void removeDialog(SIPDialog dialog) {
        Object old;
        String id = dialog.getDialogId();
        if (id != null && (old = this.dialogTable.remove((Object)id)) != null && !dialog.testAndSetIsDialogTerminatedEventDelivered()) {
            DialogTerminatedEvent event = new DialogTerminatedEvent(dialog.getSipProvider(), dialog);
            dialog.getSipProvider().handleEvent(event, null);
        }
    }

    public SIPDialog getDialog(String dialogId) {
        SIPDialog sipDialog = (SIPDialog)this.dialogTable.get((Object)dialogId);
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("getDialog(" + dialogId + ") : returning " + sipDialog);
        }
        return sipDialog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SIPClientTransaction findSubscribeTransaction(SIPRequest notifyMessage, ListeningPointImpl listeningPoint) {
        SIPClientTransaction sIPClientTransaction;
        SIPClientTransaction retval;
        block12: {
            SIPClientTransaction sIPClientTransaction2;
            block11: {
                SIPClientTransaction sIPClientTransaction3;
                block10: {
                    retval = null;
                    try {
                        Iterator it = this.clientTransactionTable.values().iterator();
                        this.logWriter.logDebug("ct table size = " + this.clientTransactionTable.size());
                        String thisToTag = notifyMessage.getTo().getTag();
                        if (thisToTag == null) {
                            SIPClientTransaction sIPClientTransaction4 = retval;
                            Object var19_8 = null;
                            if (!this.isLoggingEnabled()) return sIPClientTransaction4;
                            this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
                            return sIPClientTransaction4;
                        }
                        Event eventHdr = (Event)notifyMessage.getHeader("Event");
                        if (eventHdr == null) {
                            if (this.logWriter.isLoggingEnabled()) {
                                this.logWriter.logDebug("event Header is null -- returning null");
                            }
                            sIPClientTransaction3 = retval;
                            break block10;
                        }
                        while (it.hasNext()) {
                            SIPClientTransaction ct = (SIPClientTransaction)it.next();
                            if (!ct.getMethod().equals("SUBSCRIBE")) continue;
                            SIPRequest sipRequest = ct.getOriginalRequest();
                            Contact contact = sipRequest.getContactHeader();
                            Address address = contact.getAddress();
                            SipURI uri = (SipURI)address.getURI();
                            String host = uri.getHost();
                            int port = uri.getPort();
                            String transport = uri.getTransportParam();
                            if (transport == null) {
                                transport = "udp";
                            }
                            if (port == -1) {
                                port = transport.equals("udp") || transport.equals("tcp") ? 5060 : 5061;
                            }
                            String fromTag = ct.from.getTag();
                            Event hisEvent = ct.event;
                            if (hisEvent == null) continue;
                            if (this.isLoggingEnabled()) {
                                this.logWriter.logDebug("ct.fromTag = " + fromTag);
                                this.logWriter.logDebug("thisToTag = " + thisToTag);
                                this.logWriter.logDebug("hisEvent = " + hisEvent);
                                this.logWriter.logDebug("eventHdr " + eventHdr);
                            }
                            if (listeningPoint.getPort() != port || !listeningPoint.getIPAddress().equals(host) || !fromTag.equalsIgnoreCase(thisToTag) || hisEvent == null || !eventHdr.match(hisEvent) || !notifyMessage.getCallId().getCallId().equalsIgnoreCase(ct.callId.getCallId())) continue;
                            if (ct.acquireSem()) {
                                retval = ct;
                            }
                            sIPClientTransaction2 = retval;
                            break block11;
                        }
                        sIPClientTransaction = retval;
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var19_12 = null;
                        if (!this.isLoggingEnabled()) throw throwable;
                        this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
                        throw throwable;
                    }
                }
                Object var19_9 = null;
                if (!this.isLoggingEnabled()) return sIPClientTransaction3;
                this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
                return sIPClientTransaction3;
            }
            Object var19_10 = null;
            if (!this.isLoggingEnabled()) return sIPClientTransaction2;
            this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
            return sIPClientTransaction2;
        }
        Object var19_11 = null;
        if (!this.isLoggingEnabled()) return sIPClientTransaction;
        this.logWriter.logDebug("findSubscribeTransaction : returning " + retval);
        return sIPClientTransaction;
    }

    public SIPTransaction findTransaction(SIPMessage sipMessage, boolean isServer) {
        SIPTransaction retval = null;
        if (isServer) {
            Via via = sipMessage.getTopmostVia();
            if (via.getBranch() != null) {
                String key = sipMessage.getTransactionId();
                retval = (SIPTransaction)this.serverTransactionTable.get((Object)key);
                if (this.logWriter.isLoggingEnabled()) {
                    this.getLogWriter().logDebug("serverTx: looking for key " + key + " existing=" + this.serverTransactionTable);
                }
                if (key.startsWith("z9hg4bk")) {
                    return retval;
                }
            }
            Iterator it = this.serverTransactionTable.values().iterator();
            while (it.hasNext()) {
                SIPServerTransaction sipServerTransaction = (SIPServerTransaction)it.next();
                if (!sipServerTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return sipServerTransaction;
            }
        } else {
            Via via = sipMessage.getTopmostVia();
            if (via.getBranch() != null) {
                String key = sipMessage.getTransactionId();
                if (this.logWriter.isLoggingEnabled()) {
                    this.getLogWriter().logDebug("clientTx: looking for key " + key);
                }
                retval = (SIPTransaction)this.clientTransactionTable.get((Object)key);
                if (key.startsWith("z9hg4bk")) {
                    return retval;
                }
            }
            Iterator it = this.clientTransactionTable.values().iterator();
            while (it.hasNext()) {
                SIPClientTransaction clientTransaction = (SIPClientTransaction)it.next();
                if (!clientTransaction.isMessagePartOfTransaction(sipMessage)) continue;
                return clientTransaction;
            }
        }
        return null;
    }

    public SIPTransaction findCancelTransaction(SIPRequest cancelRequest, boolean isServer) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("findCancelTransaction request= \n" + cancelRequest + "\nfindCancelRequest isServer=" + isServer);
        }
        if (isServer) {
            Iterator li = this.serverTransactionTable.values().iterator();
            while (li.hasNext()) {
                SIPTransaction transaction = (SIPTransaction)li.next();
                SIPServerTransaction sipServerTransaction = (SIPServerTransaction)transaction;
                if (!sipServerTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipServerTransaction;
            }
        } else {
            Iterator li = this.clientTransactionTable.values().iterator();
            while (li.hasNext()) {
                SIPTransaction transaction = (SIPTransaction)li.next();
                SIPClientTransaction sipClientTransaction = (SIPClientTransaction)transaction;
                if (!sipClientTransaction.doesCancelMatchTransaction(cancelRequest)) continue;
                return sipClientTransaction;
            }
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Could not find transaction for cancel request");
        }
        return null;
    }

    protected SIPTransactionStack(StackMessageFactory messageFactory) {
        this();
        this.sipMessageFactory = messageFactory;
    }

    public SIPServerTransaction findPendingTransaction(SIPRequest requestReceived) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("looking for pending tx for :" + requestReceived.getTransactionId());
        }
        return (SIPServerTransaction)this.pendingTransactions.get((Object)requestReceived.getTransactionId());
    }

    public void removePendingTransaction(SIPServerTransaction tr) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("removePendingTx: " + tr.getTransactionId());
        }
        this.pendingTransactions.remove((Object)tr.getTransactionId());
    }

    public void mapTransaction(SIPServerTransaction transaction) {
        if (transaction.isMapped) {
            return;
        }
        this.addTransactionHash(transaction);
        transaction.startTransactionTimer();
        transaction.isMapped = true;
    }

    public ServerRequestInterface newSIPServerRequest(SIPRequest requestReceived, MessageChannel requestMessageChannel) {
        String key = requestReceived.getTransactionId();
        requestReceived.setMessageChannel(requestMessageChannel);
        SIPServerTransaction currentTransaction = (SIPServerTransaction)this.serverTransactionTable.get((Object)key);
        if (currentTransaction == null || !currentTransaction.isMessagePartOfTransaction(requestReceived)) {
            Iterator transactionIterator = this.serverTransactionTable.values().iterator();
            currentTransaction = null;
            if (!key.toLowerCase().startsWith("z9hg4bk")) {
                while (transactionIterator.hasNext() && currentTransaction == null) {
                    SIPServerTransaction nextTransaction = (SIPServerTransaction)transactionIterator.next();
                    if (!nextTransaction.isMessagePartOfTransaction(requestReceived)) continue;
                    currentTransaction = nextTransaction;
                }
            }
            if (currentTransaction == null) {
                currentTransaction = this.findPendingTransaction(requestReceived);
                if (currentTransaction != null) {
                    requestReceived.setTransaction(currentTransaction);
                    if (currentTransaction != null && currentTransaction.acquireSem()) {
                        return currentTransaction;
                    }
                    return null;
                }
                currentTransaction = this.createServerTransaction(requestMessageChannel);
                if (currentTransaction != null) {
                    currentTransaction.setOriginalRequest(requestReceived);
                    requestReceived.setTransaction(currentTransaction);
                }
            }
        }
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("newSIPServerRequest( " + requestReceived.getMethod() + ":" + requestReceived.getTopmostVia().getBranch() + "):" + currentTransaction);
        }
        if (currentTransaction != null) {
            currentTransaction.setRequestInterface(this.sipMessageFactory.newSIPServerRequest(requestReceived, currentTransaction));
        }
        if (currentTransaction != null && currentTransaction.acquireSem()) {
            return currentTransaction;
        }
        return null;
    }

    protected ServerResponseInterface newSIPServerResponse(SIPResponse responseReceived, MessageChannel responseMessageChannel) {
        String key;
        SIPClientTransaction currentTransaction;
        if (this.serverLog.needsLogging(16)) {
            responseMessageChannel.logResponse(responseReceived, System.currentTimeMillis(), "before processing");
        }
        if ((currentTransaction = (SIPClientTransaction)this.clientTransactionTable.get((Object)(key = responseReceived.getTransactionId()))) == null || !currentTransaction.isMessagePartOfTransaction(responseReceived)) {
            Iterator transactionIterator = this.clientTransactionTable.values().iterator();
            currentTransaction = null;
            while (transactionIterator.hasNext() && currentTransaction == null) {
                SIPClientTransaction nextTransaction = (SIPClientTransaction)transactionIterator.next();
                if (!nextTransaction.isMessagePartOfTransaction(responseReceived)) continue;
                currentTransaction = nextTransaction;
            }
            if (currentTransaction == null) {
                return this.sipMessageFactory.newSIPServerResponse(responseReceived, responseMessageChannel);
            }
        }
        currentTransaction.setResponseInterface(this.sipMessageFactory.newSIPServerResponse(responseReceived, currentTransaction));
        if (currentTransaction.acquireSem()) {
            return currentTransaction;
        }
        return null;
    }

    public MessageChannel createMessageChannel(SIPRequest request, MessageProcessor mp, Hop nextHop) throws IOException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel mc = mp.createMessageChannel(targetHostPort);
        if (mc == null) {
            return null;
        }
        SIPClientTransaction returnChannel = this.createClientTransaction(request, mc);
        returnChannel.setViaPort(nextHop.getPort());
        returnChannel.setViaHost(nextHop.getHost());
        this.addTransactionHash(returnChannel);
        ((SIPTransaction)returnChannel).startTransactionTimer();
        return returnChannel;
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sipRequest, MessageChannel encapsulatedMessageChannel) {
        SIPClientTransaction ct = new SIPClientTransaction(this, encapsulatedMessageChannel);
        ct.setOriginalRequest(sipRequest);
        return ct;
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        boolean decision;
        if (this.unlimitedTableSize || this.serverTransactionTable.size() < this.serverTransactionTableLowaterMark) {
            return new SIPServerTransaction(this, encapsulatedMessageChannel);
        }
        if (this.serverTransactionTable.size() >= this.serverTransactionTableHighwaterMark) {
            return null;
        }
        float threshold = (float)(this.serverTransactionTable.size() - this.serverTransactionTableLowaterMark) / (float)(this.serverTransactionTableHighwaterMark - this.serverTransactionTableLowaterMark);
        boolean bl = decision = Math.random() > 1.0 - (double)threshold;
        if (decision) {
            return null;
        }
        return new SIPServerTransaction(this, encapsulatedMessageChannel);
    }

    public void addTransaction(SIPClientTransaction clientTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("added transaction " + clientTransaction);
        }
        this.addTransactionHash(clientTransaction);
        clientTransaction.startTransactionTimer();
    }

    public void removeTransaction(SIPTransaction sipTransaction) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("Removing Transaction = " + sipTransaction.getTransactionId());
        }
        if (sipTransaction instanceof SIPServerTransaction) {
            String key = sipTransaction.getTransactionId();
            Object removed = this.serverTransactionTable.remove((Object)key);
            this.removePendingTransaction((SIPServerTransaction)sipTransaction);
            SipProviderImpl sipProvider = sipTransaction.getSipProvider();
            if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ServerTransaction)((Object)sipTransaction));
                sipProvider.handleEvent(event, sipTransaction);
            }
        } else {
            String key = sipTransaction.getTransactionId();
            Object removed = this.clientTransactionTable.remove((Object)key);
            if (removed != null && sipTransaction.testAndSetTransactionTerminatedEvent()) {
                SipProviderImpl sipProvider = sipTransaction.getSipProvider();
                TransactionTerminatedEvent event = new TransactionTerminatedEvent((Object)sipProvider, (ClientTransaction)((Object)sipTransaction));
                sipProvider.handleEvent(event, sipTransaction);
            }
        }
    }

    public void addTransaction(SIPServerTransaction serverTransaction) throws IOException {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("added transaction " + serverTransaction);
        }
        serverTransaction.map();
        this.addTransactionHash(serverTransaction);
        serverTransaction.startTransactionTimer();
    }

    private void addTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipTransaction instanceof SIPClientTransaction) {
            String key = sipRequest.getTransactionId();
            this.clientTransactionTable.put((Object)key, (Object)sipTransaction);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug(" putTransactionHash :  key = " + key);
            }
        } else {
            String key = sipRequest.getTransactionId();
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug(" putTransactionHash :  key = " + key);
            }
            this.serverTransactionTable.put((Object)key, (Object)sipTransaction);
        }
    }

    protected void removeTransactionHash(SIPTransaction sipTransaction) {
        SIPRequest sipRequest = sipTransaction.getOriginalRequest();
        if (sipRequest == null) {
            return;
        }
        if (sipTransaction instanceof SIPClientTransaction) {
            String key = sipTransaction.getTransactionId();
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logStackTrace();
                this.logWriter.logDebug("removing client Tx : " + key);
            }
            this.clientTransactionTable.remove((Object)key);
        } else if (sipTransaction instanceof SIPServerTransaction) {
            String key = sipTransaction.getTransactionId();
            this.serverTransactionTable.remove((Object)key);
            if (this.logWriter.isLoggingEnabled()) {
                this.logWriter.logDebug("removing server Tx : " + key);
            }
        }
    }

    public synchronized void transactionErrorEvent(SIPTransactionErrorEvent transactionErrorEvent) {
        SIPTransaction transaction = (SIPTransaction)transactionErrorEvent.getSource();
        if (transactionErrorEvent.getErrorID() == 2) {
            transaction.setState(SIPTransaction.TERMINATED_STATE);
            if (transaction instanceof SIPServerTransaction) {
                ((SIPServerTransaction)transaction).collectionTime = 0;
            }
            transaction.disableTimeoutTimer();
            transaction.disableRetransmissionTimer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopStack() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
        this.pendingTransactions.clear();
        this.toExit = true;
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        object = this.messageProcessors;
        synchronized (object) {
            MessageProcessor[] processorList = this.getMessageProcessors();
            for (int processorIndex = 0; processorIndex < processorList.length; ++processorIndex) {
                this.removeMessageProcessor(processorList[processorIndex]);
            }
            this.ioHandler.closeAll();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.clientTransactionTable.clear();
        this.serverTransactionTable.clear();
        this.dialogTable.clear();
    }

    public void putPendingTransaction(SIPServerTransaction tr) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("putPendingTransaction: " + tr);
        }
        this.pendingTransactions.put((Object)tr.getTransactionId(), (Object)tr);
    }

    public NetworkLayer getNetworkLayer() {
        if (this.networkLayer == null) {
            return DefaultNetworkLayer.SINGLETON;
        }
        return this.networkLayer;
    }

    public boolean isLoggingEnabled() {
        return this.logWriter == null ? false : this.logWriter.isLoggingEnabled();
    }

    public LogWriter getLogWriter() {
        return this.logWriter;
    }

    public ServerLog getServerLog() {
        return this.serverLog;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setSingleThreaded() {
        this.threadPoolSize = 1;
    }

    public void setThreadPoolSize(int size) {
        this.threadPoolSize = size;
    }

    public void setMaxConnections(int nconnections) {
        this.maxConnections = nconnections;
    }

    public Hop getNextHop(SIPRequest sipRequest) throws SipException {
        if (this.useRouterForAll) {
            if (this.router != null) {
                return this.router.getNextHop(sipRequest);
            }
            return null;
        }
        if (sipRequest.getRequestURI().isSipURI() || sipRequest.getRouteHeaders() != null) {
            return this.defaultRouter.getNextHop(sipRequest);
        }
        if (this.router != null) {
            return this.router.getNextHop(sipRequest);
        }
        return null;
    }

    public void setStackName(String stackName) {
        this.stackName = stackName;
    }

    public Server createServerHeaderForStack() {
        Server retval = new Server();
        retval.addProductToken(this.stackName);
        return retval;
    }

    protected void setHostAddress(String stackAddress) throws UnknownHostException {
        this.stackAddress = stackAddress.indexOf(58) != stackAddress.lastIndexOf(58) && stackAddress.trim().charAt(0) != '[' ? '[' + stackAddress + ']' : stackAddress;
        this.stackInetAddress = InetAddress.getByName(stackAddress);
    }

    public String getHostAddress() {
        return this.stackAddress;
    }

    protected void setRouter(Router router) {
        this.router = router;
    }

    public Router getRouter(SIPRequest request) {
        if (this.useRouterForAll) {
            return this.router;
        }
        if (request.getRequestURI().getScheme().equals("sip") || request.getRequestURI().getScheme().equals("sips")) {
            return this.defaultRouter;
        }
        if (this.router != null) {
            return this.router;
        }
        return this.defaultRouter;
    }

    public Router getRouter() {
        return this.router;
    }

    public boolean isAlive() {
        return !this.toExit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessageProcessor(MessageProcessor newMessageProcessor) throws IOException {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            this.messageProcessors.add(newMessageProcessor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMessageProcessor(MessageProcessor oldMessageProcessor) {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            if (this.messageProcessors.remove(oldMessageProcessor)) {
                oldMessageProcessor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageProcessor[] getMessageProcessors() {
        Collection collection = this.messageProcessors;
        synchronized (collection) {
            return this.messageProcessors.toArray(new MessageProcessor[0]);
        }
    }

    protected MessageProcessor createMessageProcessor(InetAddress ipAddress, int port, String transport) throws IOException {
        if (transport.equalsIgnoreCase("udp")) {
            UDPMessageProcessor udpMessageProcessor = new UDPMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(udpMessageProcessor);
            this.udpFlag = true;
            return udpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tcp")) {
            TCPMessageProcessor tcpMessageProcessor = new TCPMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(tcpMessageProcessor);
            return tcpMessageProcessor;
        }
        if (transport.equalsIgnoreCase("tls")) {
            TLSMessageProcessor tlsMessageProcessor = new TLSMessageProcessor(ipAddress, this, port);
            this.addMessageProcessor(tlsMessageProcessor);
            return tlsMessageProcessor;
        }
        throw new IllegalArgumentException("bad transport");
    }

    protected void setMessageFactory(StackMessageFactory messageFactory) {
        this.sipMessageFactory = messageFactory;
    }

    public MessageChannel createRawMessageChannel(int sourcePort, Hop nextHop) throws UnknownHostException {
        Host targetHost = new Host();
        targetHost.setHostname(nextHop.getHost());
        HostPort targetHostPort = new HostPort();
        targetHostPort.setHost(targetHost);
        targetHostPort.setPort(nextHop.getPort());
        MessageChannel newChannel = null;
        Iterator processorIterator = this.messageProcessors.iterator();
        while (processorIterator.hasNext() && newChannel == null) {
            MessageProcessor nextProcessor = (MessageProcessor)processorIterator.next();
            if (!nextHop.getTransport().equalsIgnoreCase(nextProcessor.getTransport()) || sourcePort != nextProcessor.getPort()) continue;
            try {
                newChannel = nextProcessor.createMessageChannel(targetHostPort);
            }
            catch (UnknownHostException ex) {
                if (this.logWriter.isLoggingEnabled()) {
                    this.logWriter.logException(ex);
                }
                throw ex;
            }
            catch (IOException e) {
                if (!this.logWriter.isLoggingEnabled()) continue;
                this.logWriter.logException(e);
            }
        }
        return newChannel;
    }

    public boolean isEventForked(String ename) {
        if (this.logWriter.isLoggingEnabled()) {
            this.logWriter.logDebug("isEventForked: " + ename + " returning " + this.forkedEvents.contains(ename));
        }
        return this.forkedEvents.contains(ename);
    }

    public AddressResolver getAddressResolver() {
        return this.addressResolver;
    }

    public void setAddressResolver(AddressResolver addressResolver) {
        this.addressResolver = addressResolver;
    }
}

