/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.LogWriter;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.MessageLog;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Properties;
import javax.sip.header.TimeStampHeader;

public class ServerLog {
    private boolean logContent;
    protected LogWriter logWriter;
    public static final int TRACE_NONE = 0;
    public static final int TRACE_MESSAGES = 16;
    public static final int TRACE_EXCEPTION = 17;
    public static final int TRACE_DEBUG = 32;
    private String logFileName;
    protected PrintWriter printWriter;
    protected PrintStream traceWriter = System.out;
    protected String auxInfo;
    protected String description;
    protected String stackIpAddress;
    private SIPTransactionStack sipStack;
    private Properties configurationProperties;
    private PrintStream trace = System.out;
    protected int traceLevel = 16;

    public ServerLog(SIPTransactionStack sipStack, Properties configurationProperties) {
        this.logWriter = sipStack.logWriter;
        this.sipStack = sipStack;
        this.setProperties(configurationProperties);
    }

    private void setProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
        this.description = configurationProperties.getProperty("javax.sip.STACK_NAME");
        this.stackIpAddress = configurationProperties.getProperty("javax.sip.IP_ADDRESS");
        this.logFileName = configurationProperties.getProperty("gov.nist.javax.sip.SERVER_LOG");
        String logLevel = configurationProperties.getProperty("gov.nist.javax.sip.TRACE_LEVEL");
        if (logLevel != null) {
            try {
                int ll = logLevel.equals("DEBUG") ? 32 : (logLevel.equals("TRACE") ? 16 : (logLevel.equals("ERROR") ? 17 : (logLevel.equals("NONE") ? 0 : Integer.parseInt(logLevel))));
                this.setTraceLevel(ll);
            }
            catch (NumberFormatException ex) {
                System.out.println("ServerLog: WARNING Bad integer " + logLevel);
                System.out.println("logging dislabled ");
                this.setTraceLevel(0);
            }
        }
        this.checkLogFile();
    }

    public void setStackIpAddress(String ipAddress) {
        this.stackIpAddress = ipAddress;
    }

    public void checkLogFile() {
        if (this.logFileName == null || this.traceLevel < 16) {
            return;
        }
        try {
            File logFile = new File(this.logFileName);
            if (!logFile.exists()) {
                logFile.createNewFile();
                this.printWriter = null;
            }
            if (this.printWriter == null) {
                String s = this.configurationProperties.getProperty("gov.nist.javax.sip.LOG_MESSAGE_CONTENT");
                this.logContent = s != null && s.equals("true");
                FileWriter fw = new FileWriter(this.logFileName, true);
                this.printWriter = new PrintWriter((Writer)fw, true);
                this.printWriter.println("<!-- Use the  Trace Viewer in src/tools/tracesviewer to view this  trace  \nHere are the stack configuration properties \njavax.sip.IP_ADDRESS= " + this.configurationProperties.getProperty("javax.sip.IP_ADDRESS") + "\n" + "javax.sip.STACK_NAME= " + this.configurationProperties.getProperty("javax.sip.STACK_NAME") + "\n" + "javax.sip.ROUTER_PATH= " + this.configurationProperties.getProperty("javax.sip.ROUTER_PATH") + "\n" + "javax.sip.OUTBOUND_PROXY= " + this.configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY") + "\n" + "-->");
                if (this.auxInfo != null) {
                    this.printWriter.println("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\"\n auxInfo=\"" + this.auxInfo + "\"/>\n ");
                    if (this.sipStack.isLoggingEnabled()) {
                        this.logWriter.logDebug("Here are the stack configuration properties \njavax.sip.IP_ADDRESS= " + this.configurationProperties.getProperty("javax.sip.IP_ADDRESS") + "\n" + "javax.sip.ROUTER_PATH= " + this.configurationProperties.getProperty("javax.sip.ROUTER_PATH") + "\n" + "javax.sip.OUTBOUND_PROXY= " + this.configurationProperties.getProperty("javax.sip.OUTBOUND_PROXY") + "\n" + "gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS= " + this.configurationProperties.getProperty("gov.nist.javax.sip.CACHE_CLIENT_CONNECTIONS") + "\n" + "gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS= " + this.configurationProperties.getProperty("gov.nist.javax.sip.CACHE_SERVER_CONNECTIONS") + "\n" + "gov.nist.javax.sip.REENTRANT_LISTENER= " + this.configurationProperties.getProperty("gov.nist.javax.sip.REENTRANT_LISTENER") + "gov.nist.javax.sip.THREAD_POOL_SIZE= " + this.configurationProperties.getProperty("gov.nist.javax.sip.THREAD_POOL_SIZE") + "\n");
                        this.logWriter.logDebug(" ]]> ");
                        this.logWriter.logDebug("</debug>");
                        this.logWriter.logDebug("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\"\n auxInfo=\"" + this.auxInfo + "\"/>\n ");
                        this.logWriter.logDebug("<debug>");
                        this.logWriter.logDebug("<![CDATA[ ");
                    }
                } else {
                    this.printWriter.println("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\" />\n");
                    if (this.sipStack.isLoggingEnabled()) {
                        this.logWriter.logDebug("Here are the stack configuration properties \n" + this.configurationProperties + "\n");
                        this.logWriter.logDebug(" ]]>");
                        this.logWriter.logDebug("</debug>");
                        this.logWriter.logDebug("<description\n logDescription=\"" + this.description + "\"\n name=\"" + this.stackIpAddress + "\" />\n");
                        this.logWriter.logDebug("<debug>");
                        this.logWriter.logDebug("<![CDATA[ ");
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean needsLogging(int logLevel) {
        return this.traceLevel >= logLevel;
    }

    public boolean needsLogging() {
        return this.logFileName != null;
    }

    public void setLogFileName(String name) {
        this.logFileName = name;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    private void logMessage(String message) {
        this.checkLogFile();
        String logInfo = message;
        if (this.printWriter == null) {
            System.out.println(logInfo);
        } else {
            this.printWriter.println(logInfo);
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.logWriter.logDebug(" ]]>");
            this.logWriter.logDebug("</debug>");
            this.logWriter.logDebug(logInfo);
            this.logWriter.logDebug("<debug>");
            this.logWriter.logDebug("<![CDATA[ ");
        }
    }

    private synchronized void logMessage(String message, String from, String to, boolean sender, String callId, String firstLine, String status, String tid, String time, long timeStampHeaderValue) {
        MessageLog log = new MessageLog(message, from, to, time, sender, firstLine, status, tid, callId, this.logWriter.getLineCount(), timeStampHeaderValue);
        this.logMessage(log.flush());
    }

    private synchronized void logMessage(String message, String from, String to, boolean sender, String callId, String firstLine, String status, String tid, long time, long timestampVal) {
        MessageLog log = new MessageLog(message, from, to, time, sender, firstLine, status, tid, callId, this.logWriter.getLineCount(), timestampVal);
        this.logMessage(log.flush());
    }

    public void logMessage(SIPMessage message, String from, String to, boolean sender, String time) {
        this.checkLogFile();
        CallID cid = (CallID)message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = ((CallID)message.getCallId()).getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String inputText = this.logContent ? message.encode() : message.encodeMessage();
        String tid = message.getTransactionId();
        TimeStamp timestamp = (TimeStamp)message.getHeader("Timestamp");
        long tsval = timestamp != null ? timestamp.getTime() : 0L;
        this.logMessage(inputText, from, to, sender, callId, firstLine, null, tid, time, tsval);
    }

    public void logMessage(SIPMessage message, String from, String to, boolean sender, long time) {
        this.checkLogFile();
        CallID cid = (CallID)message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String inputText = this.logContent ? message.encode() : message.encodeMessage();
        String tid = message.getTransactionId();
        TimeStampHeader tsHdr = (TimeStampHeader)message.getHeader("Timestamp");
        long tsval = tsHdr == null ? 0L : tsHdr.getTime();
        this.logMessage(inputText, from, to, sender, callId, firstLine, null, tid, time, tsval);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender, String time) {
        this.checkLogFile();
        CallID cid = (CallID)message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String encoded = this.logContent ? message.encode() : message.encodeMessage();
        String tid = message.getTransactionId();
        TimeStampHeader tsHeader = (TimeStampHeader)message.getHeader("Timestamp");
        long tsVal = 0L;
        if (tsHeader != null) {
            tsVal = tsHeader.getTime();
        }
        this.logMessage(encoded, from, to, sender, callId, firstLine, status, tid, time, tsVal);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender, long time) {
        this.checkLogFile();
        CallID cid = (CallID)message.getCallId();
        String callId = null;
        if (cid != null) {
            callId = cid.getCallId();
        }
        String firstLine = message.getFirstLine().trim();
        String encoded = this.logContent ? message.encode() : message.encodeMessage();
        String tid = message.getTransactionId();
        TimeStampHeader tshdr = (TimeStampHeader)message.getHeader("Timestamp");
        long tsval = tshdr == null ? 0L : tshdr.getTime();
        this.logMessage(encoded, from, to, sender, callId, firstLine, status, tid, time, tsval);
    }

    public void logMessage(SIPMessage message, String from, String to, String status, boolean sender) {
        this.logMessage(message, from, to, status, sender, System.currentTimeMillis());
    }

    public void traceMsg(int msgLevel, String tracemsg) {
        if (this.needsLogging(msgLevel)) {
            this.traceWriter.println(tracemsg);
            this.logMessage(tracemsg);
        }
    }

    public void logException(Exception ex) {
        if (this.traceLevel >= 17) {
            this.checkLogFile();
            ex.printStackTrace();
            if (this.printWriter != null) {
                ex.printStackTrace(this.printWriter);
            }
        }
    }

    public void println(String s) {
        if (this.traceLevel == 32) {
            System.out.println(s);
        }
    }

    public void setTraceLevel(int level) {
        this.traceLevel = level;
    }

    public int getTraceLevel() {
        return this.traceLevel;
    }

    public void setAuxInfo(String auxInfo) {
        this.auxInfo = auxInfo;
    }
}

