/*
 * Decompiled with CFR 0.152.
 */
package tools.tracesviewer;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.Enumeration;
import java.util.Hashtable;
import tools.tracesviewer.PercentLayoutConstraint;

public class PercentLayout
implements LayoutManager2 {
    private Hashtable hash = new Hashtable();

    public void addLayoutComponent(Component component, Object object) {
        if (!(object instanceof PercentLayoutConstraint)) {
            throw new IllegalArgumentException("Invalid constraint");
        }
        this.hash.put(component, object);
    }

    public void addLayoutComponent(String string, Component component) {
        throw new IllegalArgumentException("Invalid constraint");
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            PercentLayoutConstraint percentLayoutConstraint = (PercentLayoutConstraint)this.hash.get(component);
            Dimension dimension = component.getPreferredSize();
            n = (int)((double)n + (double)(dimension.width * 100) / percentLayoutConstraint.width);
            n2 = (int)((double)n2 + (double)(dimension.height * 100) / percentLayoutConstraint.height);
        }
        int n3 = this.hash.size();
        return new Dimension(n / n3, n2 / n3);
    }

    public Dimension minimumLayoutSize(Container container) {
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            PercentLayoutConstraint percentLayoutConstraint = (PercentLayoutConstraint)this.hash.get(component);
            Dimension dimension = component.getMinimumSize();
            int n3 = (int)((double)(dimension.width * 100) / percentLayoutConstraint.width);
            int n4 = (int)((double)(dimension.height * 100) / percentLayoutConstraint.height);
            if (n3 > n) {
                n = n3;
            }
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return new Dimension(n, n2);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            int n3;
            Component component = (Component)enumeration.nextElement();
            PercentLayoutConstraint percentLayoutConstraint = (PercentLayoutConstraint)this.hash.get(component);
            Dimension dimension = component.getMaximumSize();
            int n4 = dimension.width == Integer.MAX_VALUE ? dimension.width : (int)((double)(dimension.width * 100) / percentLayoutConstraint.width);
            int n5 = n3 = dimension.height == Integer.MAX_VALUE ? dimension.height : (int)((double)(dimension.height * 100) / percentLayoutConstraint.height);
            if (n4 < n) {
                n = n4;
            }
            if (n3 >= n2) continue;
            n2 = n3;
        }
        return new Dimension(n, n2);
    }

    public void layoutContainer(Container container) {
        Dimension dimension = container.getSize();
        Enumeration enumeration = this.hash.keys();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            PercentLayoutConstraint percentLayoutConstraint = (PercentLayoutConstraint)this.hash.get(component);
            int n = (int)((double)dimension.width * percentLayoutConstraint.x / 100.0);
            int n2 = (int)((double)dimension.height * percentLayoutConstraint.y / 100.0);
            int n3 = (int)((double)dimension.width * percentLayoutConstraint.width / 100.0);
            int n4 = (int)((double)dimension.height * percentLayoutConstraint.height / 100.0);
            component.setBounds(n, n2, n3, n4);
        }
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }
}

