/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class DropTable
extends SchemaCommand {
    private boolean ifExists;
    private String tableName;
    private Table table;
    private DropTable next;

    public DropTable(Session session, Schema schema) {
        super(session, schema);
    }

    public void addNextDropTable(DropTable next) {
        if (this.next == null) {
            this.next = next;
        } else {
            this.next.addNextDropTable(next);
        }
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
        if (this.next != null) {
            this.next.setIfExists(b);
        }
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private void prepareDrop() throws SQLException {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(42102, this.tableName);
            }
        } else {
            this.session.getUser().checkRight(this.table, 15);
            if (!this.table.canDrop()) {
                throw Message.getSQLException(90118, this.tableName);
            }
            this.table.lock(this.session, true);
        }
        if (this.next != null) {
            this.next.prepareDrop();
        }
    }

    private void executeDrop() throws SQLException {
        this.table = this.getSchema().findTableOrView(this.session, this.tableName);
        if (this.table != null) {
            this.table.setModified();
            Database db = this.session.getDatabase();
            db.removeSchemaObject(this.session, this.table);
        }
        if (this.next != null) {
            this.next.executeDrop();
        }
    }

    public int update() throws SQLException {
        this.session.commit();
        this.prepareDrop();
        this.executeDrop();
        return 0;
    }
}

