/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.table.Table;

public class SetComment
extends DefineCommand {
    private String schemaName;
    private String objectName;
    private boolean column;
    private String columnName;
    private int objectType;
    private Expression expr;

    public SetComment(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        this.session.getUser().checkAdmin();
        DbObject object = null;
        int errorCode = 50000;
        if (this.schemaName == null) {
            this.schemaName = "PUBLIC";
        }
        Schema schema = db.findSchema(this.schemaName);
        switch (this.objectType) {
            case 11: {
                object = schema.getConstant(this.session, this.objectName);
                break;
            }
            case 5: {
                object = schema.getConstraint(this.objectName);
                break;
            }
            case 9: {
                object = db.findFunctionAlias(this.objectName);
                errorCode = 90077;
                break;
            }
            case 1: {
                object = schema.getIndex(this.objectName);
                break;
            }
            case 7: {
                object = db.findRole(this.objectName);
                errorCode = 90070;
                break;
            }
            case 10: {
                object = db.findSchema(this.objectName);
                errorCode = 90079;
                break;
            }
            case 3: {
                object = schema.getSequence(this.objectName);
                break;
            }
            case 0: {
                object = schema.getTableOrView(this.session, this.objectName);
                break;
            }
            case 4: {
                object = schema.findTrigger(this.objectName);
                errorCode = 90042;
                break;
            }
            case 2: {
                object = db.getUser(this.objectName);
                break;
            }
            case 12: {
                object = db.findUserDataType(this.objectName);
                errorCode = 90119;
            }
        }
        if (object == null) {
            throw Message.getSQLException(errorCode, this.objectName);
        }
        String fullName = Parser.quoteIdentifier(this.schemaName);
        fullName = fullName + "." + Parser.quoteIdentifier(this.objectName);
        if (this.column) {
            fullName = fullName + "." + Parser.quoteIdentifier(this.columnName);
        }
        String text = this.expr.getValue(this.session).getString();
        String key = Comment.getKey(this.objectType, this.column, fullName);
        Comment comment = db.findComment(key);
        if (this.column) {
            Table table = (Table)object;
            table.getColumn(this.columnName).setComment(text);
        } else {
            object.setComment(text);
        }
        if (comment == null) {
            if (text != null) {
                int id = this.getObjectId(false, false);
                comment = new Comment(db, id, this.objectType, this.column, fullName);
                comment.setCommentText(text);
                db.addDatabaseObject(this.session, comment);
            }
        } else if (text == null) {
            db.removeDatabaseObject(this.session, comment);
        } else {
            comment.setCommentText(text);
            db.update(this.session, comment);
        }
        return 0;
    }

    public void setCommentExpression(Expression expr) {
        this.expr = expr;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void setObjectType(int objectType) {
        this.objectType = objectType;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public void setColumn(boolean column) {
        this.column = column;
    }
}

