/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.h2.api.DatabaseEventListener;
import org.h2.command.dml.Set;
import org.h2.engine.Comment;
import org.h2.engine.ConnectionInfo;
import org.h2.engine.Constants;
import org.h2.engine.DatabaseCloser;
import org.h2.engine.DbObject;
import org.h2.engine.Engine;
import org.h2.engine.FunctionAlias;
import org.h2.engine.MetaRecord;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserDataType;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.message.TraceSystem;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.schema.Sequence;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.FileLock;
import org.h2.store.FileStore;
import org.h2.store.LogSystem;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.store.WriterThread;
import org.h2.table.Column;
import org.h2.table.MetaTable;
import org.h2.table.Table;
import org.h2.table.TableData;
import org.h2.table.TableView;
import org.h2.tools.DeleteDbFiles;
import org.h2.util.BitField;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MemoryFile;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.h2.value.ValueInt;

public class Database
implements DataHandler {
    private boolean textStorage;
    private String databaseName;
    private String databaseShortName;
    private String databaseURL;
    private HashMap roles = new HashMap();
    private HashMap users = new HashMap();
    private HashMap settings = new HashMap();
    private HashMap schemas = new HashMap();
    private HashMap rights = new HashMap();
    private HashMap functionAliases = new HashMap();
    private HashMap userDataTypes = new HashMap();
    private HashMap comments = new HashMap();
    private Schema mainSchema;
    private Schema infoSchema;
    private int nextSessionId;
    private HashSet sessions = new HashSet();
    private User systemUser;
    private Session systemSession;
    private TableData meta;
    private Index metaIdIndex;
    private BitField objectIds = new BitField();
    private FileLock lock;
    private LogSystem log;
    private WriterThread writer;
    private ObjectArray storages = new ObjectArray();
    private boolean starting;
    private DiskFile fileData;
    private DiskFile fileIndex;
    private TraceSystem traceSystem;
    private boolean persistent;
    private String cipher;
    private byte[] filePasswordHash;
    private DataPage dummy;
    private int fileLockMethod;
    private Role publicRole;
    private long modificationDataId;
    private long modificationMetaId;
    private CompareMode compareMode;
    private String cluster = "''";
    private boolean readOnly;
    private boolean noDiskSpace;
    private int writeDelay = 500;
    private DatabaseEventListener eventListener;
    private FileStore emergencyReserve;
    private int maxMemoryRows = 10000;
    private int maxMemoryUndo = Integer.MAX_VALUE;
    private int lockMode = 1;
    private boolean logIndexChanges;
    private int logLevel = 1;
    private int cacheSize;
    private int maxLengthInplaceLob = 128;
    private long biggestFileSize;
    private int allowLiterals = 2;
    private static int initialPowerOffCount = 0;
    private int powerOffCount = initialPowerOffCount;
    private int closeDelay;
    private DatabaseCloser delayedCloser;
    private boolean recovery;
    private volatile boolean closing;
    private boolean ignoreCase;
    private boolean deleteFilesOnDisconnect;
    private String lobCompressionAlgorithm;
    public static int testEqual = 0;
    public static int testCompare = 0;

    public static void setInitialPowerOffCount(int count) {
        initialPowerOffCount = count;
    }

    public void setPowerOffCount(int count) {
        if (this.powerOffCount == -1) {
            return;
        }
        this.powerOffCount = count;
    }

    public boolean getTextStorage() {
        return this.textStorage;
    }

    public static boolean isTextStorage(String fileName, boolean defaultValue) throws SQLException {
        byte[] magicText = Constants.MAGIC_FILE_HEADER_TEXT.getBytes();
        byte[] magicBinary = Constants.MAGIC_FILE_HEADER.getBytes();
        try {
            byte[] magic;
            if (FileUtils.isInMemory(fileName)) {
                MemoryFile file = FileUtils.getMemoryFile(fileName);
                magic = file.getMagic();
            } else {
                FileInputStream fin = new FileInputStream(fileName);
                magic = IOUtils.readBytesAndClose(fin, magicBinary.length);
            }
            if (ByteUtils.compareNotNull(magic, magicText) == 0) {
                return true;
            }
            if (ByteUtils.compareNotNull(magic, magicBinary) == 0) {
                return false;
            }
            if (magic.length < magicText.length) {
                return defaultValue;
            }
            throw Message.getSQLException(90048, fileName);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static byte[] getMagic(boolean textStorage) {
        if (textStorage) {
            return Constants.MAGIC_FILE_HEADER_TEXT.getBytes();
        }
        return Constants.MAGIC_FILE_HEADER.getBytes();
    }

    public byte[] getMagic() {
        return Database.getMagic(this.textStorage);
    }

    public boolean areEqual(Value a, Value b) throws SQLException {
        return a.compareTo(b, this.compareMode) == 0;
    }

    public int compare(Value a, Value b) throws SQLException {
        return a.compareTo(b, this.compareMode);
    }

    public int compareTypeSave(Value a, Value b) throws SQLException {
        return a.compareTypeSave(b, this.compareMode);
    }

    public long getModificationDataId() {
        return this.modificationDataId;
    }

    public long getNextModificationDataId() {
        return this.modificationDataId++;
    }

    public long getModificationMetaId() {
        return this.modificationMetaId;
    }

    public long getNextModificationMetaId() {
        return this.modificationMetaId++;
    }

    public int getPowerOffCount() {
        return this.powerOffCount;
    }

    public void checkPowerOff() throws SQLException {
        if (this.powerOffCount == 0) {
            return;
        }
        if (this.powerOffCount > 1) {
            --this.powerOffCount;
            return;
        }
        if (this.powerOffCount != -1) {
            try {
                this.powerOffCount = -1;
                if (this.log != null) {
                    try {
                        this.stopWriter();
                        this.log.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.log = null;
                }
                if (this.fileData != null) {
                    try {
                        this.fileData.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.fileData = null;
                }
                if (this.fileIndex != null) {
                    try {
                        this.fileIndex.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    this.fileIndex = null;
                }
                if (this.lock != null) {
                    this.lock.unlock();
                    this.lock = null;
                }
                if (this.emergencyReserve != null) {
                    this.emergencyReserve.close();
                    this.emergencyReserve = null;
                }
            }
            catch (Exception e) {
                TraceSystem.traceThrowable(e);
            }
        }
        Engine.getInstance().close(this.databaseName);
        throw Message.getSQLException(90098);
    }

    public static boolean exists(String name) {
        return FileUtils.exists(name + ".data.db");
    }

    public Trace getTrace(String module) {
        return this.traceSystem.getTrace(module);
    }

    public FileStore openFile(String name, boolean mustExist) throws SQLException {
        return this.openFile(name, false, mustExist);
    }

    public FileStore openFile(String name, boolean notEncrypted, boolean mustExist) throws SQLException {
        byte[] h;
        String c = notEncrypted ? null : this.cipher;
        byte[] byArray = h = notEncrypted ? null : this.filePasswordHash;
        if (mustExist && !FileUtils.exists(name)) {
            throw Message.getSQLException(90030, name);
        }
        FileStore store = FileStore.open(this, name, this.getMagic(), c, h);
        try {
            store.init();
        }
        catch (SQLException e) {
            try {
                store.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw e;
        }
        return store;
    }

    public void checkFilePasswordHash(String c, byte[] hash) throws JdbcSQLException {
        if (!ByteUtils.compareSecure(hash, this.filePasswordHash) || !StringUtils.equals(c, this.cipher)) {
            throw Message.getSQLException(8004);
        }
    }

    private void openFileData() throws SQLException {
        this.fileData = new DiskFile(this, this.databaseName + ".data.db", true, true, 32768);
    }

    private void openFileIndex() throws SQLException {
        this.fileIndex = new DiskFile(this, this.databaseName + ".index.db", false, this.logIndexChanges, 4096);
    }

    public DataPage getDataPage() {
        return this.dummy;
    }

    private String parseDatabaseShortName() {
        String n = this.databaseName;
        if (n.endsWith(":")) {
            n = null;
        }
        if (n != null) {
            StringTokenizer tokenizer = new StringTokenizer(n, "/\\:,;");
            while (tokenizer.hasMoreTokens()) {
                n = tokenizer.nextToken();
            }
        }
        if (n == null || n.length() == 0) {
            n = "UNNAMED";
        }
        return n.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database(String name, ConnectionInfo ci, String cipher) throws SQLException {
        String ignoreSummary;
        String log;
        this.compareMode = new CompareMode(null, null);
        this.persistent = ci.isPersistent();
        this.filePasswordHash = ci.getFilePasswordHash();
        this.databaseName = name;
        this.databaseShortName = this.parseDatabaseShortName();
        this.cipher = cipher;
        this.fileLockMethod = ci.getFileLockMethod();
        this.textStorage = ci.getTextStorage();
        this.databaseURL = ci.getURL();
        String listener = ci.removeProperty("DATABASE_EVENT_LISTENER", null);
        if (listener != null) {
            if (listener.length() > 2 && listener.startsWith("'")) {
                listener = listener.substring(1, listener.length() - 1);
            }
            this.setEventListener(listener);
        }
        if ((log = ci.getProperty(20, null)) != null) {
            this.logIndexChanges = log.equals("2");
        }
        if ((ignoreSummary = ci.getProperty("RECOVER", null)) != null) {
            this.recovery = true;
        }
        boolean closeAtVmShutdown = ci.removeProperty("DB_CLOSE_ON_EXIT", true);
        int traceLevelFile = ci.getIntProperty(10, 1);
        int traceLevelSystemOut = ci.getIntProperty(9, 0);
        try {
            Database database = this;
            synchronized (database) {
                this.open(traceLevelFile, traceLevelSystemOut);
            }
            if (closeAtVmShutdown) {
                DatabaseCloser closeOnExit = new DatabaseCloser(this, 0, true);
                try {
                    Runtime.getRuntime().addShutdownHook(closeOnExit);
                }
                catch (IllegalStateException e) {}
            }
        }
        catch (SQLException e) {
            if (this.traceSystem != null) {
                this.traceSystem.getTrace("database").error("opening " + this.databaseName, e);
            }
            Database database = this;
            synchronized (database) {
                this.closeOpenFilesAndUnlock();
            }
            throw Message.convert(e);
        }
    }

    private void open(int traceLevelFile, int traceLevelSystemOut) throws SQLException {
        String dataFileName;
        if (this.persistent && FileUtils.exists(dataFileName = this.databaseName + ".data.db")) {
            this.readOnly = FileUtils.isReadOnly(dataFileName);
            this.textStorage = Database.isTextStorage(dataFileName, this.textStorage);
        }
        this.dummy = DataPage.create((DataHandler)this, 0);
        if (this.persistent) {
            this.traceSystem = this.readOnly || FileUtils.isInMemory(this.databaseName) ? new TraceSystem(null) : new TraceSystem(this.databaseName + ".trace.db");
            this.traceSystem.setLevelFile(traceLevelFile);
            this.traceSystem.setLevelSystemOut(traceLevelSystemOut);
            this.traceSystem.getTrace("database").info("opening " + this.databaseName + " (build " + 30 + ")");
            if (!this.readOnly && this.fileLockMethod != 0) {
                this.lock = new FileLock(this.traceSystem, 1000);
                this.lock.lock(this.databaseName + ".lock.db", this.fileLockMethod == 2);
            }
            this.deleteOldTempFiles();
            this.log = new LogSystem(this, this.databaseName, this.readOnly);
            this.openFileData();
            this.openFileIndex();
            if (!this.readOnly) {
                this.log.recover();
            }
            this.fileData.init();
            this.fileIndex.init();
            this.reserveLobFileObjectIds();
            this.writer = WriterThread.create(this, this.writeDelay);
        } else {
            this.traceSystem = new TraceSystem(null);
            this.log = new LogSystem(null, null, false);
        }
        this.systemUser = new User(this, 0, "DBA", true);
        this.mainSchema = new Schema(this, 0, "PUBLIC", this.systemUser, true);
        this.infoSchema = new Schema(this, 0, "INFORMATION_SCHEMA", this.systemUser, true);
        this.schemas.put(this.mainSchema.getName(), this.mainSchema);
        this.schemas.put(this.infoSchema.getName(), this.infoSchema);
        this.publicRole = new Role(this, 0, "PUBLIC", true);
        this.roles.put("PUBLIC", this.publicRole);
        this.systemUser.setAdmin(true);
        this.systemSession = new Session(this, this.systemUser, 0);
        ObjectArray cols = new ObjectArray();
        Column columnId = new Column("ID", 4, 0L, 0);
        columnId.setNullable(false);
        cols.add(columnId);
        cols.add(new Column("HEAD", 4, 0L, 0));
        cols.add(new Column("TYPE", 4, 0L, 0));
        cols.add(new Column("SQL", 13, 0L, 0));
        this.meta = new TableData(this.mainSchema, "SYS", 0, cols, this.persistent);
        this.metaIdIndex = this.meta.addIndex(this.systemSession, "SYS_ID", 0, new Column[]{columnId}, IndexType.createPrimaryKey(false, false), -1);
        this.objectIds.set(0);
        this.addMetaData(0);
        this.addMetaData(1);
        this.addMetaData(2);
        this.addMetaData(3);
        this.addMetaData(4);
        this.addMetaData(5);
        this.addMetaData(6);
        this.addMetaData(7);
        this.addMetaData(8);
        this.addMetaData(9);
        this.addMetaData(10);
        this.addMetaData(11);
        this.addMetaData(12);
        this.addMetaData(13);
        this.addMetaData(14);
        this.addMetaData(15);
        this.addMetaData(16);
        this.addMetaData(17);
        this.addMetaData(18);
        this.addMetaData(19);
        this.addMetaData(20);
        this.addMetaData(21);
        this.addMetaData(22);
        this.addMetaData(23);
        this.addMetaData(24);
        this.starting = true;
        Cursor cursor = this.metaIdIndex.find(this.systemSession, null, null);
        ObjectArray records = new ObjectArray();
        while (cursor.next()) {
            MetaRecord rec = new MetaRecord(cursor.get());
            this.objectIds.set(rec.getId());
            records.add(rec);
        }
        records.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                int c2;
                MetaRecord m1 = (MetaRecord)o1;
                MetaRecord m2 = (MetaRecord)o2;
                int c1 = DbObject.getCreateOrder(m1.getObjectType());
                if (c1 != (c2 = DbObject.getCreateOrder(m2.getObjectType()))) {
                    return c1 - c2;
                }
                return m1.getId() - m2.getId();
            }
        });
        for (int i = 0; i < records.size(); ++i) {
            MetaRecord rec = (MetaRecord)records.get(i);
            rec.execute(this, this.systemSession, this.eventListener);
        }
        this.recompileInvalidViews();
        this.starting = false;
        this.addDefaultSetting(6, null, 1000);
        this.addDefaultSetting(7, null, 0);
        this.addDefaultSetting(10, null, this.traceSystem.getLevelFile());
        this.addDefaultSetting(9, null, this.traceSystem.getLevelSystemOut());
        this.addDefaultSetting(8, null, 32768);
        this.addDefaultSetting(13, "''", 0);
        this.addDefaultSetting(14, null, 500);
        this.removeUnusedStorages();
        this.systemSession.commit();
        if (!this.readOnly) {
            this.emergencyReserve = this.openFile(this.createTempFile(), true);
            this.emergencyReserve.setLength(0x100000L);
        }
        this.traceSystem.getTrace("database").info("opened " + this.databaseName);
    }

    private void recompileInvalidViews() {
        boolean recompileSuccessful;
        do {
            recompileSuccessful = false;
            ObjectArray list = this.getAllSchemaObjects(0);
            for (int i = 0; i < list.size(); ++i) {
                TableView view;
                DbObject obj = (DbObject)list.get(i);
                if (!(obj instanceof TableView) || !(view = (TableView)obj).getInvalid()) continue;
                try {
                    view.recompile(this.systemSession);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (view.getInvalid()) continue;
                recompileSuccessful = true;
            }
        } while (recompileSuccessful);
    }

    private void removeUnusedStorages() throws SQLException {
        if (this.persistent) {
            for (int i = 0; i < this.storages.size(); ++i) {
                Storage storage = (Storage)this.storages.get(i);
                if (storage == null || storage.getRecordReader() != null) continue;
                storage.delete(this.systemSession);
            }
        }
    }

    private void addDefaultSetting(int type, String stringValue, int intValue) throws SQLException {
        if (this.readOnly) {
            return;
        }
        String name = Set.getTypeName(type);
        if (this.settings.get(name) == null) {
            Setting setting = new Setting(this, this.allocateObjectId(false, true), name);
            if (stringValue == null) {
                setting.setIntValue(intValue);
            } else {
                setting.setStringValue(stringValue);
            }
            this.addDatabaseObject(this.systemSession, setting);
        }
    }

    public void removeStorage(int id, DiskFile file) {
        Storage s;
        if (Constants.CHECK && ((s = (Storage)this.storages.get(id)) == null || s.getDiskFile() != file)) {
            throw Message.internal();
        }
        this.storages.set(id, null);
    }

    public Storage getStorage(int id, DiskFile file) {
        Storage storage = null;
        if (this.storages.size() > id && (storage = (Storage)this.storages.get(id)) != null && Constants.CHECK && storage != null && storage.getDiskFile() != file) {
            throw Message.internal();
        }
        if (storage == null) {
            storage = new Storage(this, file, null, id);
            while (this.storages.size() <= id) {
                this.storages.add(null);
            }
            this.storages.set(id, storage);
        }
        return storage;
    }

    private void addMetaData(int type) throws SQLException {
        MetaTable m = new MetaTable(this.infoSchema, type);
        this.infoSchema.add(m);
    }

    private void addMeta(Session session, DbObject obj) throws SQLException {
        if (obj.getTemporary()) {
            return;
        }
        Row r = this.meta.getTemplateRow();
        MetaRecord rec = new MetaRecord(obj);
        rec.setRecord(r);
        this.objectIds.set(obj.getId());
        this.meta.lock(session, true);
        this.meta.addRow(session, r);
    }

    private void removeMeta(Session session, int id) throws SQLException {
        Row r = this.meta.getTemplateRow();
        r.setValue(0, ValueInt.get(id));
        Cursor cursor = this.metaIdIndex.find(session, r, r);
        cursor.next();
        r = cursor.get();
        if (r != null) {
            this.meta.lock(session, true);
            this.meta.removeRow(session, r);
            this.objectIds.clear(id);
            if (Constants.CHECK) {
                this.checkMetaFree(id);
            }
        }
    }

    private HashMap getMap(int type) {
        switch (type) {
            case 2: {
                return this.users;
            }
            case 6: {
                return this.settings;
            }
            case 7: {
                return this.roles;
            }
            case 8: {
                return this.rights;
            }
            case 9: {
                return this.functionAliases;
            }
            case 10: {
                return this.schemas;
            }
            case 12: {
                return this.userDataTypes;
            }
            case 13: {
                return this.comments;
            }
        }
        throw Message.internal("type=" + type);
    }

    public void addSchemaObject(Session session, SchemaObject obj) throws SQLException {
        obj.getSchema().add(obj);
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.addMeta(session, obj);
        }
    }

    public void addDatabaseObject(Session session, DbObject obj) throws SQLException {
        User user;
        HashMap map = this.getMap(obj.getType());
        if (obj.getType() == 2 && (user = (User)obj).getAdmin() && this.systemUser.getName().equals("DBA")) {
            this.systemUser.rename(user.getName());
        }
        String name = obj.getName();
        if (Constants.CHECK && map.get(name) != null) {
            throw Message.internal("object already exists");
        }
        int id = obj.getId();
        if (id > 0 && !this.starting) {
            this.addMeta(session, obj);
        }
        map.put(name, obj);
    }

    public Setting findSetting(String name) {
        return (Setting)this.settings.get(name);
    }

    public Comment findComment(String name) {
        return (Comment)this.comments.get(name);
    }

    public User findUser(String name) {
        return (User)this.users.get(name);
    }

    public FunctionAlias findFunctionAlias(String name) {
        return (FunctionAlias)this.functionAliases.get(name);
    }

    public UserDataType findUserDataType(String name) {
        return (UserDataType)this.userDataTypes.get(name);
    }

    public User getUser(String name) throws SQLException {
        User user = (User)this.users.get(name);
        if (user == null) {
            throw Message.getSQLException(8004, name);
        }
        return user;
    }

    public synchronized Session createSession(User user) {
        Session session = new Session(this, user, this.nextSessionId++);
        this.sessions.add(session);
        this.traceSystem.getTrace("session").info("connecting #" + session.getId() + " to " + this.databaseName);
        if (this.delayedCloser != null) {
            this.delayedCloser.reset();
            this.delayedCloser = null;
        }
        return session;
    }

    public synchronized void removeSession(Session session) throws SQLException {
        if (session != null) {
            this.sessions.remove(session);
            if (session != this.systemSession) {
                this.traceSystem.getTrace("session").info("disconnecting #" + session.getId());
            }
        }
        if (this.sessions.size() == 0 && session != this.systemSession) {
            if (this.closeDelay == 0) {
                this.close(false);
            } else {
                if (this.closeDelay < 0) {
                    return;
                }
                this.delayedCloser = new DatabaseCloser(this, this.closeDelay * 1000, false);
                this.delayedCloser.setName("H2 Close Delay " + this.getShortName());
                this.delayedCloser.setDaemon(true);
                this.delayedCloser.start();
            }
        }
        if (session != this.systemSession && session != null) {
            this.traceSystem.getTrace("session").info("disconnected #" + session.getId());
        }
    }

    synchronized void close(boolean fromShutdownHook) {
        int i;
        this.closing = true;
        if (this.sessions.size() > 0) {
            if (!fromShutdownHook) {
                return;
            }
            this.traceSystem.getTrace("database").info("closing " + this.databaseName + " from shutdown hook");
            Session[] all = new Session[this.sessions.size()];
            this.sessions.toArray(all);
            for (i = 0; i < all.length; ++i) {
                Session s = all[i];
                try {
                    s.close();
                    continue;
                }
                catch (SQLException e) {
                    this.traceSystem.getTrace("session").error("disconnecting #" + s.getId(), e);
                }
            }
        }
        this.traceSystem.getTrace("database").info("closing " + this.databaseName);
        if (this.eventListener != null) {
            this.eventListener.closingDatabase();
            this.eventListener = null;
        }
        try {
            if (this.persistent && this.fileData != null) {
                ObjectArray tablesAndViews = this.getAllSchemaObjects(0);
                for (i = 0; i < tablesAndViews.size(); ++i) {
                    Table table = (Table)tablesAndViews.get(i);
                    table.close(this.systemSession);
                }
                ObjectArray sequences = this.getAllSchemaObjects(3);
                for (int i2 = 0; i2 < sequences.size(); ++i2) {
                    Sequence sequence = (Sequence)sequences.get(i2);
                    sequence.close();
                }
                this.meta.close(this.systemSession);
            }
        }
        catch (SQLException e) {
            this.traceSystem.getTrace("database").error("close", e);
        }
        try {
            this.closeOpenFilesAndUnlock();
        }
        catch (SQLException e) {
            this.traceSystem.getTrace("database").error("close", e);
        }
        this.traceSystem.getTrace("database").info("closed");
        if (this.traceSystem != null) {
            this.traceSystem.close();
        }
        Engine.getInstance().close(this.databaseName);
        if (this.deleteFilesOnDisconnect && this.persistent) {
            this.deleteFilesOnDisconnect = false;
            String directory = FileUtils.getParent(this.databaseName);
            try {
                DeleteDbFiles.execute(directory, this.databaseShortName, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void stopWriter() {
        if (this.writer != null) {
            this.writer.stopThread();
            this.writer = null;
        }
    }

    private void closeOpenFilesAndUnlock() throws SQLException {
        if (this.log != null) {
            this.stopWriter();
            this.log.close();
            this.log = null;
        }
        this.closeFiles();
        this.deleteOldTempFiles();
        if (this.systemSession != null) {
            this.systemSession.close();
            this.systemSession = null;
        }
        if (this.lock != null) {
            this.lock.unlock();
            this.lock = null;
        }
    }

    private void closeFiles() throws SQLException {
        try {
            if (this.fileData != null) {
                this.fileData.close();
                this.fileData = null;
            }
            if (this.fileIndex != null) {
                this.fileIndex.close();
                this.fileIndex = null;
            }
        }
        catch (SQLException e) {
            this.traceSystem.getTrace("database").error("close", e);
        }
        this.storages = new ObjectArray();
    }

    private void checkMetaFree(int id) throws SQLException {
        Row r = this.meta.getTemplateRow();
        r.setValue(0, ValueInt.get(id));
        Cursor cursor = this.metaIdIndex.find(this.systemSession, r, r);
        cursor.next();
        r = cursor.get();
        if (r != null) {
            throw Message.internal();
        }
    }

    public int allocateObjectId(boolean needFresh, boolean dataFile) {
        int i;
        needFresh = true;
        if (needFresh) {
            i = this.objectIds.getLastSetBit() + 1;
            if ((i & 1) != (dataFile ? 1 : 0)) {
                ++i;
            }
            while (i < this.storages.size() || this.objectIds.get(i)) {
                if ((++i & 1) == (dataFile ? 1 : 0)) continue;
                ++i;
            }
        } else {
            i = this.objectIds.nextClearBit(0);
        }
        if (Constants.CHECK && this.objectIds.get(i)) {
            throw Message.internal();
        }
        this.objectIds.set(i);
        return i;
    }

    public ObjectArray getAllSettings() {
        return new ObjectArray(this.settings.values());
    }

    public ObjectArray getAllUsers() {
        return new ObjectArray(this.users.values());
    }

    public ObjectArray getAllRoles() {
        return new ObjectArray(this.roles.values());
    }

    public ObjectArray getAllRights() {
        return new ObjectArray(this.rights.values());
    }

    public ObjectArray getAllSchemas() {
        return new ObjectArray(this.schemas.values());
    }

    public ObjectArray getAllFunctionAliases() {
        return new ObjectArray(this.functionAliases.values());
    }

    public ObjectArray getAllUserDataTypes() {
        return new ObjectArray(this.userDataTypes.values());
    }

    public ObjectArray getAllSchemaObjects(int type) {
        ObjectArray list = new ObjectArray();
        Iterator it = this.schemas.values().iterator();
        while (it.hasNext()) {
            Schema schema = (Schema)it.next();
            list.addAll(schema.getAll(type));
        }
        return list;
    }

    public String getShortName() {
        return this.databaseShortName;
    }

    public String getName() {
        return this.databaseName;
    }

    public LogSystem getLog() {
        return this.log;
    }

    public synchronized Session[] getSessions() {
        Session[] list = new Session[this.sessions.size()];
        this.sessions.toArray(list);
        return list;
    }

    public void update(Session session, DbObject obj) throws SQLException {
        int id = obj.getId();
        this.removeMeta(session, id);
        this.addMeta(session, obj);
    }

    public void renameSchemaObject(Session session, SchemaObject obj, String newName) throws SQLException {
        obj.getSchema().rename(obj, newName);
        this.updateWithChildren(session, obj);
    }

    private void updateWithChildren(Session session, DbObject obj) throws SQLException {
        ObjectArray list = obj.getChildren();
        this.update(session, obj);
        for (int i = 0; list != null && i < list.size(); ++i) {
            DbObject o = (DbObject)list.get(i);
            if (o.getCreateSQL() == null) continue;
            this.update(session, o);
        }
    }

    public void renameDatabaseObject(Session session, DbObject obj, String newName) throws SQLException {
        int type = obj.getType();
        HashMap map = this.getMap(type);
        if (Constants.CHECK) {
            if (!map.containsKey(obj.getName())) {
                throw Message.internal("not found: " + obj.getName());
            }
            if (obj.getName().equals(newName) || map.containsKey(newName)) {
                throw Message.internal("object already exists: " + newName);
            }
        }
        int id = obj.getId();
        this.removeMeta(session, id);
        map.remove(obj.getName());
        obj.rename(newName);
        map.put(newName, obj);
        this.updateWithChildren(session, obj);
    }

    public String createTempFile() throws SQLException {
        try {
            return FileUtils.createTempFile(this.databaseName, ".temp.db", true);
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    private void reserveLobFileObjectIds() throws SQLException {
        String prefix = FileUtils.normalize(this.databaseName);
        String path = FileUtils.getParent(this.databaseName);
        String[] list = FileUtils.listFiles(path);
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".lob.db") || !FileUtils.fileStartsWith(name, prefix)) continue;
            name = name.substring(prefix.length() + 1);
            int dot = (name = name.substring(0, name.length() - ".lob.db".length())).indexOf(46);
            if (dot < 0) continue;
            String id = name.substring(dot + 1);
            int objectId = Integer.parseInt(id);
            this.objectIds.set(objectId);
        }
    }

    private void deleteOldTempFiles() throws SQLException {
        if (this.emergencyReserve != null) {
            try {
                this.emergencyReserve.close();
            }
            catch (IOException e) {
                throw Message.convert(e);
            }
            this.emergencyReserve = null;
        }
        String path = FileUtils.getParent(this.databaseName);
        String prefix = FileUtils.normalize(this.databaseName);
        String[] list = FileUtils.listFiles(path);
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.endsWith(".temp.db") || !FileUtils.fileStartsWith(name, prefix)) continue;
            FileUtils.tryDelete(name);
        }
    }

    public Storage getStorage(RecordReader reader, int id, boolean dataFile) {
        DiskFile file = dataFile ? this.fileData : this.fileIndex;
        Storage storage = this.getStorage(id, file);
        storage.setReader(reader);
        return storage;
    }

    public Role findRole(String roleName) {
        return (Role)this.roles.get(roleName);
    }

    public Schema findSchema(String schemaName) {
        return (Schema)this.schemas.get(schemaName);
    }

    public void removeDatabaseObject(Session session, DbObject obj) throws SQLException {
        String objName = obj.getName();
        int type = obj.getType();
        HashMap map = this.getMap(type);
        if (Constants.CHECK && !map.containsKey(objName)) {
            throw Message.internal("not found: " + objName);
        }
        int id = obj.getId();
        obj.removeChildrenAndResources(session);
        map.remove(objName);
        this.removeMeta(session, id);
    }

    private String getFirstInvalidTable() {
        String conflict = null;
        try {
            ObjectArray list = this.getAllSchemaObjects(0);
            for (int i = 0; i < list.size(); ++i) {
                Table t = (Table)list.get(i);
                conflict = t.getSQL();
                this.systemSession.prepare(t.getCreateSQL());
            }
        }
        catch (SQLException e) {
            return conflict;
        }
        return null;
    }

    public void removeSchemaObject(Session session, SchemaObject obj) throws SQLException {
        Table table;
        if (obj.getType() == 0 && (table = (Table)obj).getTemporary() && !table.getGlobalTemporary()) {
            session.removeLocalTempTable(table);
            return;
        }
        obj.getSchema().remove(session, obj);
        String invalid = this.getFirstInvalidTable();
        if (invalid != null) {
            obj.getSchema().add(obj);
            throw Message.getSQLException(90107, new String[]{obj.getSQL(), invalid}, null);
        }
        int id = obj.getId();
        obj.removeChildrenAndResources(session);
        this.removeMeta(session, id);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public TraceSystem getTraceSystem() {
        return this.traceSystem;
    }

    public DiskFile getDataFile() {
        return this.fileData;
    }

    public DiskFile getIndexFile() {
        return this.fileIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCacheSize(int value) throws SQLException {
        if (this.fileData != null) {
            DiskFile diskFile = this.fileData;
            synchronized (diskFile) {
                this.fileData.getCache().setMaxSize(value);
            }
            int valueIndex = value <= 256 ? value : value >>> 3;
            DiskFile diskFile2 = this.fileIndex;
            synchronized (diskFile2) {
                this.fileIndex.getCache().setMaxSize(valueIndex);
            }
            this.cacheSize = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMasterUser(User user) throws SQLException {
        Database database = this;
        synchronized (database) {
            this.addDatabaseObject(this.systemSession, user);
            this.systemSession.commit();
        }
    }

    public Role getPublicRole() {
        return this.publicRole;
    }

    public String getTempTableName(int sessionId) {
        String tempName;
        int i = 0;
        while (this.mainSchema.findTableOrView(null, tempName = "TEMP_TABLE_" + sessionId + "_" + i) != null) {
            ++i;
        }
        return tempName;
    }

    public void setCompareMode(CompareMode compareMode) {
        this.compareMode = compareMode;
    }

    public CompareMode getCompareMode() {
        return this.compareMode;
    }

    public String getCluster() {
        return this.cluster;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public void checkWritingAllowed() throws SQLException {
        if (this.readOnly) {
            throw Message.getSQLException(90097);
        }
        if (this.noDiskSpace) {
            throw Message.getSQLException(90100);
        }
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setWriteDelay(int value) {
        this.writeDelay = value;
        if (this.writer != null) {
            this.writer.setWriteDelay(value);
        }
    }

    public void setEventListener(String className) throws SQLException {
        if (className == null || className.length() == 0) {
            this.eventListener = null;
        } else {
            try {
                this.eventListener = (DatabaseEventListener)Class.forName(className).newInstance();
                this.eventListener.init(this.databaseURL);
            }
            catch (Throwable e) {
                throw Message.getSQLException(90099, new String[]{className}, e);
            }
        }
    }

    public void freeUpDiskSpace() throws SQLException {
        long sizeAvailable = 0L;
        if (this.emergencyReserve != null) {
            sizeAvailable = this.emergencyReserve.length();
            long newLength = sizeAvailable / 2L;
            if (newLength < 131072L) {
                newLength = 0L;
                this.noDiskSpace = true;
            }
            this.emergencyReserve.setLength(newLength);
        }
        if (this.eventListener != null) {
            this.eventListener.diskSpaceIsLow(sizeAvailable);
        }
    }

    public void setProgress(int state, String name, int x, int max) {
        if (this.eventListener != null) {
            try {
                this.eventListener.setProgress(state, name, x, max);
            }
            catch (Exception e2) {
                // empty catch block
            }
        }
    }

    public void exceptionThrown(SQLException e) {
        if (this.eventListener != null) {
            try {
                this.eventListener.exceptionThrown(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sync() throws SQLException {
        if (this.log != null) {
            this.log.sync();
        }
        if (this.fileData != null) {
            this.fileData.sync();
        }
        if (this.fileIndex != null) {
            this.fileIndex.sync();
        }
    }

    public int getMaxMemoryRows() {
        return this.maxMemoryRows;
    }

    public void setMaxMemoryRows(int value) {
        this.maxMemoryRows = value;
    }

    public void setMaxMemoryUndo(int value) {
        this.maxMemoryUndo = value;
    }

    public int getMaxMemoryUndo() {
        return this.maxMemoryUndo;
    }

    public int getChecksum(byte[] data, int start, int end) {
        int x = 0;
        while (start < end) {
            x += data[start++];
        }
        return x;
    }

    public void setLockMode(int lockMode) {
        this.lockMode = lockMode;
    }

    public int getLockMode() {
        return this.lockMode;
    }

    public void setCloseDelay(int value) {
        this.closeDelay = value;
    }

    public boolean getLogIndexChanges() {
        return this.logIndexChanges;
    }

    /*
     * WARNING - void declaration
     */
    public void setLog(int level) throws SQLException {
        if (this.logLevel == level) {
            return;
        }
        switch (level) {
            case 0: {
                boolean logData = false;
                boolean logIndex = false;
                break;
            }
            case 1: {
                boolean logData = true;
                boolean logIndex = false;
                break;
            }
            case 2: {
                boolean logData = true;
                boolean logIndex = true;
                break;
            }
            default: {
                throw Message.internal("level=" + level);
            }
        }
        if (this.fileIndex != null) {
            void var3_3;
            this.fileIndex.setLogChanges((boolean)var3_3);
        }
        if (this.log != null) {
            void var2_2;
            this.log.setDisabled(var2_2 == false);
            this.log.checkpoint();
        }
        this.logLevel = level;
    }

    public ObjectArray getAllStorages() {
        return this.storages;
    }

    public boolean getRecovery() {
        return this.recovery;
    }

    public Session getSystemSession() {
        return this.systemSession;
    }

    public String getDatabasePath() {
        if (this.persistent) {
            File parent = new File(this.databaseName).getAbsoluteFile();
            return parent.getAbsolutePath();
        }
        return null;
    }

    public void handleInvalidChecksum() throws SQLException {
        JdbcSQLException e = Message.getSQLException(90030, "wrong checksum");
        if (!this.recovery) {
            throw e;
        }
        this.traceSystem.getTrace("database").error("recover", e);
    }

    public boolean isClosing() {
        return this.closing;
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setMaxLengthInplaceLob(int value) {
        this.maxLengthInplaceLob = value;
    }

    public int getMaxLengthInplaceLob() {
        return this.maxLengthInplaceLob;
    }

    public void setIgnoreCase(boolean b) {
        this.ignoreCase = b;
    }

    public boolean getIgnoreCase() {
        if (this.starting) {
            return false;
        }
        return this.ignoreCase;
    }

    public void setDeleteFilesOnDisconnect(boolean b) {
        this.deleteFilesOnDisconnect = b;
    }

    public String getLobCompressionAlgorithm(int type) {
        return this.lobCompressionAlgorithm;
    }

    public void setLobCompressionAlgorithm(String stringValue) {
        this.lobCompressionAlgorithm = stringValue;
    }

    public void notifyFileSize(long length) {
        if (length > this.biggestFileSize) {
            this.biggestFileSize = length;
            this.setMaxLogSize(0L);
        }
    }

    public void setMaxLogSize(long value) {
        long currentLogSize;
        long minLogSize = this.biggestFileSize / 10L;
        if ((minLogSize = Math.max(value, minLogSize)) > (currentLogSize = this.getLog().getMaxLogSize()) || value > 0L && minLogSize > value) {
            value = minLogSize;
        }
        if (value > 0L) {
            this.getLog().setMaxLogSize(value);
        }
    }

    public void setAllowLiterals(int value) {
        this.allowLiterals = value;
    }

    public int getAllowLiterals() {
        if (this.starting) {
            return 2;
        }
        return this.allowLiterals;
    }
}

