/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ValueExpression;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ExpressionList
extends Expression {
    private Expression[] list;

    public ExpressionList(Expression[] list) {
        this.list = list;
    }

    public Value getValue(Session session) throws SQLException {
        Value[] v = new Value[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            v[i] = this.list[i].getValue(session);
        }
        return ValueArray.get(v);
    }

    public int getType() {
        return 17;
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].mapColumns(resolver, level);
        }
    }

    public Expression optimize(Session session) throws SQLException {
        boolean allConst = true;
        for (int i = 0; i < this.list.length; ++i) {
            Expression e = this.list[i].optimize(session);
            if (!e.isConstant()) {
                allConst = false;
            }
            this.list[i] = e;
        }
        if (allConst) {
            return ValueExpression.get(this.getValue(session));
        }
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].setEvaluatable(tableFilter, b);
        }
    }

    public int getScale() {
        return 0;
    }

    public long getPrecision() {
        return 0L;
    }

    public String getSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append('(');
        for (int i = 0; i < this.list.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.list[i].getSQL());
        }
        buff.append(')');
        return buff.toString();
    }

    public void updateAggregate(Session session) throws SQLException {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].updateAggregate(session);
        }
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i].isEverything(visitor)) continue;
            return false;
        }
        return true;
    }
}

