/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import java.sql.SQLException;
import org.h2.command.dml.Query;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueNull;

public class Subquery
extends Expression {
    private Query query;
    private long lastEvaluated;
    private Value lastResult;
    private Value[] lastParameters;

    public Subquery(Query query) {
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getValue(Session session) throws SQLException {
        this.query.setSession(session);
        ObjectArray list = this.query.getParameters();
        if (list == null) {
            list = new ObjectArray();
        }
        long now = session.getDatabase().getModificationDataId();
        if (Constants.OPTIMIZE_SUBQUERY_CACHE && this.query.isEverything(2) && this.query.isEverything(0)) {
            boolean sameAsLast = this.lastParameters != null;
            Value[] params = new Value[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Value v;
                params[i] = v = (Value)list.get(i);
                if (!sameAsLast || session.getDatabase().areEqual(this.lastParameters[i], v)) continue;
                sameAsLast = false;
            }
            if (this.query.getMaxDataModificationId() > this.lastEvaluated) {
                sameAsLast = false;
            }
            if (sameAsLast && this.lastResult != null) {
                return this.lastResult;
            }
            this.lastResult = null;
            this.lastParameters = params;
        }
        this.query.setSession(session);
        LocalResult result = this.query.query(2);
        this.lastEvaluated = now;
        try {
            Value v;
            int rowcount = result.getRowCount();
            if (rowcount > 1) {
                throw Message.getSQLException(90053);
            }
            if (rowcount <= 0) {
                v = ValueNull.INSTANCE;
            } else {
                result.next();
                Value[] values = result.currentRow();
                v = result.getVisibleColumnCount() == 1 ? values[0] : ValueArray.get(values);
            }
            this.lastResult = v;
            ValueNull valueNull = v;
            return valueNull;
        }
        finally {
            result.close();
        }
    }

    public int getType() {
        return this.getExpression().getType();
    }

    public void mapColumns(ColumnResolver resolver, int level) throws SQLException {
        this.query.mapColumns(resolver, level + 1);
    }

    public Expression optimize(Session session) throws SQLException {
        this.query.prepare();
        return this;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean b) {
        this.query.setEvaluatable(tableFilter, b);
    }

    public int getScale() {
        return this.getExpression().getScale();
    }

    public long getPrecision() {
        return this.getExpression().getPrecision();
    }

    public String getSQL() {
        return "(" + this.query.getPlan() + ")";
    }

    public void updateAggregate(Session session) {
    }

    private Expression getExpression() {
        return (Expression)this.query.getExpressions().get(0);
    }

    public boolean isEverything(ExpressionVisitor visitor) {
        return this.query.isEverything(visitor);
    }

    public Query getQuery() {
        return this.query;
    }
}

