/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.LinearHashBucket;
import org.h2.index.LinearHashCursor;
import org.h2.index.LinearHashEntry;
import org.h2.index.LinearHashHead;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.store.Storage;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class LinearHashIndex
extends Index
implements RecordReader {
    private static final int RECORDS_PER_BUCKET = 10;
    private static final int UTILIZATION_FOR_SPLIT = 70;
    private static final int UTILIZATION_FOR_MERGE = 60;
    private int readCount;
    private DiskFile diskFile;
    private Storage storage;
    private TableData tableData;
    private int bucketSize;
    private int blocksPerBucket;
    private int firstBucketBlock;
    private LinearHashHead head;
    private boolean needRebuild;

    public LinearHashIndex(Session session, TableData table, int id, String indexName, Column[] columns, IndexType indexType) throws SQLException {
        super(table, id, indexName, columns, indexType);
        this.tableData = table;
        String name = this.database.getName() + "." + id + ".hash.db";
        this.diskFile = new DiskFile(this.database, name, false, false, 256);
        this.diskFile.init();
        this.bucketSize = 512 - this.diskFile.getRecordOverhead();
        this.blocksPerBucket = 4;
        this.firstBucketBlock = 4;
        this.storage = this.database.getStorage(id, this.diskFile);
        this.storage.setReader(this);
        this.rowCount = table.getRowCount();
        int pos = this.storage.getNext(null);
        if (pos == -1) {
            this.truncate(session);
            this.needRebuild = true;
        } else {
            this.head = (LinearHashHead)this.storage.getRecord(pos);
        }
    }

    void writeHeader(Session session) throws SQLException {
        this.storage.updateRecord(session, this.head);
    }

    private void add(Session session, Value key, int value) throws SQLException {
        int home;
        if (this.getUtilization() >= 70) {
            this.split(session);
        }
        int hash = key.hashCode();
        int index = home = this.getPos(hash);
        LinearHashEntry record = new LinearHashEntry();
        record.hash = hash;
        record.key = key;
        record.home = home;
        record.value = value;
        int free = this.getNextFree(home);
        while (true) {
            LinearHashBucket bucket;
            if ((bucket = this.getBucket(index)).getRecordSize() < 10) {
                this.addRecord(session, bucket, record);
                break;
            }
            int foreign = this.getForeignHome(index);
            if (foreign >= 0 && foreign != home) {
                ObjectArray old = new ObjectArray();
                this.moveOut(session, foreign, old);
                this.addRecord(session, bucket, record);
                this.addAll(session, old);
                break;
            }
            if (bucket.getNextBucket() > 0) {
                index = bucket.getNextBucket();
                continue;
            }
            int nextFree = this.getNextFree(free);
            if (nextFree < 0) {
                this.split(session);
                this.add(session, key, value);
                break;
            }
            bucket = this.getBucket(index);
            bucket.setNext(session, free);
            free = nextFree;
            if (this.getForeignHome(free) >= 0) {
                throw Message.internal("next already linked");
            }
            index = bucket.getNextBucket();
        }
    }

    private int getNextFree(int excluding) throws SQLException {
        for (int i = this.head.bucketCount - 1; i >= 0; --i) {
            LinearHashBucket bucket = this.getBucket(i);
            if (bucket.getRecordSize() >= 10 || this.getForeignHome(i) >= 0 || i == excluding) continue;
            return i;
        }
        return -1;
    }

    private int getForeignHome(int bucketId) throws SQLException {
        LinearHashBucket bucket = this.getBucket(bucketId);
        for (int i = 0; i < bucket.getRecordSize(); ++i) {
            LinearHashEntry record = bucket.getRecord(i);
            if (record.home == bucketId) continue;
            return record.home;
        }
        return -1;
    }

    public int getPos(int hash) {
        int len;
        int pos = (hash = Math.abs((hash << 7) - hash + (hash >>> 9) + (hash >>> 17))) % (this.head.baseSize + this.head.baseSize);
        return pos < (len = this.head.bucketCount) ? pos : pos % this.head.baseSize;
    }

    private void split(Session session) throws SQLException {
        ObjectArray old = new ObjectArray();
        this.moveOut(session, this.head.nextToSplit, old);
        ++this.head.nextToSplit;
        if (this.head.nextToSplit >= this.head.baseSize) {
            this.head.baseSize += this.head.baseSize;
            this.head.nextToSplit = 0;
        }
        this.addBucket(session);
        this.addAll(session, old);
    }

    private void addAll(Session session, ObjectArray records) throws SQLException {
        for (int i = 0; i < records.size(); ++i) {
            LinearHashEntry r = (LinearHashEntry)records.get(i);
            this.add(session, r.key, r.value);
        }
    }

    private void moveOut(Session session, int home, ObjectArray storeIn) throws SQLException {
        LinearHashBucket bucket = this.getBucket(home);
        int foreign = this.getForeignHome(home);
        while (true) {
            for (int i = 0; i < bucket.getRecordSize(); ++i) {
                LinearHashEntry r = bucket.getRecord(i);
                if (r.home != home) continue;
                storeIn.add(r);
                this.removeRecord(session, bucket, i);
                --i;
            }
            if (foreign >= 0) {
                this.moveOut(session, foreign, storeIn);
                if (Constants.CHECK && this.getBucket(foreign).getNextBucket() != -1) {
                    throw Message.internal("moveout " + foreign);
                }
                return;
            }
            int next = bucket.getNextBucket();
            if (Constants.CHECK && next >= this.head.bucketCount) {
                throw Message.internal("next=" + next + " max=" + this.head.bucketCount);
            }
            if (next < 0) break;
            bucket.setNext(session, -1);
            bucket = this.getBucket(next);
        }
    }

    private void merge(Session session) throws SQLException {
        if (this.head.bucketCount <= 1) {
            return;
        }
        if (this.getUtilization() > 60) {
            return;
        }
        ObjectArray old = new ObjectArray();
        this.moveOut(session, this.head.nextToSplit, old);
        --this.head.nextToSplit;
        if (this.head.nextToSplit < 0) {
            this.head.baseSize /= 2;
            this.head.nextToSplit = this.head.baseSize - 1;
        }
        this.moveOut(session, this.head.nextToSplit, old);
        this.moveOut(session, this.head.bucketCount - 1, old);
        this.removeBucket(session);
        this.addAll(session, old);
    }

    private boolean isEquals(LinearHashEntry r, int hash, Value key) throws SQLException {
        if (r.hash == hash) {
            if (r.key == null) {
                r.key = this.getKey(this.tableData.getRow(r.value));
            }
            if (this.database.compareTypeSave(r.key, key) == 0) {
                return true;
            }
        }
        return false;
    }

    private int get(Value key) throws SQLException {
        int hash = key.hashCode();
        int home = this.getPos(hash);
        LinearHashBucket bucket = this.getBucket(home);
        while (true) {
            for (int i = 0; i < bucket.getRecordSize(); ++i) {
                LinearHashEntry r = bucket.getRecord(i);
                if (!this.isEquals(r, hash, key)) continue;
                return r.value;
            }
            if (bucket.getNextBucket() < 0) {
                return -1;
            }
            bucket = this.getBucket(bucket.getNextBucket());
        }
    }

    private void removeRecord(Session session, LinearHashBucket bucket, int index) throws SQLException {
        bucket.removeRecord(session, index);
        --this.head.recordCount;
        --this.rowCount;
    }

    private void addRecord(Session session, LinearHashBucket bucket, LinearHashEntry entry) throws SQLException {
        bucket.addRecord(session, entry);
        ++this.head.recordCount;
        ++this.rowCount;
    }

    private void remove(Session session, Value key) throws SQLException {
        int home;
        this.merge(session);
        int hash = key.hashCode();
        int now = home = this.getPos(hash);
        while (true) {
            LinearHashBucket bucket = this.getBucket(now);
            for (int i = 0; i < bucket.getRecordSize(); ++i) {
                LinearHashEntry r = bucket.getRecord(i);
                if (!this.isEquals(r, hash, key)) continue;
                this.removeRecord(session, bucket, i);
                if (home != now) {
                    ObjectArray old = new ObjectArray();
                    this.moveOut(session, home, old);
                    this.addAll(session, old);
                }
                return;
            }
            int next = bucket.getNextBucket();
            if (next < 0) {
                throw Message.internal("not found");
            }
            now = next;
        }
    }

    private int getBlockId(int i) {
        return i * this.blocksPerBucket + this.firstBucketBlock;
    }

    private LinearHashBucket getBucket(int i) throws SQLException {
        ++this.readCount;
        if (Constants.CHECK && i >= this.head.bucketCount) {
            throw Message.internal("get=" + i + " max=" + this.head.bucketCount);
        }
        i = this.getBlockId(i);
        LinearHashBucket bucket = (LinearHashBucket)this.storage.getRecord(i);
        return bucket;
    }

    private void addBucket(Session session) throws SQLException {
        LinearHashBucket bucket = new LinearHashBucket(this);
        this.storage.addRecord(session, bucket, this.getBlockId(this.head.bucketCount));
        if (Constants.CHECK && bucket.getBlockCount() > this.blocksPerBucket) {
            throw Message.internal("blocks=" + bucket.getBlockCount());
        }
        ++this.head.bucketCount;
    }

    private void removeBucket(Session session) throws SQLException {
        int pos = this.getBlockId(this.head.bucketCount - 1);
        this.storage.removeRecord(session, pos);
        --this.head.bucketCount;
    }

    private int getUtilization() {
        return 100 * this.head.recordCount / (this.head.bucketCount * 10);
    }

    void updateBucket(Session session, LinearHashBucket bucket) throws SQLException {
        this.storage.updateRecord(session, bucket);
    }

    public Record read(DataPage s) throws SQLException {
        char c = (char)s.readByte();
        if (c == 'B') {
            return new LinearHashBucket(this, s);
        }
        if (c == 'H') {
            return new LinearHashHead(this, s);
        }
        throw Message.getSQLException(90030, this.getName());
    }

    public void close(Session session) throws SQLException {
        this.writeHeader(session);
        this.diskFile.close();
    }

    public void add(Session session, Row row) throws SQLException {
        Value key = this.getKey(row);
        if (this.get(key) != -1) {
            throw this.getDuplicateKeyException();
        }
        this.add(session, key, row.getPos());
    }

    public void remove(Session session, Row row) throws SQLException {
        this.remove(session, this.getKey(row));
    }

    private Value getKey(Row row) throws SQLException {
        if (this.columns.length == 1) {
            Column column = this.columns[0];
            int index = column.getColumnId();
            Value v = row.getValue(index);
            return v;
        }
        Value[] list = new Value[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            Value v;
            Column column = this.columns[i];
            int index = column.getColumnId();
            list[i] = v = row.getValue(index);
        }
        return ValueArray.get(list);
    }

    public Cursor find(Session session, Row first, Row last) throws SQLException {
        if (first == null || last == null) {
            throw Message.internal();
        }
        int key = this.get(this.getKey(first));
        if (key == -1) {
            return new LinearHashCursor(null);
        }
        return new LinearHashCursor(this.tableData.getRow(key));
    }

    public int getCost(int[] masks) throws SQLException {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            int index = column.getColumnId();
            int mask = masks[index];
            if ((mask & 1) == 1) continue;
            return Integer.MAX_VALUE;
        }
        return 100;
    }

    public void remove(Session session) throws SQLException {
        this.storage.delete(session);
        this.diskFile.delete();
    }

    public void truncate(Session session) throws SQLException {
        this.storage.truncate(session);
        this.head = new LinearHashHead(this);
        this.head.recordCount = 0;
        this.head.bucketCount = 0;
        this.head.baseSize = 1;
        this.head.nextToSplit = 0;
        this.readCount = 0;
        this.storage.addRecord(session, this.head, 0);
        this.addBucket(session);
        this.rowCount = 0;
    }

    public void checkRename() throws SQLException {
    }

    public boolean needRebuild() {
        return this.needRebuild;
    }

    public int getBucketSize() {
        return this.bucketSize;
    }

    public boolean canGetFirstOrLast(boolean first) {
        return false;
    }

    public Value findFirstOrLast(Session session, boolean first) throws SQLException {
        throw Message.getUnsupportedException();
    }
}

