/*
 * Decompiled with CFR 0.152.
 */
package org.h2.message;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.h2.engine.Constants;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.util.FileUtils;

public class TraceSystem {
    public static final int OFF = 0;
    public static final int ERROR = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    private static final int DEFAULT_MAX_FILE_SIZE = 0x4000000;
    public static final int DEFAULT_TRACE_LEVEL_SYSTEM_OUT = 0;
    public static final int DEFAULT_TRACE_LEVEL_FILE = 1;
    private static final int CHECK_FILE_TIME = 4000;
    private int levelSystemOut = 0;
    private int levelFile = 1;
    private int maxFileSize = 0x4000000;
    private String fileName;
    private long lastCheck = 0L;
    private HashMap traces;
    private SimpleDateFormat dateFormat;
    private FileWriter fileWriter;
    private PrintWriter printWriter;
    private static final int CHECK_SIZE_EACH_WRITES = 128;
    private int checkSize;
    private boolean closed;

    public static void traceThrowable(Throwable e) {
        PrintWriter writer = DriverManager.getLogWriter();
        if (writer != null) {
            e.printStackTrace(writer);
        }
    }

    public TraceSystem(String fileName) {
        this.fileName = fileName;
        this.traces = new HashMap();
        this.dateFormat = new SimpleDateFormat("MM-dd HH:mm:ss ");
        if (fileName != null) {
            try {
                this.openWriter();
            }
            catch (Exception e) {
                this.logWritingError(e);
            }
        }
    }

    public Trace getTrace(String module) {
        Trace t = (Trace)this.traces.get(module);
        if (t == null) {
            t = new Trace(this, module);
            this.traces.put(module, t);
        }
        return t;
    }

    public boolean isEnabled(int level) {
        int max = Math.max(this.levelSystemOut, this.levelFile);
        return level <= max;
    }

    public void setFileName(String name) {
        this.fileName = name;
    }

    public void setMaxFileSize(int max) {
        this.maxFileSize = max;
    }

    public int getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setLevelSystemOut(int l) {
        this.levelSystemOut = l;
    }

    public int getLevelFile() {
        return this.levelFile;
    }

    public int getLevelSystemOut() {
        return this.levelSystemOut;
    }

    public void setLevelFile(int l) {
        this.levelFile = l;
    }

    private String format(String module, String s) {
        return this.dateFormat.format(new Date()) + module + ": " + s;
    }

    void write(int l, String module, String s, Throwable t) {
        if (l <= this.levelSystemOut) {
            System.out.println(this.format(module, s));
            if (t != null && this.levelSystemOut == 3) {
                t.printStackTrace();
            }
        }
        if (this.fileName != null) {
            long time;
            if (l > this.levelFile && (time = System.currentTimeMillis()) > this.lastCheck + 4000L) {
                String checkFile = this.fileName + ".start";
                this.lastCheck = time;
                if (FileUtils.exists(checkFile)) {
                    this.levelFile = 3;
                    try {
                        FileUtils.delete(checkFile);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (l <= this.levelFile) {
                this.writeFile(this.format(module, s), t);
            }
        }
    }

    private synchronized void writeFile(String s, Throwable t) {
        try {
            if (this.checkSize++ >= 128) {
                this.checkSize = 0;
                this.closeWriter();
                if (this.maxFileSize > 0 && FileUtils.length(this.fileName) > (long)this.maxFileSize) {
                    String old = this.fileName + ".old";
                    if (FileUtils.exists(old)) {
                        FileUtils.delete(old);
                    }
                    FileUtils.rename(this.fileName, old);
                }
            }
            if (!this.openWriter()) {
                return;
            }
            this.printWriter.println(s);
            if (t != null) {
                t.printStackTrace(this.printWriter);
            }
            this.printWriter.flush();
            if (this.closed) {
                this.closeWriter();
            }
        }
        catch (Exception e) {
            this.logWritingError(e);
        }
    }

    private void logWritingError(Exception e) {
        JdbcSQLException se = Message.getSQLException(90034, new String[]{this.fileName}, e);
        this.fileName = null;
        System.out.println(se);
        ((Throwable)se).printStackTrace();
    }

    private boolean openWriter() throws IOException {
        if (this.printWriter == null) {
            try {
                FileUtils.createDirs(this.fileName);
                if (FileUtils.exists(this.fileName) && FileUtils.isReadOnly(this.fileName)) {
                    return false;
                }
                this.fileWriter = FileUtils.openFileWriter(this.fileName, true);
                this.printWriter = new PrintWriter((Writer)this.fileWriter, true);
            }
            catch (SQLException e) {
                return false;
            }
        }
        return true;
    }

    private synchronized void closeWriter() {
        if (this.printWriter != null) {
            this.printWriter.flush();
            this.printWriter.close();
            this.printWriter = null;
        }
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.fileWriter = null;
        }
    }

    public void close() {
        this.closeWriter();
        this.closed = true;
    }

    public void finalize() {
        if (!Constants.RUN_FINALIZERS) {
            return;
        }
        this.close();
    }
}

