/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;
import org.h2.store.DiskFile;
import org.h2.store.Record;
import org.h2.store.RecordReader;
import org.h2.util.BitField;
import org.h2.util.IntArray;
import org.h2.util.MathUtils;

public class Storage {
    public static final int ALLOCATE_POS = -1;
    private static final int FREE_LIST_SIZE = Math.max(1024, 256);
    private DiskFile file;
    private int recordCount;
    private RecordReader reader;
    private IntArray freeList = new IntArray();
    private IntArray pages = new IntArray();
    private int id;
    private Database database;
    private DataPage dummy;

    public Storage(Database database, DiskFile file, RecordReader reader, int id) {
        this.database = database;
        this.file = file;
        this.reader = reader;
        this.id = id;
        this.dummy = DataPage.create((DataHandler)database, 0);
    }

    public RecordReader getRecordReader() {
        return this.reader;
    }

    void incrementRecordCount() {
        ++this.recordCount;
    }

    public Record getRecord(int pos) throws SQLException {
        return this.file.getRecord(pos, this.reader, this.id);
    }

    public Record getRecordIfStored(int pos) throws SQLException {
        return this.file.getRecordIfStored(pos, this.reader, this.id);
    }

    public int getNext(Record record) {
        int next;
        int lastCheckedPage;
        int pageIndex = -1;
        if (record == null) {
            if (this.pages.size() == 0) {
                return -1;
            }
            pageIndex = 0;
            lastCheckedPage = this.pages.get(0);
            next = lastCheckedPage * 64;
        } else {
            int blockCount = record.getBlockCount();
            lastCheckedPage = this.file.getPage(record.getPos());
            next = record.getPos() + blockCount;
        }
        BitField used = this.file.getUsed();
        while (true) {
            int page;
            if (lastCheckedPage != (page = this.file.getPage(next))) {
                pageIndex = pageIndex < 0 ? this.pages.findNextValueIndex(page) : ++pageIndex;
                if (pageIndex >= this.pages.size()) {
                    return -1;
                }
                lastCheckedPage = this.pages.get(pageIndex);
                next = Math.max(next, 64 * lastCheckedPage);
            }
            if (used.get(next)) {
                return next;
            }
            if (used.getLong(next) == 0L) {
                next = MathUtils.roundUp(next + 1, 64);
                continue;
            }
            ++next;
        }
    }

    public void updateRecord(Session session, Record record) throws SQLException {
        record.setDeleted(false);
        this.file.updateRecord(session, record);
    }

    public void addRecord(Session session, Record record, int pos) throws SQLException {
        record.setStorageId(this.id);
        int size = this.file.getRecordOverhead() + record.getByteCount(this.dummy);
        size = MathUtils.roundUp(size, 128);
        record.setDeleted(false);
        int blockCount = size / 128;
        if (pos == -1) {
            pos = this.allocate(blockCount);
        } else {
            this.file.setUsed(pos, blockCount);
        }
        record.setPos(pos);
        record.setBlockCount(blockCount);
        record.setChanged(true);
        ++this.recordCount;
        this.file.addRecord(session, record);
    }

    public void removeRecord(Session session, int pos) throws SQLException {
        Record record = this.getRecord(pos);
        if (Constants.CHECK && record.getDeleted()) {
            throw Message.internal("duplicate delete " + pos);
        }
        record.setDeleted(true);
        int blockCount = record.getBlockCount();
        this.free(pos, blockCount);
        --this.recordCount;
        this.file.removeRecord(session, pos, record, blockCount);
    }

    public void removeRecord(Session session, int pos, int blockCount) throws SQLException {
    }

    private boolean isFreeAndMine(int pos, int blocks) {
        BitField used = this.file.getUsed();
        for (int i = blocks + pos - 1; i >= pos; --i) {
            if (this.file.getPageOwner(this.file.getPage(i)) == this.id && !used.get(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int allocate(int blockCount) throws SQLException {
        if (this.freeList.size() > 0) {
            DiskFile diskFile = this.file;
            synchronized (diskFile) {
                BitField used = this.file.getUsed();
                for (int i = 0; i < this.freeList.size(); ++i) {
                    int px = this.freeList.get(i);
                    if (used.get(px)) {
                        this.freeList.remove(i--);
                        continue;
                    }
                    if (!this.isFreeAndMine(px, blockCount)) continue;
                    int pos = px;
                    this.freeList.remove(i--);
                    this.file.setUsed(pos, blockCount);
                    return pos;
                }
            }
        }
        int pos = this.file.allocate(this, blockCount);
        this.file.setUsed(pos, blockCount);
        return pos;
    }

    void free(int pos, int blockCount) {
        this.file.free(pos, blockCount);
        if (this.freeList.size() < FREE_LIST_SIZE) {
            this.freeList.add(pos);
        }
    }

    public void delete(Session session) throws SQLException {
        this.truncate(session);
        this.database.removeStorage(this.id, this.file);
    }

    public int getId() {
        return this.id;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void truncate(Session session) throws SQLException {
        this.freeList = new IntArray();
        this.recordCount = 0;
        this.file.truncateStorage(session, this, this.pages);
    }

    public void setReader(RecordReader reader) {
        this.reader = reader;
    }

    public void flushRecord(Record rec) throws SQLException {
        this.file.writeBack(rec);
    }

    public void flushFile() throws SQLException {
        this.file.flush();
    }

    public int getRecordOverhead() {
        return this.file.getRecordOverhead();
    }

    public DiskFile getDiskFile() {
        return this.file;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public void addPage(int i) {
        this.pages.addValueSorted(i);
    }

    public void removePage(int i) {
        this.pages.removeValue(i);
    }
}

