/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.h2.server.Service;
import org.h2.util.FileUtils;
import org.h2.util.NetUtils;
import org.h2.web.FtpControl;

public class FtpServer
implements Service {
    public static final String DEFAULT_ROOT = "ftp";
    public static final String DEFAULT_READ = "guest";
    public static final String DEFAULT_WRITE = "sa";
    public static final String DEFAULT_WRITE_PASSWORD = "sa";
    private ServerSocket serverSocket;
    private int port = 8021;
    private int openConnectionCount;
    private int maxConnectionCount = 100;
    private SimpleDateFormat dateFormatNew = new SimpleDateFormat("MMM dd HH:mm", Locale.ENGLISH);
    private SimpleDateFormat dateFormatOld = new SimpleDateFormat("MMM dd  yyyy", Locale.ENGLISH);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
    private String root = "ftp";
    private String writeUserName = "sa";
    private String writePassword = "sa";
    private String readUserName = "guest";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listen() {
        try {
            while (this.serverSocket != null) {
                boolean stop;
                Socket s = this.serverSocket.accept();
                FtpServer ftpServer = this;
                synchronized (ftpServer) {
                    ++this.openConnectionCount;
                    stop = this.openConnectionCount > this.maxConnectionCount;
                }
                FtpControl c = new FtpControl(s, this, stop);
                c.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeConnection() {
        FtpServer ftpServer = this;
        synchronized (ftpServer) {
            --this.openConnectionCount;
        }
    }

    public ServerSocket createDataSocket() throws IOException {
        ServerSocket dataSocket = new ServerSocket(0);
        return dataSocket;
    }

    void appendFile(StringBuffer buff, File f) {
        buff.append(f.isDirectory() ? (char)'d' : '-');
        buff.append(f.canRead() ? (char)'r' : '-');
        buff.append(f.canWrite() ? (char)'w' : '-');
        buff.append("------- 1 owner group ");
        String size = String.valueOf(f.length());
        for (int i = size.length(); i < 15; ++i) {
            buff.append(' ');
        }
        buff.append(size);
        buff.append(' ');
        Date now = new Date();
        Date mod = new Date(f.lastModified());
        if (mod.after(now) || Math.abs((now.getTime() - mod.getTime()) / 1000L / 60L / 60L / 24L) > 180L) {
            buff.append(this.dateFormatOld.format(mod));
        } else {
            buff.append(this.dateFormatNew.format(mod));
        }
        buff.append(' ');
        buff.append(f.getName());
        buff.append("\r\n");
    }

    String formatLastModified(File file) {
        return this.dateFormat.format(new Date(file.lastModified()));
    }

    File getFile(String path) {
        if (path.indexOf("..") > 0) {
            path = "/";
        }
        this.trace("file: " + this.root + path);
        return new File(this.root + path);
    }

    String getDirectoryListing(File directory, boolean listDirectories) {
        File[] list = directory.listFiles();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; list != null && i < list.length; ++i) {
            File f = list[i];
            if (!f.isFile() && (!f.isDirectory() || !listDirectories)) continue;
            this.appendFile(buff, f);
        }
        return buff.toString();
    }

    public boolean checkUserPassword(String userName, String param) {
        return userName.equals(this.writeUserName) && this.writePassword.equals(this.writePassword);
    }

    public boolean checkUserPasswordReadOnly(String userName, String param) {
        return userName.equals(this.readUserName);
    }

    public void init(String[] args) throws Exception {
        for (int i = 0; args != null && i < args.length; ++i) {
            if ("-ftpPort".equals(args[i])) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-ftpDir".equals(args[i])) {
                this.root = args[++i];
                continue;
            }
            if ("-ftpRead".equals(args[i])) {
                this.readUserName = args[++i];
                continue;
            }
            if ("-ftpWrite".equals(args[i])) {
                this.writeUserName = args[++i];
                continue;
            }
            if (!"-ftpWritePassword".equals(args[i])) continue;
            this.writePassword = args[++i];
        }
    }

    public String getURL() {
        return "ftp://localhost:" + this.port;
    }

    public void start() throws SQLException {
        FileUtils.createDirs(this.root + "/.");
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, false);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean getAllowOthers() {
        return true;
    }

    public String getType() {
        return "FTP";
    }

    void trace(String s) {
        System.out.println(s);
    }
}

