/*
 * Decompiled with CFR 0.152.
 */
package org.h2.web;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import org.h2.message.TraceSystem;
import org.h2.server.Service;
import org.h2.util.ByteUtils;
import org.h2.util.NetUtils;
import org.h2.util.RandomUtils;
import org.h2.util.Resources;
import org.h2.web.AppServer;
import org.h2.web.AppSession;
import org.h2.web.AppThread;
import org.h2.web.WebServerSession;

public class WebServer
implements Service {
    private static final String DEFAULT_LANGUAGE = "en";
    private static final String[][] LANGUAGES = new String[][]{{"en", "English"}, {"de", "Deutsch"}, {"fr", "Fran\u00e7ais"}, {"es", "Espa\u00f1ol"}, {"zh_CN", "\u4e2d\u6587"}};
    private static final long SESSION_TIMEOUT = 1800000L;
    private long lastTimeoutCheck;
    private HashMap sessions = new HashMap();
    private HashSet languages = new HashSet();
    private String startDateTime;
    private AppServer appServer;
    private ServerSocket serverSocket;
    private boolean ssl;
    private int port;
    private String url;

    byte[] getFile(String file) throws IOException {
        this.trace("getFile <" + file + ">");
        byte[] data = Resources.get("/org/h2/web/res/" + file);
        if (data == null) {
            this.trace(" null");
        } else {
            this.trace(" size=" + data.length);
        }
        return data;
    }

    String getTextFile(String file) throws IOException {
        byte[] bytes = this.getFile(file);
        return new String(bytes);
    }

    private String generateSessionId() {
        byte[] buff = RandomUtils.getSecureBytes(16);
        return ByteUtils.convertBytesToString(buff);
    }

    AppServer getAppServer() {
        return this.appServer;
    }

    WebServerSession getSession(String sessionId) {
        WebServerSession session;
        long now = System.currentTimeMillis();
        if (this.lastTimeoutCheck + 1800000L < now) {
            Object[] list = this.sessions.keySet().toArray();
            for (int i = 0; i < list.length; ++i) {
                String id = (String)list[i];
                WebServerSession session2 = (WebServerSession)this.sessions.get(id);
                Long last = (Long)session2.get("lastAccess");
                if (last == null || last + 1800000L >= now) continue;
                this.trace("timeout for " + id);
                this.sessions.remove(id);
            }
            this.lastTimeoutCheck = now;
        }
        if ((session = (WebServerSession)this.sessions.get(sessionId)) != null) {
            session.lastAccess = System.currentTimeMillis();
        }
        return session;
    }

    WebServerSession createNewSession(Socket socket) {
        String newId;
        while (this.sessions.get(newId = this.generateSessionId()) != null) {
        }
        AppSession session = new AppSession(this);
        session.put("sessionId", newId);
        session.put("ip", socket.getInetAddress().getHostName());
        session.put("language", DEFAULT_LANGUAGE);
        this.sessions.put(newId, session);
        this.readTranslations(session, DEFAULT_LANGUAGE);
        return this.getSession(newId);
    }

    String getStartDateTime() {
        return this.startDateTime;
    }

    public void init(String[] args) throws Exception {
        this.appServer = new AppServer(args);
        SimpleDateFormat format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", new Locale(DEFAULT_LANGUAGE, ""));
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.startDateTime = format.format(new Date());
        this.trace(this.startDateTime);
        for (int i = 0; i < LANGUAGES.length; ++i) {
            this.languages.add(LANGUAGES[i][0]);
        }
        this.port = this.appServer.getPort();
        this.ssl = this.appServer.getSSL();
        this.url = (this.ssl ? "https" : "http") + "://localhost:" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    public void start() throws SQLException {
        this.serverSocket = NetUtils.createServerSocket(this.port, this.ssl);
    }

    public void listen() {
        try {
            while (this.serverSocket != null) {
                Socket s = this.serverSocket.accept();
                AppThread c = new AppThread(s, this);
                c.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = NetUtils.createLoopbackSocket(this.port, this.ssl);
            s.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void stop() {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
    }

    void trace(String s) {
    }

    public boolean supportsLanguage(String language) {
        return this.languages.contains(language);
    }

    public void readTranslations(WebServerSession session, String language) {
        Properties text = new Properties();
        try {
            this.trace("translation: " + language);
            byte[] trans = this.getFile("_text_" + language + ".properties");
            this.trace("  " + trans);
            text.load(new ByteArrayInputStream(trans));
        }
        catch (IOException e) {
            TraceSystem.traceThrowable(e);
        }
        session.put("text", new HashMap<Object, Object>(text));
    }

    public String[][] getLanguageArray() {
        return LANGUAGES;
    }

    public ArrayList getSessions() {
        ArrayList list = new ArrayList(this.sessions.values());
        for (int i = 0; i < list.size(); ++i) {
            WebServerSession s = (WebServerSession)list.get(i);
            list.set(i, s.getInfo());
        }
        return list;
    }

    public boolean getAllowOthers() {
        return this.appServer.getAllowOthers();
    }

    public String getType() {
        return "Web";
    }
}

