package jp.ac.naka.ec.media;

import java.awt.Component;
import java.io.IOException;

import javax.media.MediaException;

import net.sourceforge.jsdp.SessionDescription;

public interface MediaPlayer {

	/**
	 * MpSDP̎擾B
	 * 
	 * @param version
	 * @param userName
	 * @param sessionName
	 * @throws MediaException
	 * @return
	 */
	public String getRequestSessionDescription(int version, String userName,
			String sessionName);

	/**
	 * JMFŃX|X\ȃtH[}bg^CvԂ
	 * 
	 * @param sdp_str
	 */
	public int[] getReceivableFormats(String sdp_str);

	/**
	 * 󂯎\ȃtH[}bg̒ǉ
	 * @param payload
	 */
	public void addAvailableFormat(int payload);

	/**
	 * wSDP琶SDP̎擾
	 * @param sdp_string
	 * @param version
	 * @param userName
	 * @param sessionName
	 * @return
	 */
	public String getResponseSessionDescription(String sdp_string, int version,
			String userName, String sessionName);

	/**
	 * wSDP琶SDP̎擾
	 * @param sdp
	 * @return
	 */
	public SessionDescription getResponseSessionDescription(SessionDescription sdp);
	
	/**
	 * RTPXg[̎M
	 * 
	 * @param sdp_string
	 */
	public void receiveMediaStream(String sdp_string)throws MediaException;

	/**
	 * Lv`Ŏ擾fBARTPɂ鑗MB
	 * 
	 * @param sdp_string
	 * @throws MediaException 
	 */

	public void sendMediaStream(String path, int port) throws  MediaException;
	
	/**
	 * Lv`Ŏ擾fBARTPɂ鑗MB
	 * @param sdp_string
	 * @throws MediaException
	 * @throws IOException
	 */
	public void sendMediaStream(String sdp_string) throws  MediaException, IOException;

	
	/**
	 * t@C擾fBARTPMB
	 * 
	 * @param sdp_String
	 * @param path
	 * @throws MediaException 
	 */
	public void sendMediaStream(String path, int port, String media) throws MediaException;

	/**
	 * RTPfBA̎M~߂B
	 * 
	 */
	public void stopReceivingMediaStream();

	/**
	 * RTPɂ郁fBȂM߂B
	 * 
	 */
	public void stopSendingMediaStream() ;
	
	/**
	 * wSDPŒʐM\ǂ
	 * 
	 * @param sdp_string
	 * @return
	 */
	public boolean isAvailable(String sdp_string);

	/**
	 * I[fBI̎Mǂ̌؁B
	 * 
	 * @return
	 */
	public boolean isPlaying();

	/**
	 * RTPM̂߂̃Rg[擾
	 * @return
	 */
	public Component getTransmitterController();

	/**
	 * RTPM̂߂̃Rg[擾
	 * @return
	 */
	public Component getReceiverController();
	
	/**
	 * M̕`pR|[lg̎擾
	 * @return
	 */
	public Component getVisualComponent();

	/**
	 * I[fBȊMǂ̌؁B
	 * 
	 * @return
	 */
	public boolean isSending();

	/**
	 * MpSDP̎擾
	 * @param user_name@[U
	 * @param session_name@ZbV
	 * @throws MediaException
	 * @return
	 */
	public SessionDescription getRequestSessionDescription(String user_name, String session_name) throws MediaException;

}