/*
 *  Copyright (C) 2006  Takashi Kasuya <kasuya@sfc.keio.ac.jp>
 *
 * This library is free software; you can redistribute it and/or
 *@modify it under the terms of the GNU Lesser General Public
 *@License as published by the Free Software Foundation; either
 *@version 2.1 of the License, or (at your option) any later version.
 *@This library is distributed in the hope that it will be useful,
 *@but WITHOUT ANY WARRANTY; without even the implied warranty of
 *@MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *@Lesser General Public License for more details.
 *
 *@You should have received a copy of the GNU Lesser General Public
 *@License along with this library; if not, write to the Free Software
 *@Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package jp.ac.naka.ec.serial;

import java.util.StringTokenizer;


/**
 * 
 * @author Takashi Kasuya
 * 
 */
public class MoxaInputParserImple implements SerialInputParser {

	/*
	 * (non-Javadoc)
	 * 
	 * @see serial.MoxaSerialInputPerser#parse(java.lang.String)
	 */
	public synchronized MoxaSensorData parse(String str) {
		// RECEIVE: 4 8 2 2420 4 29.4 25
		try {
			StringTokenizer stToken = new StringTokenizer(str, " ,");
			stToken.nextToken();
			int type = Integer.parseInt(stToken.nextToken());
			int seq = Integer.parseInt(stToken.nextToken());
			int srcAddr = Integer.parseInt(stToken.nextToken());
			int srcPanId = Integer.parseInt(stToken.nextToken());
			// f[^
			stToken.nextToken();
			String value = stToken.nextToken();
			int rssi = Integer.parseInt(stToken.nextToken());
			MoxaSensorData data = new MoxaSensorData(type, seq, srcAddr,
					srcPanId, value, rssi);
			return data;
		} catch (Exception e) {
			return null;
		}
	}

	public static void main(String[] args) {
		MoxaInputParserImple parse = new MoxaInputParserImple();
		String str = "RECEIVE: 4 8 2 2420 4 29.4 25";
		System.out.println(parse.parse(str));
	}
}
