/**
 * 
 */
package jp.ac.naka.ec.sip;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

import javax.sip.ListeningPoint;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

import jp.ac.naka.ec.Connector;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityEvent;
import jp.ac.naka.ec.entity.EntityException;

/**
 * @author J
 * 
 */
public class SipConnector implements Connector {

	private final String pathname = "gov.nist";

	private SipCore core;

	private SipListener listener = new DefaultListener();

	private EntityContainer con;

	private static org.apache.log4j.Logger logger = org.apache.log4j.Logger
			.getLogger(SipConnector.class);

	public static String transport = "udp";

	public static int defaultExpires = 360000;

	public static int minimumExpires = 60;

	// PIDFParser parser = null;

	File entityDir;

	/**
	 * 
	 * @param user_name
	 * @param hostname
	 * @param sip_port
	 * @param sip_config
	 * @throws SipException
	 * @throws IOException
	 */
	public SipConnector(String user_name, String hostname, int sip_port,
			String sip_config) throws SipException, IOException {

		SipFactory sipFactory = SipFactory.getInstance();
		sipFactory.setPathName(pathname);

		Properties prop = new Properties();
		prop.load(new FileInputStream(sip_config));
		// v1.2Ŕ񐄏
		// prop.setProperty("javax.sip.IP_ADDRESS", hostname);
		SipStack sipStack = null;
		sipStack = sipFactory.createSipStack(prop);

		try {
			AddressFactory addressFactory = sipFactory.createAddressFactory();

			URI uri = addressFactory.createSipURI(user_name, hostname + ":"
					+ sip_port);
			logger.info("getHostAddress:\t" + uri.toString());

			ListeningPoint lp = sipStack.createListeningPoint(hostname,
					sip_port, "udp");
			// ListeningPoint lp1 =
			// sipStack.createListeningPoint(getPort(),"tcp");

			SipProvider sipProvider = sipStack.createSipProvider(lp);
			// sipProvider.addSipListener();
			// sipProvider = sipStack.createSipProvider(lp1);

			sipProvider.addSipListener(listener);

			//SipCore.initialize(sipFactory, sipStack, sipProvider);
			//SipCore.setURI((SipURI) uri);
			core = SipCore.getInstance();
		} catch (Exception ex) {
			ex.printStackTrace();
			throw new SipException(ex.getMessage());
		}
	}

	public void setEntityContainer(EntityContainer con) {
		this.con = con;
	//	SipCore.setEntityContainer(con);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see jp.ac.naka.ec.struct.Connector#send(jp.ac.naka.ec.entity.EntityEvent)
	 */
	public boolean send(EntityEvent evt) throws EntityException {
		
		Entity target = (Entity) evt.getTarget();
		Entity source = (Entity)evt.getSource();
		boolean flag = false;
		
		if (target == null) {
			throw new EntityException("Target is null");
		}
		
		if (target.isLocal()) {
			return flag;
		}
		
		if (evt.isBroadcast()) {
			for (Entity entity : con.getEntities()) {
				if (entity instanceof EntityContainer && !entity.isLocal()) {
					switch (evt.getEventType()) {
					case MESSAGE:
						try {
							logger.info("Sending SIP MESSAGE to " + entity.getURI());
							core.sendRequest(evt.getMessage(), (EntityContainer) entity, source,
									Request.MESSAGE);
						} catch (Exception e) {
							logger.warn("Error while sending SIP message", e);
							return false;
						}
						flag = true;
						break;
					default:
						logger.warn("not inplemented");
					}
				}
			}
		} else {
			try {
				switch (evt.getEventType()) {
				case REGISTER:
					logger.info("Sending REGISTER to " + target.getURI());
					core.sendRequest((EntityContainer) target,
							Request.REGISTER);
					break;
				case MESSAGE:
					logger.info("Sending MESSAGE to " + target.getURI());
					core.sendRequest(evt.getMessage(), target, source, Request.MESSAGE);
					flag = true;
					break;
				case OFFER:
					logger.info("Sending INVITE to " + target.getURI() + evt.getSessionDescription());
					core.sendRequest(evt.getSessionDescription().toString(), target, source, Request.INVITE);
					flag = true;
					break;
				case BYE:
					logger.info("Sending BYE to " + target.getURI());
					core.sendRequest("", target, source, Request.BYE);
					flag = true;
					break;
				default:
					logger.warn("not inplemented EventType operation:"
							+ evt.getEventType());
				}
			} catch (Exception e) {
				logger.warn("Error while sending SIP message", e);
				return false;
			}
		}
		return flag;
	}
	

}
