package jp.ac.naka.ec.test;

import jp.ac.naka.ec.Main;
import jp.ac.naka.ec.entity.Entity;
import jp.ac.naka.ec.entity.EntityConfigParser;
import jp.ac.naka.ec.entity.test.ButtonEntity;
import junit.framework.TestCase;

public class EntityConfigParserTest extends TestCase {

	EntityConfigParser parser;
	
	@Override
	public void setUp (){
		parser = new EntityConfigParser();
	}
	
	public void testParse() {
		Entity[] entities = null;
		try {
			entities = parser.parse(Main.entity_config);
		} catch (Exception e) {
			fail();
		}
		assertEquals(2, entities.length);
		assertTrue(ButtonEntity.class.equals(entities[0].getClass()));
		assertEquals("test", entities[1].getLocation().getName());
		assertEquals("Button", entities[0].getName());
		assertEquals("test", entities[1].getLocation().getName());
		assertEquals("Dumper", entities[1].getName());
		assertNull(entities[0].getLocation());
	}
}
