/**
 * 
 */
package jp.ac.naka.ec.test;

import java.text.ParseException;

import javax.sip.RequestEvent;
import javax.sip.SipFactory;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;

import jp.ac.naka.ec.entity.EntityContainer;
import jp.ac.naka.ec.entity.EntityContainerImpl;
import jp.ac.naka.ec.entity.EntityEventDispatcher;
import jp.ac.naka.ec.entity.EntityImpl;
import jp.ac.naka.ec.entity.EventDispatcher;
import jp.ac.naka.ec.sip.SubscribeDelegate;
import jp.ac.naka.ec.sip.pidf.PIDFData;
import jp.ac.naka.ec.sip.pidf.PIDFFactory;
import jp.ac.naka.ec.sip.pidf.PIDFFactoryImpl;
import junit.framework.TestCase;

/**
 * @author 
 * 
 */
public class SubscribeTest extends TestCase {
	SubscribeDelegate delegate;

	Request req;
	URI uri;
	EventDispatcher dispatcher;
	HeaderFactory headerFactory;
	@Override
	public void setUp() {
		try {
			delegate = new SubscribeDelegate();

			dispatcher = EntityEventDispatcher.getInstance();
			SipFactory sipFactory = null;
			
			AddressFactory addressFactory;
			MessageFactory messageFactory;

			sipFactory = SipFactory.getInstance();
			sipFactory.setPathName("gov.nist");

			headerFactory = sipFactory.createHeaderFactory();
			addressFactory = sipFactory.createAddressFactory();
			messageFactory = sipFactory.createMessageFactory();
			// If you get a request from a socket, you can use the jsip api to
			// parse it.
			String request = "INVITE sip:00001002000022@p25dr;user=TIA-P25-SU SIP/2.0\r\n"
					+ "CSeq: 1 INVITE\r\n"
					+ "From: <sip:0000100200000c@p25dr;user=TIA-P25-SU>;tag=841\r\n"
					+ "To: <sip:00001002000022@p25dr;user=TIA-P25-SU>\r\n"
					+ "Via: SIP/2.0/UDP 02.002.00001.p25dr;branch=z9hG4bKa10f04383e3d8e8dbf3f6d06f6bb6880\r\n"
					+ "Max-Forwards: 70\r\n"
					+ "Route: <sip:TIA-P25-U2UOrig@01.002.00001.p25dr;lr>,<sip:TIA-P25-U2UDest@03.002.00001.p25dr;lr>\r\n"
					+ "Contact: <sip:02.002.00001.p25dr>\r\n"
					+ "Timestamp: 1154567665687\r\n"
					+ "Allow: REGISTER,INVITE,ACK,BYE,CANCEL\r\n"
					+ "Accept: application/pidf+xml ;level=1,application/x-tia-p25-issi\r\n"
					+ "Event: presence; id=1234\r\n"
					+ "Call-ID: c6a12ddad0ddc1946d9f443c884a7768@127.0.0.1\r\n"
					+ "Content-Type: application/pidf+xml;level=1\r\n" +
							"Expires: 100\r\n"
					+ "Content-Length: 145\r\n\r\n"
					+ "v=0\r\n"
					+ "o=- 30576 0 IN IP4 127.0.0.1\r\n"
					+ "s=TIA-P25-SuToSuCall\r\n"
					+ "t=0 0\r\n"
					+ "c=IN IP4 127.0.0.1\r\n"
					+ "m=audio 12412 RTP/AVP 100\r\n"
					+ "a=rtpmap:100 X-TIA-P25-IMBE/8000\r\n";
			req = messageFactory.createRequest(request);
			uri = addressFactory.createAddress("test@localhost:5060").getURI();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

	public void testDispatchEvent() {
		EntityContainer con = new EntityContainerImpl("test");
		dispatcher.addEntityListener(con);
		//con.setConnector(new DefaultConnector(con));
		con.setURI(uri);
		con.addEntity(new EntityImpl("hoge"));
		
		PIDFFactory fac = new PIDFFactoryImpl(con);
		
		try {
			req.setContent(fac.createPIDF(),headerFactory.createContentTypeHeader(PIDFData.CONTENT_TYPE, PIDFData.CONTENT_SUBTYPE) );
		} catch (ParseException e) {
			e.printStackTrace();
			fail();
		}
		//System.out.println(req.toString());
		RequestEvent evt = new RequestEvent(req, null, null, req);
		assertTrue(delegate.forward(evt));
		assertEquals(2, con.getEntities().size());
	}

	
}
