<?php
/**
 * @package SampleRender
 * @version $Id$
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

class SampleRender_ThemeSelect extends XCube_ActionFilter
{
    function SampleRender_ThemeSelect(&$controller)
    {
		parent::XCube_ActionFilter($controller);
		$controller->mRoot->mDelegateManager->add('Legacy_ThemeSelect.IsSelectableTheme', 'SampleRender_ThemeSelect::isSelectableTheme');
		$controller->mRoot->mDelegateManager->add('LegacyThemeHandler.GetInstalledThemes', 'SampleRender_DelegateFunctions::getInstalledThemes', XOOPS_ROOT_PATH . "/modules/SampleRender/kernel/DelegateFunctions.class.php");
    }
    
    function isSelectableTheme(&$flag, $theme_name)
	{
		if (!$flag) {
			$themeDir = XOOPS_THEME_PATH . "/" . $theme_name;
			if (is_dir($themeDir)) {
				$theme =& new XCube_Theme();
				$theme->mDirname = $theme_name;
						
				if ($theme->loadManifesto($themeDir . "/manifesto.ini.php")) {
					if ($theme->mRenderSystemName == 'SampleRender_RenderSystem') {
						$flag = true;
						return;
					}
				}
			}
		}
    }
}

?>
