/*
 * Decompiled with CFR 0.152.
 */
package org.bbreak.excella.trans.tag.sheet2sql;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Sheet;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.tag.excel2java.ArraysParser;
import org.bbreak.excella.trans.tag.sheet2sql.SqlParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecreateSequenceParser
extends SqlParser {
    public static final String DEFAULT_TAG = "@RecreateSequence";
    protected static final String SQL_DROP_PREFIX = "drop sequence ";
    protected static final String SQL_CREATE_PREFIX = "create sequence ";
    protected static final String SQL_START = " start with ";
    protected static final String SQL_SUFFIX = ";";

    public RecreateSequenceParser() {
        super(DEFAULT_TAG);
    }

    public RecreateSequenceParser(String tag) {
        super(tag);
    }

    @Override
    public List<String> parse(Sheet sheet, Cell tagCell, Object data) throws ParseException {
        ArrayList<String> resultList = new ArrayList<String>();
        ArraysParser arraysParser = new ArraysParser(super.getTag());
        List objList = arraysParser.parse(sheet, tagCell, data);
        for (Object[] obj : objList) {
            try {
                if (obj.length != 2) {
                    throw new ParseException(tagCell, "\u30b7\u30fc\u30b1\u30f3\u30b9\u540d\u3068\u521d\u671f\u3092\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044");
                }
                Object nameObj = obj[0];
                Object valueObj = obj[1];
                if (nameObj == null) {
                    throw new ParseException(tagCell, "\u30b7\u30fc\u30b1\u30f3\u30b9\u540d\u304cnull\u3067\u3059");
                }
                if (valueObj == null) {
                    throw new ParseException(tagCell, "\u521d\u671f\u5024\u304cnull\u3067\u3059");
                }
                String name = nameObj.toString();
                Double valueDouble = Double.parseDouble(valueObj.toString());
                Integer value = valueDouble.intValue();
                resultList.add(this.createSql(name, value));
            }
            catch (Exception e) {
                if (e instanceof ParseException) {
                    throw (ParseException)((Object)e);
                }
                throw new ParseException(tagCell, e.toString());
            }
        }
        return resultList;
    }

    private String createSql(String name, Integer value) {
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(SQL_DROP_PREFIX);
        strBuild.append(name);
        strBuild.append(SQL_SUFFIX);
        strBuild.append("\n");
        strBuild.append(SQL_CREATE_PREFIX);
        strBuild.append(name);
        strBuild.append(SQL_START);
        strBuild.append(value);
        strBuild.append(SQL_SUFFIX);
        return strBuild.toString();
    }
}

