<?php
/**
@breif 󥿥Ƹѥե饹
*/

define("CONTACT_TEXTFIELD_MAXSIZE",50);

class ContactEditForm extends AbstractContactTokenEditForm
{
	var $name_ =null;
	var $email_ =null;
	var $url_ =null;
	var $body_ =null;
	var $icq_ =null;
	var $location_ = null;
	var $company_ = null;
	
	var $ts_;
	
	function ContactEditForm()
	{
		parent::AbstractContactTokenEditForm();
		$this->ts_ = MyTextSanitizer::getInstance();
	}
	
	function fetch(&$xoopsUser)
	{
		parent::fetch($xoopsUser);

		$this->name_ = $this->_check_string_maxsize('name',CONTACT_TEXTFIELD_MAXSIZE,_CT_NAME);
		if(!$this->name_)
			$this->addError(@sprintf(_CT_ERROR_REQUIRE,_CT_NAME));

		$this->email_ = $this->_check_string_maxsize('email',CONTACT_TEXTFIELD_MAXSIZE,_CT_EMAIL);
		if($this->email_ && $this->_validateEmail($this->email_))
				$this->addError(_CT_ERROR_EMAIL_FORMAT);
				
		$this->url_ = $this->_check_string_maxsize('url',CONTACT_TEXTFIELD_MAXSIZE,_CT_URL);
		$this->icq_ = $this->_check_string_maxsize('icq',CONTACT_TEXTFIELD_MAXSIZE,_CT_ICQ);
		$this->company_ = $this->_check_string_maxsize('company',CONTACT_TEXTFIELD_MAXSIZE,_CT_COMPANY);
		$this->location_ = $this->_check_string_maxsize('location',CONTACT_TEXTFIELD_MAXSIZE,_CT_LOCATION);

		$this->body_ = $_POST['body'];
		if(!$this->body_)
			$this->addError(@sprintf(_CT_ERROR_REQUIRE,_CT_COMMENTS));
	}

	function load(&$xoopsUser)
	{
		parent::load($xoopsUser);

		if(is_object($xoopsUser)) {
			$this->name_ = $xoopsUser->getVar('uname','E');
			$this->email_ = $xoopsUser->getVar('email','E');
			$this->url_ = $xoopsUser->getVar('url','E');
			$this->icq_ = $xoopsUser->getVar('user_icq','E');
			$this->location_ = $xoopsUser->getVar('user_from','E');
		}
		parent::load($xoopsUser);
	}

	function getArray()
	{
		$ret=array();
		$ret['name'] = $this->name_;
		$ret['email'] = $this->email_;
		$ret['url'] = $this->url_;
		$ret['body'] = $this->body_;
		$ret['icq'] = $this->icq_;
		$ret['location'] = $this->location_;
		$ret['company'] = $this->company_;

		$ret['token_hidden'] = $this->token_->getHtml();
		
		$ret['err_msg'] = null;
		if($this->isError())
			$ret['err_msg'] = $this->getErrors();
			
		return $ret;
	}

	function _check_string_maxsize($keyname,$size,$name)
	{
		$str = $this->ts_->stripSlashesGPC(trim($_POST[$keyname]));
		if($str && !(count($str)<$size))
			$this->addError(@sprintf(_CT_ERROR_SIZEOVER,$name,$size));
		return $str;
	}
}

?>