fcf.module({
  name: "fcfControls:templates/select.wrapper.js",
  dependencies: ["fcfControls:templates/view.wrapper.js"],
  module: function(BaseControl){
    return class SelectWrapper extends BaseControl{

      constructor(a_initializeOptions){
        super(a_initializeOptions);
        this._cbClose = undefined;
      }

      getActionDomElement(){
        return fcf.select(this.getDomElement(), "input")[0];
      }

      showMenu(a_items) {
        let left = fcf.getOffsetForAbsolute(this.getDomElement()).left;
        var menu = this.getChild("menu");
        menu.setArg("fcfStyle", `position:absolute; left:${left}px; z-index: ${fcf.getModalZIndex()}`);
        menu.setArg("display", "block");
        menu.setArg("width", fcf.width(this.getDomElement()) + "px");
        menu.setArg("titlePattern", this.getArg("titlePattern"));
        menu.setArg("blank", a_items === undefined ? this.getArg("blank") : false);
        menu.setArg("items", a_items ? a_items : this.getArg("items"));
        menu.update();
      }

      hideMenu(){
        this.getChild("menu").close();
      }

      getEnableButton(a_name, a_value){
        var buttons = this.getArg("buttons");
        var button  = buttons[fcf.find(buttons, function(k,v){ return v.name == a_name})];
        if (!button)
          return;
        return !!button.enable;
      }

      setEnableButton(a_name, a_value){
        var buttons = this.getArg("buttons");
        var button  = buttons[fcf.find(buttons, function(k,v){ return v.name == a_name})];
        if (!button)
          return;
        button.enable = a_value;
        this.setArg("buttons", buttons, true);
        var element = this.select("[name='"+button.name+"']")[0];
        if (!element)
          return;
        if (button.enable)
          element.removeAttribute("disabled");
        else
          element.setAttribute("disabled", "disabled");
      }


      onArgValue(a_value){
        var data = this.getArg("items")[a_value];
        this.setArg("data", data, true);
        this.getActionDomElement().value = fcf.str(fcf.pattern(this.getArg("titlePattern"), {value: a_value, data: data}));
        this.getActionDomElement().setAttribute("value", a_value);
        this.emit("change", {value: a_value, data: data});
      }

      onArgData(a_value){
        var data = a_value;
        this.getActionDomElement().value = fcf.pattern(this.getArg("titlePattern"), {value: this.getArg("value"), data: data});
        this.emit("change", {value: this.getArg("value"), data: a_value});
      }

      onArgItems(a_value){
        this._setValue(this.getArg("value"), this.getArg("data"));
        this.update();
      }

      onArgBlank(a_value){
        this._setValue(this.getArg("value"), this.getArg("data"));
        this.update();
      }

      onInput(a_event) {
        var content = this.getActionDomElement().value.toLowerCase();
        var filtredItems = {};
        var patern = this.getArg("titlePattern");
        fcf.each(this.getArg("items"), function(value, data){
          var title = fcf.pattern(patern, {value: value, data: data}).toLowerCase();
          if (title.indexOf(content) != -1)
            filtredItems[value] = data;
        });
        this.showMenu(filtredItems);
      }

      onButtonClick(a_event){
        if (!this.getArg("enable"))
          return;
        var name = a_event.target.getAttribute("name");
        var buttons = this.getArg("buttons");
        var button  = buttons[fcf.find(buttons, function(k,v){ return v.name == name})];
        if (!button)
          return;
        if (button.enable !== undefined && !button.enable)
          return;
        this.emit("button", {button: button.name, target: a_event.target, sender: this});
      }

      onExtend(a_event){
        if (!this.getArg("enable"))
          return;

        if (this.getChild("menu").getArg("display") == "none")
          this.showMenu();
        else
          this.hideMenu();
        this.getActionDomElement().focus();
      }

      onCloseMenu() {
        var data = this.getArg("data");
        this.getActionDomElement().value = fcf.pattern(this.getArg("titlePattern"), {value: this.getArg("value"), data: fcf.str(data)});
      }

      onChange(a_event){
        var value = a_event.value;
        var items = this.getArg("items");
        this._setValue(value, items[value] ? items[value] : "");
        this.update();
      }

      _setValue(a_value, a_data) {
        let items = this.getArg("items");
        let blank = this.getArg("blank");
        if (!blank && !(a_value in items))
          a_value = fcf.firstKey(items);

        this.setArg("value", a_value);
        this.setArg("data", a_value in items ? items[a_value] : a_data);
      }

    };
  }
});
