fcf.module({
  name: "fcf:tests/NFSQL/Parser.update.test.js",
  dependencies: ["fcf:NTest/uniTest.js", "fcf:NFSQL/NDetails/SingleParser.js"],
  module: function(uniTest, Parser) {
    var NTests = fcf.prepareObject(fcf, "NFSQL.NTests");
    var parser = new Parser();

    uniTest.add("001 FSQL", "Parser (UPDATE)", function(a_tester) {
      var data = parser.parse("UPDATE proj SET f1 = ${1} , f2 = ${2} WHERE id = ${3}", [1, 2,100]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}, {field: "f2", value: 2}],
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 100}]}],
          join: [],
          args: {"values[0].value": 1, "values[1].value": 2, "where[0].args[1].value": 3}
        },
        "");

      var data = parser.parse("UPDATE proj SET f1=${1},f2=${2} WHERE id=${3}", [1, 2,100]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}, {field: "f2", value: 2}],
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 100}]}],
          join: [],
          args: {"values[0].value": 1, "values[1].value": 2, "where[0].args[1].value": 3}
        },
        "");

      var data = parser.parse("UPDATE\"proj\"SET\"f1\"=${1},\"f2\"=${2}WHERE\"id\"=${3}", [1, 2,100]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}, {field: "f2", value: 2}],
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 100}]}],
          join: [],
          args: {"values[0].value": 1, "values[1].value": 2, "where[0].args[1].value": 3}
        },
        "");

      var data = parser.parse("UPDATE \"proj\" SET \"f1\" = ${1} , \"f2\" = ${2} WHERE \"id\" = ${3}", [1, 2,100]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}, {field: "f2", value: 2}],
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 100}]}],
          join: [],
          args: {"values[0].value": 1, "values[1].value": 2, "where[0].args[1].value": 3}
        },
        "");

      var data = parser.parse("UPDATE \"proj\" SET \"f1\" = ${1} WHERE \"id\" = ${3}", [1, 2,100]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}],
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 100}]}],
          join: [],
          args: {"values[0].value": 1, "where[0].args[1].value": 3}
        },
        "");

      var data = parser.parse("UPDATE \"proj\" SET \"f1\" = ${1} WHERE \"id\" = ${3} LANGUAGE ru", [1, 2,100]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}],
          where: [{logic: "and", type: "=", args:[{field: "id"}, {value: 100}]}],
          join: [],
          language: "ru",
          args: {"values[0].value": 1, "where[0].args[1].value": 3}
        },
        "");

      var data = parser.parse("UPDATE \"proj\" SET \"f1\" = ${1} LANGUAGE ${2}", [1, "ru"]);
      uniTest.equalObject(
        data,
        {
          type: 'update',
          from: 'proj',
          values: [{field: "f1", value: 1}],
          where: [],
          join: [],
          language: "ru",
          args: {"values[0].value": 1, "language": 2}
        },
        "");

    });

    return NTests;
  }
});
