/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.xerces.dom.AttrImpl;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeferredDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.ElementImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;

public abstract class ChildAndParentNode
extends ChildNode {
    static final long serialVersionUID = 0L;
    protected DocumentImpl ownerDocument;
    protected ChildNode firstChild = null;
    protected transient int nodeListLength = -1;
    protected transient ChildNode nodeListNode;
    protected transient int nodeListIndex = -1;

    protected ChildAndParentNode(DocumentImpl documentImpl) {
        super(documentImpl);
        this.ownerDocument = documentImpl;
    }

    public ChildAndParentNode() {
    }

    public Node cloneNode(boolean bl) {
        ChildAndParentNode childAndParentNode = (ChildAndParentNode)super.cloneNode(bl);
        childAndParentNode.ownerDocument = this.ownerDocument;
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        childAndParentNode.firstChild = null;
        childAndParentNode.nodeListIndex = -1;
        childAndParentNode.nodeListLength = -1;
        if (bl) {
            Node node = this.firstChild;
            while (node != null) {
                childAndParentNode.appendChild(node.cloneNode(true));
                node = node.getNextSibling();
            }
        }
        return childAndParentNode;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    DocumentImpl ownerDocument() {
        return this.ownerDocument;
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        Node node = this.firstChild;
        while (node != null) {
            ((NodeImpl)node).setOwnerDocument(documentImpl);
            node = node.getNextSibling();
        }
        this.ownerDocument = documentImpl;
    }

    public boolean hasChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild != null;
    }

    public NodeList getChildNodes() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this;
    }

    public Node getFirstChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        return this.lastChild();
    }

    final ChildNode lastChild() {
        return this.firstChild != null ? this.firstChild.previousSibling : null;
    }

    final void lastChild(ChildNode childNode) {
        if (this.firstChild != null) {
            this.firstChild.previousSibling = childNode;
        }
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        return this.internalInsertBefore(node, node2, 65535);
    }

    Node internalInsertBefore(Node node, Node node2, int n) throws DOMException {
        Object object;
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        boolean bl = this.ownerDocument.errorChecking;
        if (bl && node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMException(4, "DOM005 Wrong document");
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        if (bl) {
            boolean bl2 = true;
            object = this.parentNode();
            while (bl2 && object != null) {
                bl2 = node != object;
                object = ((NodeImpl)object).parentNode();
            }
            if (!bl2) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            if (node2 != null && node2.getParentNode() != this) {
                throw new DOMException(8, "DOM008 Not found");
            }
        }
        if (node.getNodeType() == 11) {
            Node node3 = node.getFirstChild();
            while (node3 != null) {
                if (bl && !this.ownerDocument.isKidOK(this, node3)) {
                    throw new DOMException(3, "DOM006 Hierarchy request error");
                }
                node3 = node3.getNextSibling();
            }
            while (node.hasChildNodes()) {
                this.insertBefore(node.getFirstChild(), node2);
            }
        } else {
            Object object2;
            Object object3;
            if (!(!bl || node instanceof ChildNode && this.ownerDocument.isKidOK(this, node))) {
                throw new DOMException(3, "DOM006 Hierarchy request error");
            }
            ChildNode childNode = (ChildNode)node;
            object = null;
            if (this.ownerDocument.mutationEvents && (n & 2) != 0) {
                object3 = LCount.lookup("DOMAttrModified");
                if (((LCount)object3).captures + ((LCount)object3).bubbles + ((LCount)object3).defaults > 0) {
                    object = this.getEnclosingAttr();
                }
            }
            if ((object3 = childNode.parentNode()) != null) {
                object3.removeChild(childNode);
            }
            ChildNode childNode2 = (ChildNode)node2;
            childNode.ownerNode = this;
            childNode.isOwned(true);
            if (this.firstChild == null) {
                this.firstChild = childNode;
                childNode.isFirstChild(true);
                childNode.previousSibling = childNode;
            } else if (childNode2 == null) {
                object2 = this.firstChild.previousSibling;
                ((ChildNode)object2).nextSibling = childNode;
                childNode.previousSibling = object2;
                this.firstChild.previousSibling = childNode;
            } else if (node2 == this.firstChild) {
                this.firstChild.isFirstChild(false);
                childNode.nextSibling = this.firstChild;
                childNode.previousSibling = this.firstChild.previousSibling;
                this.firstChild.previousSibling = childNode;
                this.firstChild = childNode;
                childNode.isFirstChild(true);
            } else {
                object2 = childNode2.previousSibling;
                childNode.nextSibling = childNode2;
                ((ChildNode)object2).nextSibling = childNode;
                childNode2.previousSibling = childNode;
                childNode.previousSibling = object2;
            }
            this.changed();
            if (this.nodeListLength != -1) {
                ++this.nodeListLength;
            }
            if (this.nodeListIndex != -1) {
                if (this.nodeListNode == childNode2) {
                    this.nodeListNode = childNode;
                } else {
                    this.nodeListIndex = -1;
                }
            }
            if (this.ownerDocument.mutationEvents) {
                if ((n & 1) != 0) {
                    Object object4;
                    object2 = LCount.lookup("DOMNodeInserted");
                    if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                        object4 = new MutationEventImpl();
                        object4.initMutationEvent("DOMNodeInserted", true, false, this, null, null, null, (short)0);
                        childNode.dispatchEvent((Event)object4);
                    }
                    object2 = LCount.lookup("DOMNodeInsertedIntoDocument");
                    if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                        object4 = this;
                        if (object != null) {
                            object4 = (NodeImpl)((Object)((NodeImpl.EnclosingAttr)object).node.getOwnerElement());
                        }
                        if (object4 != null) {
                            Object object5 = object4;
                            while (object5 != null) {
                                object4 = object5;
                                object5 = ((NodeImpl)object5).getNodeType() == 2 ? (ElementImpl)((AttrImpl)object5).getOwnerElement() : ((NodeImpl)object5).parentNode();
                            }
                            if (((NodeImpl)object4).getNodeType() == 9) {
                                MutationEventImpl mutationEventImpl = new MutationEventImpl();
                                mutationEventImpl.initMutationEvent("DOMNodeInsertedIntoDocument", false, false, null, null, null, null, (short)0);
                                this.dispatchEventToSubtree(childNode, mutationEventImpl);
                            }
                        }
                    }
                }
                if ((n & 2) != 0) {
                    this.dispatchAggregateEvents((NodeImpl.EnclosingAttr)object);
                }
            }
        }
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        return this.internalRemoveChild(node, 65535);
    }

    Node internalRemoveChild(Node node, int n) throws DOMException {
        Object object;
        Object object2;
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.ownerDocument.errorChecking && node != null && node.getParentNode() != this) {
            throw new DOMException(8, "DOM008 Not found");
        }
        this.ownerDocument.removedChildNode(node);
        ChildNode childNode = (ChildNode)node;
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (this.ownerDocument.mutationEvents) {
            object2 = LCount.lookup("DOMAttrModified");
            if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
            if ((n & 1) != 0) {
                object2 = LCount.lookup("DOMNodeRemoved");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = new MutationEventImpl();
                    object.initMutationEvent("DOMNodeRemoved", true, false, this, null, null, null, (short)0);
                    childNode.dispatchEvent((Event)object);
                }
                object2 = LCount.lookup("DOMNodeRemovedFromDocument");
                if (((LCount)object2).captures + ((LCount)object2).bubbles + ((LCount)object2).defaults > 0) {
                    object = this;
                    if (enclosingAttr != null) {
                        object = (NodeImpl)((Object)enclosingAttr.node.getOwnerElement());
                    }
                    if (object != null) {
                        NodeImpl nodeImpl = ((NodeImpl)object).parentNode();
                        while (nodeImpl != null) {
                            object = nodeImpl;
                            nodeImpl = nodeImpl.parentNode();
                        }
                        if (((NodeImpl)object).getNodeType() == 9) {
                            MutationEventImpl mutationEventImpl = new MutationEventImpl();
                            mutationEventImpl.initMutationEvent("DOMNodeRemovedFromDocument", false, false, null, null, null, null, (short)0);
                            this.dispatchEventToSubtree(childNode, mutationEventImpl);
                        }
                    }
                }
            }
        }
        if (this.nodeListLength != -1) {
            --this.nodeListLength;
        }
        if (this.nodeListIndex != -1) {
            if (this.nodeListNode == childNode) {
                --this.nodeListIndex;
                this.nodeListNode = childNode.previousSibling();
            } else {
                this.nodeListIndex = -1;
            }
        }
        if (childNode == this.firstChild) {
            childNode.isFirstChild(false);
            this.firstChild = childNode.nextSibling;
            if (this.firstChild != null) {
                this.firstChild.isFirstChild(true);
                this.firstChild.previousSibling = childNode.previousSibling;
            }
        } else {
            object2 = childNode.previousSibling;
            object = childNode.nextSibling;
            ((ChildNode)object2).nextSibling = object;
            if (object == null) {
                this.firstChild.previousSibling = object2;
            } else {
                ((ChildNode)object).previousSibling = object2;
            }
        }
        childNode.ownerNode = this.ownerDocument;
        childNode.isOwned(false);
        childNode.nextSibling = null;
        childNode.previousSibling = null;
        this.changed();
        if (this.ownerDocument.mutationEvents && (n & 2) != 0) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return childNode;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        NodeImpl.EnclosingAttr enclosingAttr = null;
        if (this.ownerDocument.mutationEvents) {
            LCount lCount = LCount.lookup("DOMAttrModified");
            if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
                enclosingAttr = this.getEnclosingAttr();
            }
        }
        this.internalInsertBefore(node, node2, 1);
        this.internalRemoveChild(node2, 1);
        if (this.ownerDocument.mutationEvents) {
            this.dispatchAggregateEvents(enclosingAttr);
        }
        return node2;
    }

    public int getLength() {
        if (this.nodeListLength == -1) {
            ChildNode childNode;
            if (this.nodeListIndex != -1 && this.nodeListNode != null) {
                this.nodeListLength = this.nodeListIndex;
                childNode = this.nodeListNode;
            } else {
                childNode = this.firstChild;
                this.nodeListLength = 0;
            }
            while (childNode != null) {
                ++this.nodeListLength;
                childNode = childNode.nextSibling;
            }
        }
        return this.nodeListLength;
    }

    public Node item(int n) {
        if (this.nodeListIndex != -1 && this.nodeListNode != null) {
            if (this.nodeListIndex < n) {
                while (this.nodeListIndex < n && this.nodeListNode != null) {
                    ++this.nodeListIndex;
                    this.nodeListNode = this.nodeListNode.nextSibling;
                }
            } else if (this.nodeListIndex > n) {
                while (this.nodeListIndex > n && this.nodeListNode != null) {
                    --this.nodeListIndex;
                    this.nodeListNode = this.nodeListNode.previousSibling();
                }
            }
            return this.nodeListNode;
        }
        this.nodeListNode = this.firstChild;
        this.nodeListIndex = 0;
        while (this.nodeListIndex < n && this.nodeListNode != null) {
            this.nodeListNode = this.nodeListNode.nextSibling;
            ++this.nodeListIndex;
        }
        return this.nodeListNode;
    }

    public void normalize() {
        Node node = this.firstChild;
        while (node != null) {
            node.normalize();
            node = node.getNextSibling();
        }
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (bl2) {
            if (this.needsSyncChildren()) {
                this.synchronizeChildren();
            }
            ChildNode childNode = this.firstChild;
            while (childNode != null) {
                if (!(childNode instanceof EntityReference)) {
                    childNode.setReadOnly(bl, true);
                }
                childNode = childNode.nextSibling;
            }
        }
    }

    protected void synchronizeChildren() {
        this.needsSyncChildren(false);
    }

    protected final void synchronizeChildren(int n) {
        boolean bl = this.ownerDocument.mutationEvents;
        this.ownerDocument.mutationEvents = false;
        this.needsSyncChildren(false);
        DeferredDocumentImpl deferredDocumentImpl = (DeferredDocumentImpl)this.ownerDocument;
        NodeImpl nodeImpl = null;
        ChildNode childNode = null;
        int n2 = deferredDocumentImpl.getLastChild(n);
        while (n2 != -1) {
            ChildNode childNode2 = (ChildNode)((Object)deferredDocumentImpl.getNodeObject(n2));
            if (childNode == null) {
                childNode = childNode2;
            } else {
                ((ChildNode)nodeImpl).previousSibling = childNode2;
            }
            childNode2.ownerNode = this;
            childNode2.isOwned(true);
            childNode2.nextSibling = nodeImpl;
            nodeImpl = childNode2;
            n2 = deferredDocumentImpl.getPrevSibling(n2);
        }
        if (childNode != null) {
            this.firstChild = nodeImpl;
            nodeImpl.isFirstChild(true);
            this.lastChild(childNode);
        }
        deferredDocumentImpl.mutationEvents = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.needsSyncChildren(false);
        this.nodeListLength = -1;
        this.nodeListIndex = -1;
    }
}

