/*
 * Decompiled with CFR 0.152.
 */
package feat2;

import feat2.ResourceManager;
import feat2.StringUtil;
import feat2.Util;
import feat2.config.BasicFileLocator;
import feat2.config.ClassLoaderFileLocator;
import feat2.config.ConfigReader;
import feat2.config.ConfigurationIOException;
import feat2.config.FileLocator;
import feat2.config.Resources;
import feat2.config.URLFileLocator;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileResourceManager
implements ResourceManager {
    private static FileResourceManager defaultRM = null;
    private static final Object lock = new Object();
    private static Log log = LogFactory.getLog((Class)FileResourceManager.class);
    private Resources resources = new Resources();
    private Locale locale;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileResourceManager getInstance() {
        Object object = lock;
        synchronized (object) {
            if (defaultRM == null) {
                try {
                    defaultRM = new FileResourceManager();
                    defaultRM.addResourceFile(new ClassLoaderFileLocator("resources.xml", FileResourceManager.class.getClassLoader()));
                }
                catch (IllegalArgumentException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
                catch (URISyntaxException ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        }
        return defaultRM;
    }

    public FileResourceManager() {
        this(Locale.getDefault());
    }

    public FileResourceManager(Locale locale) {
        this.locale = locale == null ? Util.NULL_LOCALE : locale;
    }

    public void addResourceFile(File file) {
        try {
            this.addResourceFile(new BasicFileLocator(file));
        }
        catch (IllegalArgumentException ex) {
            log.warn((Object)("IllegalArgumentException - " + ex.getMessage()));
        }
    }

    public void addResourceFile(URL url) {
        try {
            this.addResourceFile(new URLFileLocator(url));
        }
        catch (IllegalArgumentException ex) {
            log.warn((Object)("IllegalArgumentException - " + ex.getMessage()));
        }
    }

    public void addResourceFile(String resourceName, ClassLoader loader) {
        try {
            this.addResourceFile(new ClassLoaderFileLocator(resourceName, loader));
        }
        catch (IllegalArgumentException ex) {
            log.warn((Object)("IllegalArgumentException - " + ex.getMessage()));
        }
        catch (URISyntaxException ex) {
            log.warn((Object)("URISyntaxException - " + ex.getMessage()));
        }
    }

    public void addResourceFile(FileLocator file) {
        Resources r = this.load(file);
        this.resources.addResources(r);
    }

    private Resources load(FileLocator file) {
        List seq = Util.expandLocale(this.locale);
        seq.add(Util.NULL_LOCALE);
        Resources ret = null;
        for (int i = 0; i < seq.size(); ++i) {
            Locale loc = (Locale)seq.get(i);
            FileLocator fl = file;
            try {
                if (!loc.equals(Util.NULL_LOCALE)) {
                    String filename = StringUtil.makeLocaleFilename(fl.getFilename(), loc);
                    fl = file.newLocation(filename);
                }
                if (!fl.exists()) continue;
                ret = ConfigReader.parseResource(fl);
                break;
            }
            catch (ConfigurationIOException ex) {
                log.warn((Object)FileResourceManager.getInstance().getString("warn.FileResourceManager.ConfigurationIOException", fl.toString(), null, null), (Throwable)ex);
            }
        }
        return ret;
    }

    public String getString(String name, String param1, String param2, String param3) {
        String ret = this.getStringResource(name);
        if (ret != null) {
            return StringUtil.replaceParameters(ret, new String[]{param1, param2, param3});
        }
        return null;
    }

    public String getStringResource(String name) {
        return this.resources.getString(name, null);
    }
}

