/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.config.ConfigurationException;
import feat2.config.ConfigurationIOException;
import feat2.config.FeatConfig;
import feat2.config.FeatEntityResolver;
import feat2.config.FeatureConfig;
import feat2.config.FeatureRootConfig;
import feat2.config.FileLocator;
import feat2.config.Resources;
import feat2.config.type.Identifier;
import feat2.config.type.IdentifierConverter;
import feat2.config.type.IdentifierList;
import feat2.config.type.IdentifierListConverter;
import feat2.config.type.JavaIdentifier;
import feat2.config.type.JavaIdentifierConverter;
import feat2.config.type.ObjectRef;
import feat2.config.type.ObjectRefConverter;
import feat2.config.type.Scope;
import feat2.config.type.ScopeConverter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class ConfigReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatConfig parseFeatConfig(FileLocator appRoot, FileLocator locator) throws ConfigurationIOException {
        Digester digester = null;
        FeatConfig config = null;
        InputStream in = null;
        try {
            try {
                URL rule = ConfigReader.class.getClassLoader().getResource("feat2/rules/feat-config-rules.xml");
                digester = DigesterLoader.createDigester((URL)rule);
                digester.setEntityResolver((EntityResolver)new FeatEntityResolver());
                digester.setValidating(true);
                ConfigReader.addConverter(digester);
                in = new BufferedInputStream(locator.openInputStream());
                config = (FeatConfig)digester.parse(in);
                config.setAppRootLocator(appRoot);
                config.setConfigFileLocator(locator);
                Iterator it = config.getFeatures();
                while (it.hasNext()) {
                    FeatureConfig fc = (FeatureConfig)it.next();
                    String featureConfigFilename = fc.getConfigFilename();
                    if (featureConfigFilename == null) throw new ConfigurationException("error.config.feature.configFilename.null");
                    FileLocator featureConfigLocator = locator.newLocation(featureConfigFilename);
                    FeatureRootConfig feature = ConfigReader.parseFeature(featureConfigLocator);
                    fc.setFeatureRoot(feature);
                    fc.setConfigFileLocator(featureConfigLocator);
                }
                Object var12_13 = null;
                if (in == null) return config;
            }
            catch (SAXException ex) {
                throw new ConfigurationIOException(ex);
            }
            catch (IOException ex) {
                throw new ConfigurationIOException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ConfigurationIOException(ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new ConfigurationIOException(ex);
        }
        in.close();
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FeatureRootConfig parseFeature(FileLocator file) throws ConfigurationIOException {
        Digester digester = null;
        FeatureRootConfig feature = null;
        InputStream in = null;
        try {
            try {
                digester = DigesterLoader.createDigester((URL)ConfigReader.class.getClassLoader().getResource("feat2/rules/feature-config-rules.xml"));
                digester.setEntityResolver((EntityResolver)new FeatEntityResolver());
                digester.setValidating(true);
                ConfigReader.addConverter(digester);
                in = new BufferedInputStream(file.openInputStream());
                feature = (FeatureRootConfig)digester.parse(in);
            }
            catch (SAXException ex) {
                throw new ConfigurationIOException(ex);
            }
            catch (IOException ex) {
                throw new ConfigurationIOException(ex);
            }
            Object var6_4 = null;
            if (in == null) return feature;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ConfigurationIOException(ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new ConfigurationIOException(ex);
        }
        in.close();
        return feature;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Resources parseResource(FileLocator file) throws ConfigurationIOException {
        Digester digester = null;
        Resources resourcesDecl = null;
        InputStream in = null;
        try {
            try {
                digester = DigesterLoader.createDigester((URL)ConfigReader.class.getClassLoader().getResource("feat2/rules/resource-rules.xml"));
                ConfigReader.addConverter(digester);
                in = new BufferedInputStream(file.openInputStream());
                resourcesDecl = (Resources)digester.parse(in);
            }
            catch (IOException ex) {
                throw new ConfigurationIOException(ex);
            }
            catch (SAXException ex) {
                throw new ConfigurationIOException(ex);
            }
            Object var6_4 = null;
            if (in == null) return resourcesDecl;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ex) {
                throw new ConfigurationIOException(ex);
            }
        }
        try {}
        catch (IOException ex) {
            throw new ConfigurationIOException(ex);
        }
        in.close();
        return resourcesDecl;
    }

    private static void addConverter(Digester digester) {
        ConvertUtils.register((Converter)new IdentifierConverter(), (Class)Identifier.class);
        ConvertUtils.register((Converter)new IdentifierListConverter(), (Class)IdentifierList.class);
        ConvertUtils.register((Converter)new JavaIdentifierConverter(), (Class)JavaIdentifier.class);
        ConvertUtils.register((Converter)new ObjectRefConverter(), (Class)ObjectRef.class);
        ConvertUtils.register((Converter)new ScopeConverter(), (Class)Scope.class);
    }
}

