/*
 * Decompiled with CFR 0.152.
 */
package feat2.config;

import feat2.FeatErrors;
import feat2.Response;
import feat2.config.ConfigError;
import feat2.config.ConfigUtil;
import feat2.config.DIComponentConfig;
import feat2.config.InputConfigBase;
import feat2.config.InputSupport;
import feat2.config.ResponseConfigBase;
import feat2.impl.RedirectResponse;
import java.net.URI;
import java.net.URISyntaxException;

public class RedirectConfig
extends ResponseConfigBase
implements DIComponentConfig {
    private String uri;
    private String method = "get";
    private InputSupport inputs = new InputSupport(this);

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Response getResponseInstance() {
        return new RedirectResponse(this);
    }

    public void addInput(InputConfigBase input) {
        this.inputs.addInput(input);
    }

    public InputConfigBase[] getInputs() {
        return this.inputs.getInputs();
    }

    public InputConfigBase getInputConfig(String propertyName) {
        return this.inputs.getInputConfig(propertyName);
    }

    public String getElementName() {
        return "redirect";
    }

    public boolean validate(FeatErrors errs) {
        boolean ret = super.validate(errs);
        boolean bl = ret = ret && ConfigUtil.validateRequired(this.uri, "uri", this, errs);
        if (this.uri != null) {
            try {
                new URI(this.uri);
            }
            catch (URISyntaxException ex) {
                errs.add(new ConfigError(this.uri, "uri", "error_uri_syntax", 10, this));
            }
        }
        if (!this.method.equalsIgnoreCase("get") && !this.method.equalsIgnoreCase("post")) {
            ret = false;
            ConfigError err = new ConfigError(this.method, "method", "value", 10, this);
            err.addKeyrowd("range", "\"post\", \"get\"");
            errs.add(err);
        }
        ret = ret && this.inputs.validate(errs);
        return ret;
    }
}

